/*
  Copyright(C) 2002-2007 Pierre Mazire
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
  General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/
/* memalloc.c

   Safer memory allocation functions */

#include "common.h"
#include <stdio.h>
#include "memalloc.h"

#ifndef NDEBUG
typedef struct memalloc_s
{
  void *p;
  size_t size;
  char *file; /* TODO :keep a list of involved files and point to one entry */
  unsigned long line;
} memalloc_t;


#define MEMALLOC_CHUNKS 50;
memalloc_t **memallocs=NULL;
unsigned int memalloc_chunk_nb=0;
unsigned int memalloc_nb=0;

unsigned int record_memalloc=0;
#endif /* NDEBUG */

inline void *xmalloc(size_t num,char* file,int line)
{
  void *new=malloc(num);
  if(new==NULL)
    fprintf(stderr,"[%s:%i] memory allocation failed\n",file,line);

  /* TODO: rewrite with string list */
  /* TODO: write the corresponding xfree function */
  /*
#ifndef NDEBUG
  {
    void *tmpptr=NULL;
    if(new && record_memalloc)
      {
	if(!memallocs || 
	   memalloc_nb>(memalloc_chunk_nb*MEMALLOC_CHUNKS))
	  {
	    tmpptr=realloc(memallocs,sizeof(memalloc_t*)*MEMALLOC_CHUNKS);
	    if(!tmpptr)
	      {
		fprintf(stderr,"[%s:%i] memory reallocation failed\n",
			__FILE__,__LINE__);
		return new;
	      };
	    memallocs=tmpptr;
	    for(i=memalloc_nb;i<memalloc_nb+MEMALLOC_CHUNKS;i++)
	      {
		memallocs[i]=calloc(1,sizeof(memalloc_t));
		  if(!memallocs[i])
		    {
		      fprintf(stderr,"[%s:%i] memory allocation failed\n",
			      __FILE__,__LINE__);
		      break;
		    };
	      };
	    memalloc_chunk_nb++;
	  };
	
	if(memallocs[memalloc_nb])
	    {
	      memallocs[memalloc_nb]->p=new;
	      memallocs[memalloc_nb]->size=num;
	      memallocs[memalloc_nb]->file=strdup(__FILE__);
	      memallocs[memalloc_nb]->line=__LINE__;
	      memalloc_nb++;
	    };
      };
  };
#endif
*/
  return new;
};

inline void *xrealloc(void *p,size_t num,char* file, int line)
{
  void *new=NULL;
  if(p==NULL)
    return xmalloc(num,file,line);
  new=realloc(p,num);
  if(new==NULL && num!=0)
    fprintf(stderr,"[%s:%i] memory reallocation failed\n",file,line);
  return new;
};

inline void *xcalloc(size_t num, size_t size,char* file, int line)
{
  void *new=xmalloc(num*size,file,line);
  memset(new,0,num*size);
  return new;
}

inline char *xstrdup(const char *string,char *file, int line)
{
  char *result;

  if(!string)
    return (char*)0;

  result=((char*)xcalloc(strlen(string)+1,sizeof(char),file,line));

  if(result==(char*)0)
    return(char*)0;
  strncpy(result,string,strlen(string));
  return result;
}
