/*
  Copyright(C) 2002-2007 Pierre Mazire
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
  General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/

/*
  libprint.c

  libraries specific messages functions
*/

#include <stdio.h>
#include <stdarg.h>
#include <string.h>
#include <common/common.h>
#include "libprint.h"

int lprintf(FILE *lib_fp,
	    unsigned char *libname,
	    unsigned int Header,
	    unsigned int Header_Libname,
	    unsigned int Wait,
	    unsigned int Type, 
	    char *file, int line,
	    unsigned char *String,...)
{
  static unsigned int error_waiting=FALSE;
  static unsigned int warning_waiting=FALSE;
  static unsigned int debug_waiting=FALSE;  
  static unsigned int output_waiting=FALSE;

  va_list ap;
  unsigned int printed=0;

  //  if((Type==LIB_DEBUG || Header==TRUE) && waiting==FALSE)
  if(Type==LIB_DEBUG || Header==TRUE)
    {
      switch(Type)
	{
	case LIB_WARNING:
	  if(warning_waiting==FALSE)
	    printed+=fprintf(lib_fp,"[WARNING] ");
	  break;
	  
	case LIB_ERROR:
	  if(error_waiting==FALSE)
	    printed+=fprintf(lib_fp,"[ERROR] ");
	  break;
	  
	case LIB_DEBUG:
#ifndef NDEBUG
	  if(Header==TRUE && debug_waiting==FALSE)
	    printed+=fprintf(lib_fp,"[DEBUG] ");
#else
	  return 0;
#endif
	  break;
	  
	case LIB_OUTPUT:
	  if(output_waiting==FALSE)
	    printed+=fprintf(lib_fp,"[OUTPUT] ");
	  break;
	};
    };      
      
  if(Type==LIB_DEBUG || Header_Libname==TRUE)
    printed+=fprintf(lib_fp,"%s ",libname);

#ifndef NDEBUG
  if(Type==LIB_DEBUG)
    printed+=fprintf(lib_fp,"(%s:%i)",file,line);
#endif

  if(printed!=0)
    printed+=fprintf(lib_fp,": ");

#ifdef NDEBUG
  if(Header==FALSE && Type==LIB_DEBUG)
    return 0;
#endif

  va_start(ap,String);
  printed+=vfprintf(lib_fp,String,ap);
  va_end(ap);

  if(Wait==FALSE)
    {
      printed+=fprintf(lib_fp,"\n");
      switch(Type)
	{
	case LIB_WARNING: warning_waiting=FALSE; break;
	case LIB_ERROR: error_waiting=FALSE; break;
	case LIB_DEBUG: debug_waiting=FALSE; break;
	case LIB_OUTPUT: output_waiting=FALSE; break;
	};
    }
  else
    {
      fflush(lib_fp);
      switch(Type)
	{
	case LIB_WARNING: warning_waiting=TRUE; break;
	case LIB_ERROR: error_waiting=TRUE; break;
	case LIB_DEBUG: debug_waiting=TRUE; break;
	case LIB_OUTPUT: output_waiting=TRUE; break;
	};
    };
  return printed;  
}  
	    
  
    
