/*
	file automatically generated by make_test_files.pl
	Tue Apr 19 14:01:03 2011
*/

/*****************************************************************************
 *                                                                           *
 *          UNU.RAN -- Universal Non-Uniform Random number generator         *
 *                                                                           *
 *****************************************************************************/
    
/**
 ** Tests for MVTDR
 **/
    
/*---------------------------------------------------------------------------*/
#include "testunuran.h"

#ifdef UNUR_URNG_DEFAULT_RNGSTREAM
#include <RngStream.h>
#endif
/*---------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------*/
/* global variables                                                          */

static FILE *TESTLOG;               /* test log file                         */
static FILE *UNURANLOG;             /* unuran log file                       */

static int test_ok = TRUE;          /* all tests ok (boolean)                */
static int fullcheck = FALSE;       /* whether all checks are performed      */ 

static TIMER watch;                 /* stop watch                            */

/*---------------------------------------------------------------------------*/

void run_verify_generator( FILE *LOG, int line, UNUR_PAR *par );



/*---------------------------------------------------------------------------*/

void test_new (void);
void test_set (void);
void test_get (void);
void test_chg (void);
void test_init (void);
void test_reinit (void);
void test_sample (void);
void test_validate (void);
void test_special(void);

/*---------------------------------------------------------------------------*/



/* prototypes */

int unur_mvtdr_set_pedantic( UNUR_PAR *par, int pedantic );

#define COMPARE_SAMPLE_SIZE   (9999)
#define VIOLATE_SAMPLE_SIZE   (20)

double pdf_normal(const double *coord, UNUR_DISTR *distr);
int dpdf_normal(double *grad, const double *coord, UNUR_DISTR *distr);

double logpdf_normal(const double *coord, UNUR_DISTR *distr);
int dlogpdf_normal(double *grad, const double *coord, UNUR_DISTR *distr);


/* we need marginal distributions for the chi2 tests */
#define unur_distr_multicauchy   unur_distr_multicauchy_w_marginals
#define unur_distr_multinormal   unur_distr_multinormal_w_marginals
#define unur_distr_multistudent  unur_distr_multistudent_w_marginals





/*---------------------------------------------------------------------------*/

#ifndef CHI2_FAILURES_TOLERATED
#  define CHI2_FAILURES_TOLERATED DEFAULT_CHI2_FAILURES_TOLERATED
#endif

/*---------------------------------------------------------------------------*/
/* [verbatim] */



/* dummy function */
int unur_mvtdr_set_pedantic( UNUR_PAR *par ATTRIBUTE__UNUSED, int pedantic ATTRIBUTE__UNUSED)
{ return 1; }

/*-----------------------------------------------------------------*/

double pdf_normal(const double *coord, UNUR_DISTR *distr ATTRIBUTE__UNUSED)
/* multinormal density function */
{	
  int i;
  double f = 0.;

  for( i=0; i<3; i++ )
    f += coord[i] * coord[i];

  return( exp(-f) );
} /* end of pdf_normal() */


int dpdf_normal(double *grad, const double *coord, UNUR_DISTR *distr ATTRIBUTE__UNUSED)
/* gradient of multinormal density function */
{
  int i;
  double f = 0.;

  /* d(e^{-\sum j*x_j^2})/d x_i = -2*x_i*e^{-\sum j*x_j^2} */

  for( i=0; i<3; i++ )
    f += coord[i] * coord[i];
  f = exp( -f );

  for( i=0; i<3; i++ )
    grad[i] = (-2) * coord[i] * f;

  return 0;

} /* end of dpdf_normal() */


/*-----------------------------------------------------------------*/

double logpdf_normal(const double *coord, UNUR_DISTR *distr ATTRIBUTE__UNUSED)
/* multinormal density function */
{	
  int i;
  double f = 0.;

  for( i=0; i<3; i++ )
    f += coord[i] * coord[i];

  return (-f);
} /* end of logpdf_normal() */


int dlogpdf_normal(double *grad, const double *coord, UNUR_DISTR *distr ATTRIBUTE__UNUSED)
/* gradient of multinormal density function */
{
  int i;

  /* d(e^{-\sum j*x_j^2})/d x_i = -2*i*x_i*e^{-\sum j*x_j^2} */

  for( i=0; i<3; i++ )
    grad[i] = -2 * coord[i];

  return 0;

} /* end of dlogpdf_normal() */

/*---------------------------------------------------------------------------*/
/* [new] */

void test_new (void)
{
        int n_tests_failed;          /* number of failed tests */

	/* start test */
	printf("[new "); fflush(stdout);
	fprintf(TESTLOG,"\n[new]\n");

	/* reset counter */
	n_tests_failed = 0;

	/* set stop watch */
	stopwatch_lap(&watch);
  
{ /* invalid NULL ptr */
UNUR_DISTR *distr = NULL;
   distr = NULL; 


unur_reset_errno();
n_tests_failed += (check_expected_NULL(TESTLOG,41,(unur_mvtdr_new( distr )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,41,UNUR_ERR_NULL)==UNUR_SUCCESS)?0:1;
unur_distr_free(distr);
}

{ /* invalid distribution type */
UNUR_DISTR *distr = NULL;
   distr = unur_distr_discr_new(); 


unur_reset_errno();
n_tests_failed += (check_expected_NULL(TESTLOG,48,(unur_mvtdr_new( distr )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,48,UNUR_ERR_DISTR_INVALID)==UNUR_SUCCESS)?0:1;
unur_distr_free(distr);
}

{ /* invalid number of dimensions */
UNUR_DISTR *distr = NULL;
   distr = unur_distr_cvec_new(1); 


unur_reset_errno();
n_tests_failed += (check_expected_NULL(TESTLOG,54,(unur_mvtdr_new( distr )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,54,UNUR_ERR_DISTR_PROP)==UNUR_SUCCESS)?0:1;
unur_distr_free(distr);
}

{ /* missing data */
UNUR_DISTR *distr = NULL;
    distr = unur_distr_cvec_new(3); 


unur_reset_errno();
n_tests_failed += (check_expected_NULL(TESTLOG,61,(unur_mvtdr_new( distr )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,61,UNUR_ERR_DISTR_REQUIRED)==UNUR_SUCCESS)?0:1;
unur_distr_free(distr);
}

{ /* missing data */
UNUR_DISTR *distr = NULL;
    distr = unur_distr_cvec_new(3); 
    unur_distr_cvec_set_pdf(distr,pdf_normal); 


unur_reset_errno();
n_tests_failed += (check_expected_NULL(TESTLOG,69,(unur_mvtdr_new( distr )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,69,UNUR_ERR_DISTR_REQUIRED)==UNUR_SUCCESS)?0:1;
unur_distr_free(distr);
}

{ /* missing data */
UNUR_DISTR *distr = NULL;
    distr = unur_distr_cvec_new(3); 
    unur_distr_cvec_set_logpdf(distr,logpdf_normal); 


unur_reset_errno();
n_tests_failed += (check_expected_NULL(TESTLOG,77,(unur_mvtdr_new( distr )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,77,UNUR_ERR_DISTR_REQUIRED)==UNUR_SUCCESS)?0:1;
unur_distr_free(distr);
}


	/* timing */
	stopwatch_print(TESTLOG,"\n<*>time = %.3f ms\n\n", stopwatch_lap(&watch));

	/* test finished */
	test_ok &= (n_tests_failed) ? 0 : 1;
	(n_tests_failed) ? printf(" ==> failed] ") : printf(" ==> ok] ");

} /* end of test_new() */

/*---------------------------------------------------------------------------*/
/* [set] */

void test_set (void)
{
        int n_tests_failed;          /* number of failed tests */

	/* start test */
	printf("[set "); fflush(stdout);
	fprintf(TESTLOG,"\n[set]\n");

	/* reset counter */
	n_tests_failed = 0;

	/* set stop watch */
	stopwatch_lap(&watch);
  
{ /* invalid NULL ptr */
UNUR_PAR   *par = NULL;
    par = NULL; 


unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,89,(unur_mvtdr_set_stepsmin( par, 5 )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,89,UNUR_ERR_NULL)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,92,(unur_mvtdr_set_maxcones( par, 5000 )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,92,UNUR_ERR_NULL)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,95,(unur_mvtdr_set_verify( par, 1 )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,95,UNUR_ERR_NULL)==UNUR_SUCCESS)?0:1;
}

{ /* invalid parameter object */
UNUR_DISTR *distr = NULL;
UNUR_PAR   *par = NULL;
   distr = unur_distr_normal(NULL,0);
   par = unur_arou_new(distr); 


unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,103,(unur_mvtdr_set_stepsmin( par, 5 )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,103,UNUR_ERR_PAR_INVALID)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,106,(unur_mvtdr_set_maxcones( par, 5000 )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,106,UNUR_ERR_PAR_INVALID)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,109,(unur_mvtdr_set_verify( par, 1 )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,109,UNUR_ERR_PAR_INVALID)==UNUR_SUCCESS)?0:1;
unur_par_free(par);
unur_distr_free(distr);
}

{ /* invalid parameters */
UNUR_DISTR *distr = NULL;
UNUR_PAR   *par = NULL;
   distr = unur_distr_multinormal( 3, NULL, NULL );
   par = unur_mvtdr_new(distr); 


unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,119,(unur_mvtdr_set_stepsmin( par, -1 )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,119,UNUR_ERR_PAR_SET)==UNUR_SUCCESS)?0:1;
unur_par_free(par);
unur_distr_free(distr);
}


	/* timing */
	stopwatch_print(TESTLOG,"\n<*>time = %.3f ms\n\n", stopwatch_lap(&watch));

	/* test finished */
	test_ok &= (n_tests_failed) ? 0 : 1;
	(n_tests_failed) ? printf(" ==> failed] ") : printf(" ==> ok] ");

} /* end of test_set() */

/*---------------------------------------------------------------------------*/
/* [get] */

void test_get (void)
{
        int n_tests_failed;          /* number of failed tests */

	/* start test */
	printf("[get "); fflush(stdout);
	fprintf(TESTLOG,"\n[get]\n");

	/* reset counter */
	n_tests_failed = 0;

	/* set stop watch */
	stopwatch_lap(&watch);
  
{ /* invalid NULL ptr */
UNUR_GEN   *gen = NULL;
    gen = NULL; 


unur_reset_errno();
n_tests_failed += (check_expected_INFINITY(TESTLOG,132,(unur_mvtdr_get_hatvol(gen)))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,132,UNUR_ERR_NULL)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_zero(TESTLOG,135,(unur_mvtdr_get_ncones(gen)))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,135,UNUR_ERR_NULL)==UNUR_SUCCESS)?0:1;
unur_free(gen);
}

{ /* invalid generator object */
UNUR_DISTR *distr = NULL;
UNUR_PAR   *par = NULL;
UNUR_GEN   *gen = NULL;
   distr = unur_distr_normal(NULL,0);
   par = unur_arou_new(distr);
   gen = unur_init(par); 
abort_if_NULL(TESTLOG, 140,    gen );


unur_reset_errno();
n_tests_failed += (check_expected_INFINITY(TESTLOG,144,(unur_mvtdr_get_hatvol(gen)))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,144,UNUR_ERR_GEN_INVALID)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_zero(TESTLOG,147,(unur_mvtdr_get_ncones(gen)))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,147,UNUR_ERR_GEN_INVALID)==UNUR_SUCCESS)?0:1;
unur_distr_free(distr);
unur_free(gen);
}


	/* timing */
	stopwatch_print(TESTLOG,"\n<*>time = %.3f ms\n\n", stopwatch_lap(&watch));

	/* test finished */
	test_ok &= (n_tests_failed) ? 0 : 1;
	(n_tests_failed) ? printf(" ==> failed] ") : printf(" ==> ok] ");

} /* end of test_get() */

/*---------------------------------------------------------------------------*/
/* [chg] */

void test_chg (void)
{
        int n_tests_failed;          /* number of failed tests */

	/* start test */
	printf("[chg "); fflush(stdout);
	fprintf(TESTLOG,"\n[chg]\n");

	/* reset counter */
	n_tests_failed = 0;

	/* set stop watch */
	stopwatch_lap(&watch);
  
{ /* invalid generator object */
UNUR_GEN   *gen = NULL;
   gen = NULL; 


unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,158,(unur_mvtdr_chg_verify(gen,1)))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,158,UNUR_ERR_NULL)==UNUR_SUCCESS)?0:1;
unur_free(gen);
}

{ /* invalid generator object */
UNUR_DISTR *distr = NULL;
UNUR_PAR   *par = NULL;
UNUR_GEN   *gen = NULL;
   double fpar[2] = {0.,1.};
   distr = unur_distr_normal(fpar,2);
   par = unur_srou_new(distr);
   unur_set_debug(par,0);
   gen = unur_init( par ); 
abort_if_NULL(TESTLOG, 165,    gen );


unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,169,(unur_mvtdr_chg_verify(gen,1)))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,169,UNUR_ERR_GEN_INVALID)==UNUR_SUCCESS)?0:1;
unur_distr_free(distr);
unur_free(gen);
}


	/* timing */
	stopwatch_print(TESTLOG,"\n<*>time = %.3f ms\n\n", stopwatch_lap(&watch));

	/* test finished */
	test_ok &= (n_tests_failed) ? 0 : 1;
	(n_tests_failed) ? printf(" ==> failed] ") : printf(" ==> ok] ");

} /* end of test_chg() */

/*---------------------------------------------------------------------------*/
/* [reinit] */

void test_reinit (void)
{
        int n_tests_failed;          /* number of failed tests */

	/* start test */
	printf("[reinit "); fflush(stdout);
	fprintf(TESTLOG,"\n[reinit]\n");

	/* reset counter */
	n_tests_failed = 0;

	/* set stop watch */
	stopwatch_lap(&watch);
  
{ /* does not exist */
UNUR_DISTR *distr = NULL;
UNUR_PAR   *par = NULL;
UNUR_GEN   *gen = NULL;
   double x[3];
   distr = unur_distr_multinormal(3,NULL,NULL);
   par = unur_mvtdr_new(distr);
   gen = unur_init( par ); 
abort_if_NULL(TESTLOG, 183,    gen );


unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,187,(unur_reinit( gen )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,187,UNUR_ERR_NO_REINIT)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
unur_sample_vec( gen, x );
n_tests_failed += (check_expected_INFINITY(TESTLOG,191,(x[0]))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,191,UNUR_ERR_GEN_CONDITION)==UNUR_SUCCESS)?0:1;
unur_distr_free(distr);
unur_free(gen);
}


	/* timing */
	stopwatch_print(TESTLOG,"\n<*>time = %.3f ms\n\n", stopwatch_lap(&watch));

	/* test finished */
	test_ok &= (n_tests_failed) ? 0 : 1;
	(n_tests_failed) ? printf(" ==> failed] ") : printf(" ==> ok] ");

} /* end of test_reinit() */

/*---------------------------------------------------------------------------*/
/* [sample] */

void test_sample (void)
{
        int n_tests_failed;          /* number of failed tests */

	/* start test */
	printf("[sample "); fflush(stdout);
	fprintf(TESTLOG,"\n[sample]\n");

	/* reset counter */
	n_tests_failed = 0;

	/* set stop watch */
	stopwatch_lap(&watch);
  
{ /* test clone */
UNUR_DISTR *distr = NULL;
UNUR_PAR   *par = NULL;
UNUR_GEN   *gen = NULL;
   const int dim = 3;
   double mean[] = {1.,2.,3.};
   double covar[] = { 2., 2., 1.,   2., 4., 3.,   1., 3., 3. };
   UNUR_GEN *clone;
   distr = unur_distr_multinormal( dim, mean, covar );
   par = unur_mvtdr_new(distr);
   gen = unur_init( par ); 
abort_if_NULL(TESTLOG, 204,    gen );


unur_reset_errno();
;
n_tests_failed += (compare_sequence_gen_start(TESTLOG,207,gen,COMPARE_SAMPLE_SIZE)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
/* clone */
clone = unur_gen_clone(gen);
unur_free(gen);
gen = clone;
n_tests_failed += (compare_sequence_gen(TESTLOG,213,gen,COMPARE_SAMPLE_SIZE)==UNUR_SUCCESS)?0:1;
unur_distr_free(distr);
unur_free(gen);
}


	/* timing */
	stopwatch_print(TESTLOG,"\n<*>time = %.3f ms\n\n", stopwatch_lap(&watch));

	/* test finished */
	test_ok &= (n_tests_failed) ? 0 : 1;
	(n_tests_failed) ? printf(" ==> failed] ") : printf(" ==> ok] ");

} /* end of test_sample() */

/*---------------------------------------------------------------------------*/
/* [validate] */

/*---------------------------------------------------------------------------*/

/* [validate] */

void test_validate (void)
{
	UNUR_DISTR *distr[39];
	UNUR_PAR *par;
	UNUR_GEN *gen;
	int n_tests_failed;
	int rcode;
	double *darray;
	double fpm[10];

	rcode = 0;

	/* start test */
	printf("[validate "); fflush(stdout);
	fprintf(TESTLOG,"\n[validate]\n");

	/* reset counter */
	n_tests_failed = 0;

	/* set stop watch */
	stopwatch_lap(&watch);


/* distributions: 39 */
{
distr[0] = unur_distr_multinormal(2,NULL,NULL);
}

{
distr[1] = unur_distr_multinormal(3,NULL,NULL);
}

{
distr[2] = unur_distr_multinormal(4,NULL,NULL);
}

{
distr[3] = unur_distr_multinormal(5,NULL,NULL);
}

{
distr[4] = unur_distr_multinormal(6,NULL,NULL);
}

{
distr[5] = unur_distr_multinormal(7,NULL,NULL);
}

{
{double ll[2] = {-1.,-1.};
 double ru[2] = { 1., 1.};
 distr[6] = unur_distr_multinormal(2,NULL,NULL);
 unur_distr_cvec_set_domain_rect(distr[6],ll,ru); }
}

{
{double ll[3] = {-.1,-.1,-.1};
 double ru[3] = { 1., 1., 1.};
 distr[7] = unur_distr_multinormal(3,NULL,NULL);
 unur_distr_cvec_set_domain_rect(distr[7],ll,ru); }
}

{
{double ll[3] = {-.1,-.1,-.1};
 double ru[3] = {UNUR_INFINITY,UNUR_INFINITY,UNUR_INFINITY};
 distr[8] = unur_distr_multinormal(3,NULL,NULL);
 unur_distr_cvec_set_domain_rect(distr[8],ll,ru); }
}

{
{double ll[3] = {-UNUR_INFINITY,-UNUR_INFINITY,-UNUR_INFINITY};
 double ru[3] = {0.1,0.1,0.1};
 distr[9] = unur_distr_multinormal(3,NULL,NULL);
 unur_distr_cvec_set_domain_rect(distr[9],ll,ru); }
}

{
{double ll[6] = {-1.,-1.,-1.,-1.,-1.,-1.};
 double ru[6] = { 1., 1., 1., 1., 1., 1.};
 distr[10] = unur_distr_multinormal(6,NULL,NULL);
 unur_distr_cvec_set_domain_rect(distr[10],ll,ru); }
}

{
{double mean[]  = { 10., 20., 30.};
 double covar[] = { 2., 2., 1.,   2., 4., 3.,   1., 3., 3. };
 distr[11] = unur_distr_multinormal(3,mean,covar); }
}

{
distr[12] = unur_distr_multinormal_ar1(3,NULL,0.9);
}

{
distr[13] = unur_distr_multinormal_ar1(4,NULL,0.9);
}

{
distr[14] = unur_distr_multinormal_ar1(5,NULL,0.9);
}

{
distr[15] = unur_distr_multinormal_ar1(6,NULL,0.5);
}

{
distr[16] = unur_distr_multinormal_ar1(7,NULL,0.3);
}

{
{double mean[]  = { -1., -2., -3., 4., 5., 6., 7., 8., 9., 10. };
 distr[17] = unur_distr_multinormal_ar1(3,mean,0.9); }
}

{
{double mean[]  = { -1., -2., -3., 4., 5., 6., 7., 8., 9., 10. };
 distr[18] = unur_distr_multinormal_ar1(4,mean,0.9); }
}

{
{double mean[]  = { -1., -2., -3., 4., 5., 6., 7., 8., 9., 10. };
 distr[19] = unur_distr_multinormal_ar1(5,mean,0.9); }
}

{
distr[20] = unur_distr_multinormal_constantrho(3,NULL,0.99);
}

{
distr[21] = unur_distr_multinormal_constantrho(4,NULL,0.9);
}

{
distr[22] = unur_distr_multinormal_constantrho(5,NULL,0.5);
}

{
{double ll[3] = {-.1,-.1,-.1};
 double ru[3] = { 1., 1., 1.};
 distr[23] = unur_distr_multinormal_ar1(3,NULL,0.9);
 unur_distr_cvec_set_domain_rect(distr[23],ll,ru); }
}

{
{double ll[3] = { 0., 0., 0.};
 double ru[3] = { 1., 1., 1.};
 distr[24] = unur_distr_multinormal_ar1(3,NULL,0.9);
 unur_distr_cvec_set_domain_rect(distr[24],ll,ru); }
}

{
{double ll[3] = {-1.,-1.,-1.};
 double ru[3] = { 0., 0., 0.};
 distr[25] = unur_distr_multinormal_ar1(3,NULL,0.9);
 unur_distr_cvec_set_domain_rect(distr[25],ll,ru); }
}

{
{double ll[3] = {-1., 0.,-1.};
 double ru[3] = { 0., 1., 0.};
 distr[26] = unur_distr_multinormal_ar1(3,NULL,0.9);
 unur_distr_cvec_set_domain_rect(distr[26],ll,ru); }
}

{
{double ll[3] = { 0., 0., 0.};
 double ru[3] = { UNUR_INFINITY, UNUR_INFINITY, UNUR_INFINITY};
 distr[27] = unur_distr_multinormal_ar1(3,NULL,0.9);
 unur_distr_cvec_set_domain_rect(distr[27],ll,ru); }
}

{
{double ll[3] = { -UNUR_INFINITY, -UNUR_INFINITY, -UNUR_INFINITY};
 double ru[3] = { 0., 0., 0.};
 distr[28] = unur_distr_multinormal_ar1(3,NULL,0.9);
 unur_distr_cvec_set_domain_rect(distr[28],ll,ru); }
}

{
{double ll[3] = { -UNUR_INFINITY, -UNUR_INFINITY, -UNUR_INFINITY};
 double ru[3] = { 0., 0., UNUR_INFINITY};
 distr[29] = unur_distr_multinormal_ar1(3,NULL,0.9);
 unur_distr_cvec_set_domain_rect(distr[29],ll,ru); }
}

{
{double ll[3] = {-1.,-1.,-1.};
 double ru[3] = { UNUR_INFINITY, UNUR_INFINITY, UNUR_INFINITY};
 distr[30] = unur_distr_multinormal_ar1(3,NULL,0.9);
 unur_distr_cvec_set_domain_rect(distr[30],ll,ru); }
}

{
{double ll[3] = {-.1,-.1,-.1};
 double ru[3] = { 1., 1., 1.};
 distr[31] = unur_distr_multinormal(3,NULL,NULL);
 unur_distr_cvec_set_domain_rect(distr[31],ll,ru); }
}

{
{double ll[3] = { 0., 0., 0.};
 double ru[3] = { 1., 1., 1.};
 distr[32] = unur_distr_multinormal(3,NULL,NULL);
 unur_distr_cvec_set_domain_rect(distr[32],ll,ru); }
}

{
{double ll[3] = {-1.,-1.,-1.};
 double ru[3] = { 0., 0., 0.};
 distr[33] = unur_distr_multinormal(3,NULL,NULL);
 unur_distr_cvec_set_domain_rect(distr[33],ll,ru); }
}

{
{double ll[3] = {-1., 0.,-1.};
 double ru[3] = { 0., 1., 0.};
 distr[34] = unur_distr_multinormal(3,NULL,NULL);
 unur_distr_cvec_set_domain_rect(distr[34],ll,ru); }
}

{
{double ll[3] = { 0., 0., 0.};
 double ru[3] = { UNUR_INFINITY, UNUR_INFINITY, UNUR_INFINITY};
 distr[35] = unur_distr_multinormal(3,NULL,NULL);
 unur_distr_cvec_set_domain_rect(distr[35],ll,ru); }
}

{
{double ll[3] = { -UNUR_INFINITY, -UNUR_INFINITY, -UNUR_INFINITY};
 double ru[3] = { 0., 0., 0.};
 distr[36] = unur_distr_multinormal(3,NULL,NULL);
 unur_distr_cvec_set_domain_rect(distr[36],ll,ru); }
}

{
{double ll[3] = { -UNUR_INFINITY, -UNUR_INFINITY, -UNUR_INFINITY};
 double ru[3] = { 0., 0., UNUR_INFINITY};
 distr[37] = unur_distr_multinormal(3,NULL,NULL);
 unur_distr_cvec_set_domain_rect(distr[37],ll,ru); }
}

{
{double ll[3] = {-1.,-1.,-1.};
 double ru[3] = { UNUR_INFINITY, UNUR_INFINITY, UNUR_INFINITY};
 distr[38] = unur_distr_multinormal(3,NULL,NULL);
 unur_distr_cvec_set_domain_rect(distr[38],ll,ru); }
}

	/* timing */
	stopwatch_print(TESTLOG,"\n<*>setup time = %.3f ms\n", stopwatch_lap(&watch));

	printf("\n(chi^2) "); fflush(stdout);

/* chi^2 tests: 39 */

	unur_set_default_debug(~UNUR_DEBUG_SAMPLE);
	fprintf( TESTLOG,"\nChi^2 Test:\n");

/* distribution [0] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[0]);
par = unur_mvtdr_new(distr_localcopy);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[0],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [1] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[1]);
par = unur_mvtdr_new(distr_localcopy);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[1],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [2] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[2]);
par = unur_mvtdr_new(distr_localcopy);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[2],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [3] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[3]);
par = unur_mvtdr_new(distr_localcopy);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[3],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [4] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[4]);
par = unur_mvtdr_new(distr_localcopy);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[4],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [5] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[5]);
par = unur_mvtdr_new(distr_localcopy);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[5],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [6] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[6]);
par = unur_mvtdr_new(distr_localcopy);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[6],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [7] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[7]);
par = unur_mvtdr_new(distr_localcopy);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[7],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [8] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[8]);
par = unur_mvtdr_new(distr_localcopy);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[8],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [9] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[9]);
par = unur_mvtdr_new(distr_localcopy);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[9],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [10] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[10]);
par = unur_mvtdr_new(distr_localcopy);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[10],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [11] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[11]);
par = unur_mvtdr_new(distr_localcopy);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[11],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [12] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[12]);
par = unur_mvtdr_new(distr_localcopy);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[12],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [13] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[13]);
par = unur_mvtdr_new(distr_localcopy);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[13],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [14] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[14]);
par = unur_mvtdr_new(distr_localcopy);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[14],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [15] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[15]);
par = unur_mvtdr_new(distr_localcopy);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[15],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [16] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[16]);
par = unur_mvtdr_new(distr_localcopy);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[16],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [17] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[17]);
par = unur_mvtdr_new(distr_localcopy);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[17],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [18] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[18]);
par = unur_mvtdr_new(distr_localcopy);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[18],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [19] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[19]);
par = unur_mvtdr_new(distr_localcopy);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[19],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [20] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[20]);
par = unur_mvtdr_new(distr_localcopy);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[20],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [21] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[21]);
par = unur_mvtdr_new(distr_localcopy);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[21],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [22] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[22]);
par = unur_mvtdr_new(distr_localcopy);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[22],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [31] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[31]);
par = unur_mvtdr_new(distr_localcopy);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[31],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [32] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[32]);
par = unur_mvtdr_new(distr_localcopy);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[32],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [33] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[33]);
par = unur_mvtdr_new(distr_localcopy);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[33],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [34] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[34]);
par = unur_mvtdr_new(distr_localcopy);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[34],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [35] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[35]);
par = unur_mvtdr_new(distr_localcopy);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[35],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [36] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[36]);
par = unur_mvtdr_new(distr_localcopy);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[36],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [37] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[37]);
par = unur_mvtdr_new(distr_localcopy);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[37],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [38] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[38]);
par = unur_mvtdr_new(distr_localcopy);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[38],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	/* timing */
	stopwatch_print(TESTLOG,"\n<*>time = %.0f ms\n", stopwatch_lap(&watch));

	printf("\n(verify hat) "); fflush(stdout);

/* verify hat tests: 39 */

	unur_set_default_debug(~UNUR_DEBUG_SAMPLE);
	fprintf( TESTLOG,"\nVerify Hat Test (squeeze <= PDF <= hat):\n");

/* distribution [0] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[0]);
par = unur_mvtdr_new(distr_localcopy);
	unur_mvtdr_set_pedantic(par,0);
	gen = unur_init(par);
	if (gen) unur_mvtdr_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[0],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [1] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[1]);
par = unur_mvtdr_new(distr_localcopy);
	unur_mvtdr_set_pedantic(par,0);
	gen = unur_init(par);
	if (gen) unur_mvtdr_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[1],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [2] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[2]);
par = unur_mvtdr_new(distr_localcopy);
	unur_mvtdr_set_pedantic(par,0);
	gen = unur_init(par);
	if (gen) unur_mvtdr_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[2],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [3] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[3]);
par = unur_mvtdr_new(distr_localcopy);
	unur_mvtdr_set_pedantic(par,0);
	gen = unur_init(par);
	if (gen) unur_mvtdr_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[3],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [4] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[4]);
par = unur_mvtdr_new(distr_localcopy);
	unur_mvtdr_set_pedantic(par,0);
	gen = unur_init(par);
	if (gen) unur_mvtdr_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[4],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [5] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[5]);
par = unur_mvtdr_new(distr_localcopy);
	unur_mvtdr_set_pedantic(par,0);
	gen = unur_init(par);
	if (gen) unur_mvtdr_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[5],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [6] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[6]);
par = unur_mvtdr_new(distr_localcopy);
	unur_mvtdr_set_pedantic(par,0);
	gen = unur_init(par);
	if (gen) unur_mvtdr_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[6],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [7] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[7]);
par = unur_mvtdr_new(distr_localcopy);
	unur_mvtdr_set_pedantic(par,0);
	gen = unur_init(par);
	if (gen) unur_mvtdr_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[7],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [8] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[8]);
par = unur_mvtdr_new(distr_localcopy);
	unur_mvtdr_set_pedantic(par,0);
	gen = unur_init(par);
	if (gen) unur_mvtdr_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[8],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [9] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[9]);
par = unur_mvtdr_new(distr_localcopy);
	unur_mvtdr_set_pedantic(par,0);
	gen = unur_init(par);
	if (gen) unur_mvtdr_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[9],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [10] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[10]);
par = unur_mvtdr_new(distr_localcopy);
	unur_mvtdr_set_pedantic(par,0);
	gen = unur_init(par);
	if (gen) unur_mvtdr_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[10],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [11] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[11]);
par = unur_mvtdr_new(distr_localcopy);
	unur_mvtdr_set_pedantic(par,0);
	gen = unur_init(par);
	if (gen) unur_mvtdr_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[11],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [12] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[12]);
par = unur_mvtdr_new(distr_localcopy);
	unur_mvtdr_set_pedantic(par,0);
	gen = unur_init(par);
	if (gen) unur_mvtdr_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[12],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [13] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[13]);
par = unur_mvtdr_new(distr_localcopy);
	unur_mvtdr_set_pedantic(par,0);
	gen = unur_init(par);
	if (gen) unur_mvtdr_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[13],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [14] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[14]);
par = unur_mvtdr_new(distr_localcopy);
	unur_mvtdr_set_pedantic(par,0);
	gen = unur_init(par);
	if (gen) unur_mvtdr_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[14],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [15] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[15]);
par = unur_mvtdr_new(distr_localcopy);
	unur_mvtdr_set_pedantic(par,0);
	gen = unur_init(par);
	if (gen) unur_mvtdr_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[15],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [16] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[16]);
par = unur_mvtdr_new(distr_localcopy);
	unur_mvtdr_set_pedantic(par,0);
	gen = unur_init(par);
	if (gen) unur_mvtdr_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[16],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [17] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[17]);
par = unur_mvtdr_new(distr_localcopy);
	unur_mvtdr_set_pedantic(par,0);
	gen = unur_init(par);
	if (gen) unur_mvtdr_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[17],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [18] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[18]);
par = unur_mvtdr_new(distr_localcopy);
	unur_mvtdr_set_pedantic(par,0);
	gen = unur_init(par);
	if (gen) unur_mvtdr_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[18],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [19] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[19]);
par = unur_mvtdr_new(distr_localcopy);
	unur_mvtdr_set_pedantic(par,0);
	gen = unur_init(par);
	if (gen) unur_mvtdr_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[19],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [20] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[20]);
par = unur_mvtdr_new(distr_localcopy);
	unur_mvtdr_set_pedantic(par,0);
	gen = unur_init(par);
	if (gen) unur_mvtdr_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[20],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [21] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[21]);
par = unur_mvtdr_new(distr_localcopy);
	unur_mvtdr_set_pedantic(par,0);
	gen = unur_init(par);
	if (gen) unur_mvtdr_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[21],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [22] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[22]);
par = unur_mvtdr_new(distr_localcopy);
	unur_mvtdr_set_pedantic(par,0);
	gen = unur_init(par);
	if (gen) unur_mvtdr_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[22],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [23] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[23]);
par = unur_mvtdr_new(distr_localcopy);
	unur_mvtdr_set_pedantic(par,0);
	gen = unur_init(par);
	if (gen) unur_mvtdr_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[23],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [24] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[24]);
par = unur_mvtdr_new(distr_localcopy);
	unur_mvtdr_set_pedantic(par,0);
	gen = unur_init(par);
	if (gen) unur_mvtdr_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[24],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [25] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[25]);
par = unur_mvtdr_new(distr_localcopy);
	unur_mvtdr_set_pedantic(par,0);
	gen = unur_init(par);
	if (gen) unur_mvtdr_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[25],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [26] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[26]);
par = unur_mvtdr_new(distr_localcopy);
	unur_mvtdr_set_pedantic(par,0);
	gen = unur_init(par);
	if (gen) unur_mvtdr_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[26],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [27] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[27]);
par = unur_mvtdr_new(distr_localcopy);
	unur_mvtdr_set_pedantic(par,0);
	gen = unur_init(par);
	if (gen) unur_mvtdr_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[27],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [28] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[28]);
par = unur_mvtdr_new(distr_localcopy);
	unur_mvtdr_set_pedantic(par,0);
	gen = unur_init(par);
	if (gen) unur_mvtdr_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[28],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [29] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[29]);
par = unur_mvtdr_new(distr_localcopy);
	unur_mvtdr_set_pedantic(par,0);
	gen = unur_init(par);
	if (gen) unur_mvtdr_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[29],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [30] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[30]);
par = unur_mvtdr_new(distr_localcopy);
	unur_mvtdr_set_pedantic(par,0);
	gen = unur_init(par);
	if (gen) unur_mvtdr_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[30],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [31] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[31]);
par = unur_mvtdr_new(distr_localcopy);
	unur_mvtdr_set_pedantic(par,0);
	gen = unur_init(par);
	if (gen) unur_mvtdr_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[31],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [32] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[32]);
par = unur_mvtdr_new(distr_localcopy);
	unur_mvtdr_set_pedantic(par,0);
	gen = unur_init(par);
	if (gen) unur_mvtdr_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[32],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [33] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[33]);
par = unur_mvtdr_new(distr_localcopy);
	unur_mvtdr_set_pedantic(par,0);
	gen = unur_init(par);
	if (gen) unur_mvtdr_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[33],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [34] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[34]);
par = unur_mvtdr_new(distr_localcopy);
	unur_mvtdr_set_pedantic(par,0);
	gen = unur_init(par);
	if (gen) unur_mvtdr_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[34],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [35] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[35]);
par = unur_mvtdr_new(distr_localcopy);
	unur_mvtdr_set_pedantic(par,0);
	gen = unur_init(par);
	if (gen) unur_mvtdr_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[35],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [36] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[36]);
par = unur_mvtdr_new(distr_localcopy);
	unur_mvtdr_set_pedantic(par,0);
	gen = unur_init(par);
	if (gen) unur_mvtdr_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[36],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [37] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[37]);
par = unur_mvtdr_new(distr_localcopy);
	unur_mvtdr_set_pedantic(par,0);
	gen = unur_init(par);
	if (gen) unur_mvtdr_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[37],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [38] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[38]);
par = unur_mvtdr_new(distr_localcopy);
	unur_mvtdr_set_pedantic(par,0);
	gen = unur_init(par);
	if (gen) unur_mvtdr_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[38],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	/* timing */
	stopwatch_print(TESTLOG,"\n<*>time = %.0f ms\n", stopwatch_lap(&watch));


/* free distributions */
	unur_distr_free(distr[0]);
	unur_distr_free(distr[1]);
	unur_distr_free(distr[2]);
	unur_distr_free(distr[3]);
	unur_distr_free(distr[4]);
	unur_distr_free(distr[5]);
	unur_distr_free(distr[6]);
	unur_distr_free(distr[7]);
	unur_distr_free(distr[8]);
	unur_distr_free(distr[9]);
	unur_distr_free(distr[10]);
	unur_distr_free(distr[11]);
	unur_distr_free(distr[12]);
	unur_distr_free(distr[13]);
	unur_distr_free(distr[14]);
	unur_distr_free(distr[15]);
	unur_distr_free(distr[16]);
	unur_distr_free(distr[17]);
	unur_distr_free(distr[18]);
	unur_distr_free(distr[19]);
	unur_distr_free(distr[20]);
	unur_distr_free(distr[21]);
	unur_distr_free(distr[22]);
	unur_distr_free(distr[23]);
	unur_distr_free(distr[24]);
	unur_distr_free(distr[25]);
	unur_distr_free(distr[26]);
	unur_distr_free(distr[27]);
	unur_distr_free(distr[28]);
	unur_distr_free(distr[29]);
	unur_distr_free(distr[30]);
	unur_distr_free(distr[31]);
	unur_distr_free(distr[32]);
	unur_distr_free(distr[33]);
	unur_distr_free(distr[34]);
	unur_distr_free(distr[35]);
	unur_distr_free(distr[36]);
	unur_distr_free(distr[37]);
	unur_distr_free(distr[38]);

	/* test finished */
	test_ok &= (n_tests_failed>CHI2_FAILURES_TOLERATED) ? 0 : 1;
	/* we accept CHI2_FAILURES_TOLERATED failures */
	(n_tests_failed>CHI2_FAILURES_TOLERATED) ? printf(" ==> failed] ") : printf(" ==> ok] ");

	/* prevent compiler from making useless annoying warnings */
	distr[0] = NULL;
	par = NULL;
	gen = NULL;
	darray = NULL;
	fpm[0] = 0.;

} /* end of test_validate */


/*---------------------------------------------------------------------------*/
/* run generator in verifying mode */

void run_verify_generator( FILE *LOG, int line, UNUR_PAR *par )
{
	UNUR_GEN *gen;
	int i;

	/* switch to verifying mode */
	unur_mvtdr_set_verify(par,1);

	/* initialize generator */
	gen = unur_init( par ); abort_if_NULL(LOG, line, gen);

	/* run generator */
	for (i=0; i<VIOLATE_SAMPLE_SIZE; i++)
		unur_sample_cont(gen);

	/* destroy generator */
	unur_free(gen); 

} /* end of run_verify_generator() */


/*---------------------------------------------------------------------------*/

int main(void)
{ 
        unsigned long seed;
	char *str_seed, *str_tail;

	/* start stop watch */
	stopwatch_init();
	stopwatch_start(&watch);

        /* open log file for unuran and set output stream for unuran messages */
        UNURANLOG = fopen( "t_mvtdr_unuran.log","w" );
        abort_if_NULL( stderr,-1, UNURANLOG );
        unur_set_stream( UNURANLOG );

        /* open log file for testing */
	TESTLOG = fopen( "t_mvtdr_test.log","w" );
	abort_if_NULL( stderr,-1, TESTLOG );

        /* seed for uniform generators */

	/* seed set by environment */
	str_seed = getenv("SEED");

	if (str_seed != NULL) {
	    seed = strtol(str_seed, &str_tail, 10);
	    if (seed == 0u) 
		seed = 873638;
	}
	else {
#ifdef SEED
	    seed = SEED;
#else
	    seed = 873638;
#endif
	}

        /* seed build-in uniform generators */
        unur_urng_MRG31k3p_seed(NULL,seed);
        unur_urng_fish_seed(NULL,seed);
	unur_urng_mstd_seed(NULL,seed);

	/* seed uniform random number generator */
#ifdef UNUR_URNG_UNURAN
#  ifdef UNUR_URNG_DEFAULT_RNGSTREAM
	{
	        unsigned long sa[6];
	        int i;
	        for (i=0; i<6; i++) sa[i] = seed;
                RngStream_SetPackageSeed(sa);
        }
#  else
	if (unur_urng_seed(NULL,seed) != UNUR_SUCCESS) {
	        fprintf(stderr,"WARNING: Seed could not be set at random\n");
                seed = ~0u;
	}
#  endif  /* UNUR_URNG_DEFAULT_RNGSTREAM */
#endif  /* UNUR_URNG_UNURAN */
 
	/* set default debugging flag */
	unur_set_default_debug(UNUR_DEBUG_ALL);

        /* detect required check mode */
        fullcheck = (getenv("UNURANFULLCHECK")==NULL) ? FALSE : TRUE;

	/* write header into log file */
        print_test_log_header( TESTLOG, seed, fullcheck );

	/* set timer for sending SIGALRM signal */
	set_alarm(TESTLOG);

	/* start test */
	printf("mvtdr: ");

	/* run tests */
test_new();
test_set();
test_get();
test_chg();
test_reinit();
test_sample();
test_validate();


	/* test finished */
	printf("\n");  fflush(stdout);

	/* close log files */
	fprintf(TESTLOG,"\n====================================================\n\n");
	if (test_ok)
		fprintf(TESTLOG,"All tests PASSED.\n");
	else
		fprintf(TESTLOG,"Test(s) FAILED.\n");

	/* timing */
	stopwatch_print(TESTLOG,"\n<*>total time = %.0f ms\n\n", stopwatch_stop(&watch));

	fclose(UNURANLOG);
	fclose(TESTLOG);

	/* free memory */
	compare_free_memory();
	unur_urng_free(unur_get_default_urng());
	unur_urng_free(unur_get_default_urng_aux());

	/* exit */
	exit( (test_ok) ? EXIT_SUCCESS : EXIT_FAILURE );

} /* end of main */

