#!/usr/bin/perl
# Usage: updatever.pl <basever> <top_srcdir> <version file>

my $svnversion = "svnversion";
my $basever = $ARGV[0];
my $top_srcdir = $ARGV[1];
my $outfile = $ARGV[2];

my $rev = "";
my $full_ver = "$basever";

if( $svnversion ) {
   $rev = `$svnversion "$top_srcdir"`;
   chomp $rev;
   if( $rev == "exported" ) {
      $rev = "";
   } else {
      $full_ver = "${basever}.${rev}";
   }
}
my $header = "/* Autogenerated by checkver.pl */";
my $output = "${header}\n".
             "const char lxdream_package_name[] = \"lxdream $basever\";\n" .
             "const char lxdream_short_version[] = \"$basever\";\n" .
             "const char lxdream_full_version[] = \"$full_ver\";\n" .
             "const char lxdream_copyright[] = \"Copyright (C) 2005-2008 Nathan Keynes\";\n";

my $oldfile = "";
if( -e $outfile ) {
    open(VERSIONFILE, "<$outfile") || die "Unable to read from $outfile\n";
    $oldfile = join "", <VERSIONFILE>;
    close(VERSIONFILE);
}

if( $oldfile ne $output ) {
    open(VERSIONFILE, ">$outfile") || die "Unable to write to $outfile\n";
    print VERSIONFILE $output;
    close(VERSIONFILE);
}