/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.servlet;

import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.UnavailableException;
import org.mortbay.http.HttpRequest;
import org.mortbay.http.UserPrincipal;
import org.mortbay.http.UserRealm;
import org.mortbay.jetty.servlet.Holder;
import org.mortbay.jetty.servlet.ServletHandler;
import org.mortbay.jetty.servlet.ServletHttpRequest;
import org.mortbay.util.Code;

public class ServletHolder
extends Holder
implements Comparable {
    private int _initOrder;
    private boolean _initOnStartup = false;
    private Map _roleMap;
    private String _forcedPath;
    private String _run_as;
    private UserRealm _realm;
    private transient Stack _servlets;
    private transient Servlet _servlet;
    private transient Config _config;
    private transient long _unavailable;
    private transient UnavailableException _unavailableEx;
    static /* synthetic */ Class class$javax$servlet$Servlet;
    static /* synthetic */ Class class$javax$servlet$SingleThreadModel;

    public ServletHolder() {
    }

    public ServletHolder(ServletHandler handler, String name, String className) {
        super(handler, name == null ? className : name, className);
    }

    public ServletHolder(ServletHandler handler, String name, String className, String forcedPath) {
        this(handler, name == null ? className : name, className);
        this._forcedPath = forcedPath;
    }

    public int getInitOrder() {
        return this._initOrder;
    }

    public void setInitOrder(int order) {
        this._initOnStartup = true;
        this._initOrder = order;
    }

    public int compareTo(Object o) {
        if (o instanceof ServletHolder) {
            ServletHolder sh = (ServletHolder)o;
            if (sh == this) {
                return 0;
            }
            if (sh._initOrder < this._initOrder) {
                return 1;
            }
            if (sh._initOrder > this._initOrder) {
                return -1;
            }
            int c = this._className.compareTo(sh._className);
            if (c == 0) {
                c = this._name.compareTo(sh._name);
            }
            if (c == 0) {
                c = this.hashCode() > o.hashCode() ? 1 : -1;
            }
            return c;
        }
        return 1;
    }

    public boolean equals(Object o) {
        return this.compareTo(o) == 0;
    }

    public ServletContext getServletContext() {
        return ((ServletHandler)this._httpHandler).getServletContext();
    }

    public synchronized void setUserRoleLink(String name, String link) {
        if (this._roleMap == null) {
            this._roleMap = new HashMap();
        }
        this._roleMap.put(name, link);
    }

    public String getUserRoleLink(String name) {
        if (this._roleMap == null) {
            return name;
        }
        String link = (String)this._roleMap.get(name);
        return link == null ? name : link;
    }

    public void setRunAs(String role) {
        this._run_as = role;
    }

    public String getRunAs() {
        return this._run_as;
    }

    public void start() throws Exception {
        this._unavailable = 0L;
        super.start();
        if (!(class$javax$servlet$Servlet == null ? (class$javax$servlet$Servlet = ServletHolder.class$("javax.servlet.Servlet")) : class$javax$servlet$Servlet).isAssignableFrom(this._class)) {
            IllegalStateException ex = new IllegalStateException("Servlet " + this._class + " is not a javax.servlet.Servlet");
            super.stop();
            throw ex;
        }
        if ((class$javax$servlet$SingleThreadModel == null ? (class$javax$servlet$SingleThreadModel = ServletHolder.class$("javax.servlet.SingleThreadModel")) : class$javax$servlet$SingleThreadModel).isAssignableFrom(this._class)) {
            this._servlets = new Stack();
        }
        if (this._initOnStartup) {
            this._servlet = (Servlet)this.newInstance();
            this._config = new Config();
            try {
                this._servlet.init((ServletConfig)this._config);
            }
            catch (Throwable e) {
                this._servlet = null;
                this._config = null;
                if (e instanceof Exception) {
                    throw (Exception)e;
                }
                if (e instanceof Error) {
                    throw (Error)e;
                }
                throw new ServletException(e);
            }
        }
        if (this._run_as != null) {
            this._realm = this._httpHandler.getHttpContext().getRealm();
        }
    }

    public void stop() {
        if (this._servlet != null) {
            this._servlet.destroy();
        }
        this._servlet = null;
        while (this._servlets != null && this._servlets.size() > 0) {
            Servlet s = (Servlet)this._servlets.pop();
            s.destroy();
        }
        this._config = null;
        super.stop();
    }

    public synchronized Servlet getServlet() throws UnavailableException {
        if (this._unavailable != 0L) {
            if (this._unavailable < 0L || this._unavailable > 0L && System.currentTimeMillis() < this._unavailable) {
                throw this._unavailableEx;
            }
            this._unavailable = 0L;
            this._unavailableEx = null;
        }
        try {
            if (this._servlets != null) {
                Servlet servlet = null;
                if (this._servlets.size() == 0) {
                    servlet = (Servlet)this.newInstance();
                    servlet.init((ServletConfig)this._config);
                } else {
                    servlet = (Servlet)this._servlets.pop();
                }
                return servlet;
            }
            if (this._servlet == null) {
                this._servlet = (Servlet)this.newInstance();
            }
            if (this._config == null) {
                this._config = new Config();
                this._servlet.init((ServletConfig)this._config);
            }
            return this._servlet;
        }
        catch (UnavailableException e) {
            this._servlet = null;
            this._config = null;
            this._unavailableEx = e;
            this._unavailable = -1L;
            if (this._unavailableEx.getUnavailableSeconds() > 0) {
                this._unavailable = System.currentTimeMillis() + (long)(1000 * this._unavailableEx.getUnavailableSeconds());
            }
            throw this._unavailableEx;
        }
        catch (Exception e) {
            this._servlet = null;
            this._config = null;
            Code.warning(e);
            throw new UnavailableException(this._servlet, e.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(ServletRequest request, ServletResponse response) throws ServletException, UnavailableException, IOException {
        Object servletHttpRequest;
        Servlet servlet;
        block20: {
            if (this._class == null) {
                throw new UnavailableException("Servlet Not Initialized");
            }
            Servlet servlet2 = servlet = !this._initOnStartup || this._servlets != null ? this.getServlet() : this._servlet;
            if (servlet == null) {
                throw new UnavailableException("Could not instantiate " + this._class);
            }
            boolean servlet_error = true;
            UserPrincipal user = null;
            HttpRequest http_request = null;
            try {
                if (this._forcedPath != null) {
                    request.setAttribute("javax.servlet.include.servlet_path", (Object)this._forcedPath);
                }
                if (this._run_as != null && this._realm != null) {
                    servletHttpRequest = ServletHttpRequest.unwrap(request);
                    http_request = ((ServletHttpRequest)servletHttpRequest).getHttpRequest();
                    user = this._realm.pushRole(http_request.getUserPrincipal(), this._run_as);
                    http_request.setUserPrincipal(user);
                }
                servlet.service(request, response);
                servlet_error = false;
                if (this._run_as != null && this._realm != null && user != null) {
                    user = this._realm.popRole(user);
                    http_request.setUserPrincipal(user);
                }
                if (!servlet_error) break block20;
            }
            catch (UnavailableException e) {
                try {
                    if (this._servlets != null && servlet != null) {
                        servlet.destroy();
                    }
                    servlet = null;
                    throw e;
                }
                catch (Throwable throwable) {
                    if (this._run_as != null && this._realm != null && user != null) {
                        user = this._realm.popRole(user);
                        http_request.setUserPrincipal(user);
                    }
                    if (servlet_error) {
                        request.setAttribute("javax.servlet.error.servlet_name", (Object)this.getName());
                    }
                    ServletHolder servletHolder = this;
                    synchronized (servletHolder) {
                        if (this._servlets != null && servlet != null) {
                            this._servlets.push(servlet);
                        }
                    }
                    throw throwable;
                }
            }
            request.setAttribute("javax.servlet.error.servlet_name", (Object)this.getName());
        }
        servletHttpRequest = this;
        synchronized (servletHttpRequest) {
            if (this._servlets != null && servlet != null) {
                this._servlets.push(servlet);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class Config
    implements ServletConfig {
        Config() {
        }

        public String getServletName() {
            return ServletHolder.this.getName();
        }

        public ServletContext getServletContext() {
            return ((ServletHandler)ServletHolder.this._httpHandler).getServletContext();
        }

        public String getInitParameter(String param) {
            return ServletHolder.this.getInitParameter(param);
        }

        public Enumeration getInitParameterNames() {
            return ServletHolder.this.getInitParameterNames();
        }
    }
}

