/*
 * Decompiled with CFR 0.152.
 */
package gsfc.nssdc.cdf;

import gsfc.nssdc.cdf.Attribute;
import gsfc.nssdc.cdf.CDF;
import gsfc.nssdc.cdf.CDFConstants;
import gsfc.nssdc.cdf.CDFData;
import gsfc.nssdc.cdf.CDFException;
import gsfc.nssdc.cdf.CDFObject;
import gsfc.nssdc.cdf.Entry;
import gsfc.nssdc.cdf.util.CDFTT2000;
import gsfc.nssdc.cdf.util.CDFUtils;
import gsfc.nssdc.cdf.util.Epoch;
import gsfc.nssdc.cdf.util.Epoch16;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;

public class Variable
implements CDFObject,
CDFConstants {
    private CDF myCDF;
    private String name = null;
    private long id;
    private long cdfID;
    private long cType;
    private long cTypeX;
    private long cPct;
    private long[] cParms = new long[1];
    private long[] cParmsX = new long[1];
    private long dataType;
    private long xdataType;
    private long numDims;
    private long numElements;
    private long xnumElements;
    private long[] dimSizes;
    private long[] dimVariances;
    private long[] dimVariancesX;
    private long maxRec;
    private Object data = null;
    private String dataSignature;
    private long recNum;
    private long recCount;
    private long recInterval;
    private long[] dimCounts;
    private long[] dimIndices;
    private long[] dimIntervals;
    private long num0toRecords;
    private long numRecords;
    private long numAllocRecords;
    private long maxAllocRecord;
    private long nRecords;
    private Object padValue = null;
    private Object padValueX = null;
    private long sparseRecords;
    private long sparseRecordsX;
    private long recVariance;
    private long recVarianceX;
    private long blockingFactor;
    private long blockingFactorX;
    private long cacheSize;
    private long reservePercent;
    private long firstRec;
    private long lastRec;

    private Variable(CDF cDF) {
        this.myCDF = cDF;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static final Variable retrieve(CDF cDF, long l) throws CDFException {
        CDF cDF2 = cDF;
        synchronized (cDF2) {
            Variable variable = new Variable(cDF);
            variable.id = l;
            Vector<Serializable> vector = new Vector<Serializable>();
            Vector<String> vector2 = new Vector<String>();
            Vector<String> vector3 = new Vector<String>();
            Vector<String> vector4 = new Vector<String>();
            Vector<String> vector5 = new Vector<String>();
            Vector<String> vector6 = new Vector<String>();
            Vector<String> vector7 = new Vector<String>();
            Vector<String> vector8 = new Vector<String>();
            Vector<String> vector9 = new Vector<String>();
            Vector<String> vector10 = new Vector<String>();
            Vector<String> vector11 = new Vector<String>();
            Vector<String> vector12 = new Vector<String>();
            Vector<String> vector13 = new Vector<String>();
            vector.addElement(new Long(1005L));
            vector.addElement(new Long(1L));
            vector12.addElement("cdfID");
            vector12.addElement("J");
            vector.addElement(vector12);
            vector.addElement(new Long(57L));
            vector13.addElement("id");
            vector13.addElement("J");
            vector.addElement(vector13);
            vector.addElement(new Long(1007L));
            vector.addElement(new Long(58L));
            vector2.addElement("name");
            vector2.addElement("Ljava/lang/String;");
            vector.addElement(vector2);
            vector.addElement(new Long(60L));
            vector3.addElement("numElements");
            vector3.addElement("J");
            vector.addElement(vector3);
            vector.addElement(new Long(59L));
            vector4.addElement("dataType");
            vector4.addElement("J");
            vector.addElement(vector4);
            vector.addElement(new Long(61L));
            vector5.addElement("numDims");
            vector5.addElement("J");
            vector.addElement(vector5);
            vector.addElement(new Long(63L));
            vector6.addElement("recVariance");
            vector6.addElement("J");
            vector.addElement(vector6);
            vector.addElement(new Long(75L));
            vector7.addElement("blockingFactor");
            vector7.addElement("J");
            vector.addElement(vector7);
            vector.addElement(new Long(132L));
            vector8.addElement("sparseRecords");
            vector8.addElement("J");
            vector.addElement(vector8);
            vector.addElement(new Long(131L));
            vector9.addElement("cType");
            vector9.addElement("J");
            vector.addElement(vector9);
            vector10.addElement("cParms");
            vector10.addElement("[J");
            vector.addElement(vector10);
            vector11.addElement("cPct");
            vector11.addElement("J");
            vector.addElement(vector11);
            vector.addElement(new Long(1000L));
            variable.cdfID = cDF.getID();
            cDF.executeCommand(variable, vector);
            vector.removeAllElements();
            vector2.removeAllElements();
            vector3.removeAllElements();
            vector12.removeAllElements();
            vector13.removeAllElements();
            if (variable.numDims > 0L) {
                variable.dimSizes = new long[(int)variable.numDims];
                variable.dimVariances = new long[(int)variable.numDims];
                variable.dimCounts = new long[(int)variable.numDims];
                variable.dimIndices = new long[(int)variable.numDims];
                variable.dimIntervals = new long[(int)variable.numDims];
                vector.addElement(new Long(1005L));
                vector.addElement(new Long(1L));
                vector12.addElement("cdfID");
                vector12.addElement("J");
                vector.addElement(vector12);
                vector.addElement(new Long(57L));
                vector13.addElement("id");
                vector13.addElement("J");
                vector.addElement(vector13);
                vector.addElement(new Long(1007L));
                vector.addElement(new Long(62L));
                vector2.addElement("dimSizes");
                vector2.addElement("[J");
                vector.addElement(vector2);
                vector.addElement(new Long(64L));
                vector3.addElement("dimVariances");
                vector3.addElement("[J");
                vector.addElement(vector3);
                vector.addElement(new Long(1000L));
                cDF.executeCommand(variable, vector);
            }
            vector.removeAllElements();
            vector2.removeAllElements();
            vector12.removeAllElements();
            vector13.removeAllElements();
            variable.setSignature();
            if (variable.getDataType() == 32L) {
                variable.padValue = new double[2];
            }
            vector.addElement(new Long(1005L));
            vector.addElement(new Long(1L));
            vector12.addElement("cdfID");
            vector12.addElement("J");
            vector.addElement(vector12);
            vector.addElement(new Long(57L));
            vector13.addElement("id");
            vector13.addElement("J");
            vector.addElement(vector13);
            vector.addElement(new Long(1007L));
            vector.addElement(new Long(73L));
            vector2.addElement("padValue");
            vector2.addElement("Ljava/lang/Object;");
            vector.addElement(vector2);
            vector.addElement(new Long(1000L));
            cDF.executeCommand(variable, vector);
            cDF.addVariable(variable);
            return variable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Variable create(CDF cDF, String string, long l, long l2, long l3, long[] lArray, long l4, long[] lArray2) throws CDFException {
        CDF cDF2 = cDF;
        synchronized (cDF2) {
            if (string == null || string.trim().length() == 0) {
                throw new CDFException(-2045L);
            }
            long l5 = cDF.getVariableID(string);
            if (l5 != -1L) {
                throw new CDFException(-2025L);
            }
            Vector<Serializable> vector = new Vector<Serializable>();
            Vector<String> vector2 = new Vector<String>();
            Vector<String> vector3 = new Vector<String>();
            Vector<String> vector4 = new Vector<String>();
            Vector<String> vector5 = new Vector<String>();
            Vector<String> vector6 = new Vector<String>();
            Vector<String> vector7 = new Vector<String>();
            Vector<String> vector8 = new Vector<String>();
            Vector<String> vector9 = new Vector<String>();
            Vector<String> vector10 = new Vector<String>();
            vector.addElement(new Long(1005L));
            vector.addElement(new Long(1L));
            vector10.addElement("cdfID");
            vector10.addElement("J");
            vector.addElement(vector10);
            vector.addElement(new Long(1001L));
            vector.addElement(new Long(57L));
            vector2.addElement("name");
            vector2.addElement("Ljava/lang/String;");
            vector.addElement(vector2);
            vector3.addElement("dataType");
            vector3.addElement("J");
            vector.addElement(vector3);
            vector4.addElement("numElements");
            vector4.addElement("J");
            vector.addElement(vector4);
            vector5.addElement("numDims");
            vector5.addElement("J");
            vector.addElement(vector5);
            vector6.addElement("dimSizes");
            vector6.addElement("[J");
            vector.addElement(vector6);
            vector7.addElement("recVariance");
            vector7.addElement("J");
            vector.addElement(vector7);
            vector8.addElement("dimVariances");
            vector8.addElement("[J");
            vector.addElement(vector8);
            vector9.addElement("id");
            vector9.addElement("J");
            vector.addElement(vector9);
            vector.addElement(new Long(1000L));
            Variable variable = new Variable(cDF);
            variable.myCDF = cDF;
            variable.name = string;
            variable.dataType = l;
            variable.numElements = l2;
            variable.numDims = l3;
            variable.dimSizes = lArray;
            variable.recVariance = l4;
            variable.dimVariances = lArray2;
            variable.dimIndices = new long[(int)l3];
            variable.dimCounts = new long[(int)l3];
            variable.dimIntervals = new long[(int)l3];
            variable.cdfID = cDF.getID();
            cDF.executeCommand(variable, vector);
            variable.setSignature();
            cDF.addVariable(variable);
            return variable;
        }
    }

    @Override
    public synchronized void delete() throws CDFException {
        Vector<Serializable> vector = new Vector<Serializable>();
        Vector<String> vector2 = new Vector<String>();
        Vector<String> vector3 = new Vector<String>();
        vector.addElement(new Long(1005L));
        vector.addElement(new Long(1L));
        vector2.addElement("cdfID");
        vector2.addElement("J");
        vector.addElement(vector2);
        vector.addElement(new Long(57L));
        vector3.addElement("id");
        vector3.addElement("J");
        vector.addElement(vector3);
        vector.addElement(new Long(1003L));
        vector.addElement(new Long(57L));
        vector.addElement(new Long(1000L));
        this.id = this.getID();
        this.cdfID = this.myCDF.getID();
        this.myCDF.executeCommand(this, vector);
        this.myCDF.removeVariable(this);
    }

    @Override
    public synchronized void rename(String string) throws CDFException {
        Vector<Serializable> vector = new Vector<Serializable>();
        Vector<String> vector2 = new Vector<String>();
        Vector<String> vector3 = new Vector<String>();
        Vector<String> vector4 = new Vector<String>();
        vector.addElement(new Long(1005L));
        vector.addElement(new Long(1L));
        vector3.addElement("cdfID");
        vector3.addElement("J");
        vector.addElement(vector3);
        vector.addElement(new Long(57L));
        vector4.addElement("id");
        vector4.addElement("J");
        vector.addElement(vector4);
        vector.addElement(new Long(1008L));
        vector.addElement(new Long(58L));
        vector2.addElement("name");
        vector2.addElement("Ljava/lang/String;");
        vector.addElement(vector2);
        vector.addElement(new Long(1000L));
        this.name = string;
        this.id = this.getID();
        this.cdfID = this.myCDF.getID();
        this.myCDF.executeCommand(this, vector);
    }

    public synchronized Variable copy(String string) throws CDFException {
        return this.copy(this.myCDF, string);
    }

    public synchronized Variable copy(CDF cDF, String string) throws CDFException {
        long[] lArray;
        long[] lArray2;
        long l = cDF.getVariableID(string);
        if (l != -1L) {
            throw new CDFException(-2025L);
        }
        if (this.getNumDims() == 0L) {
            lArray2 = new long[]{1L};
            lArray = new long[]{-1L};
        } else {
            lArray2 = this.dimSizes;
            lArray = this.dimVariances;
        }
        Variable variable = Variable.create(cDF, string, this.dataType, this.numElements, this.numDims, lArray2, this.recVariance, lArray);
        Vector vector = this.myCDF.getAttributes();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Attribute attribute = (Attribute)enumeration.nextElement();
            if (attribute.getScope() != 2L) continue;
            try {
                Entry entry = attribute.getEntry(this.getID());
                if (this.myCDF != cDF) {
                    Attribute attribute2 = cDF.getAttributeID(attribute.getName()) == -1L ? Attribute.create(cDF, attribute.getName(), 2L) : cDF.getAttribute(attribute.getName());
                    Entry.create(attribute2, variable.getID(), entry.getDataType(), entry.getData());
                    continue;
                }
                Entry.create(attribute, variable.getID(), entry.getDataType(), entry.getData());
            }
            catch (CDFException cDFException) {}
        }
        return variable;
    }

    public synchronized Variable duplicate(String string) throws CDFException {
        return this.duplicate(this.myCDF, string);
    }

    public synchronized Variable duplicate(CDF cDF, String string) throws CDFException {
        long[] lArray;
        long[] lArray2;
        long[] lArray3;
        Variable variable = null;
        if (this.numDims > 0L) {
            lArray3 = new long[(int)this.numDims];
            lArray2 = new long[(int)this.numDims];
            lArray = this.dimSizes;
            int n = 0;
            while ((long)n < this.numDims) {
                lArray3[n] = 0L;
                lArray2[n] = 1L;
                ++n;
            }
        } else {
            lArray = new long[]{1L};
            lArray3 = new long[]{0L};
            lArray2 = new long[]{1L};
        }
        long l = this.getMaxWrittenRecord();
        variable = this.copy(cDF, string);
        variable.setBlockingFactor(this.blockingFactor);
        variable.setCompression(this.cType, this.cParms);
        variable.setSparseRecords(this.sparseRecords);
        if (this.padValue != null) {
            variable.setPadValue(this.padValue);
        }
        if (l > -1L) {
            this.recNum = 0L;
            while (this.recNum <= l) {
                this.firstRec = this.getAllocatedFrom(this.recNum);
                this.lastRec = this.getAllocatedTo(this.firstRec);
                this.lastRec = this.lastRec > l ? l : this.lastRec;
                Object object = this.getHyperData(this.firstRec, this.lastRec - this.firstRec + 1L, 1L, lArray3, lArray, lArray2);
                variable.putHyperData(this.firstRec, this.lastRec - this.firstRec + 1L, 1L, lArray3, lArray, lArray2, object);
                this.recNum = this.lastRec + 1L;
            }
        }
        return variable;
    }

    public synchronized void copyDataRecords(Variable variable) throws CDFException {
        this.copyDataRecords(variable, 1L);
    }

    private void copyDataRecords(Variable variable, long l) throws CDFException {
        long[] lArray;
        long[] lArray2;
        long[] lArray3;
        if (this.dataType != variable.dataType || this.numElements != variable.numElements || this.numDims != variable.numDims) {
            throw new CDFException(-2104L);
        }
        int n = 0;
        while ((long)n < this.numDims) {
            if (this.dimSizes[n] != variable.dimSizes[n] || this.dimVariances[n] != variable.dimVariances[n]) {
                throw new CDFException(-2104L);
            }
            ++n;
        }
        if (this.numDims > 0L) {
            lArray3 = new long[(int)this.numDims];
            lArray2 = new long[(int)this.numDims];
            lArray = this.dimSizes;
            int n2 = 0;
            while ((long)n2 < this.numDims) {
                lArray3[n2] = 0L;
                lArray2[n2] = 1L;
                ++n2;
            }
        } else {
            lArray3 = new long[]{0L};
            lArray2 = new long[]{1L};
            lArray = new long[]{1L};
        }
        long l2 = this.getMaxWrittenRecord();
        long l3 = l == 1L ? 0L : variable.getMaxWrittenRecord() + 1L;
        if (l2 > -1L) {
            this.recNum = 0L;
            while (this.recNum <= l2) {
                this.firstRec = this.getAllocatedFrom(this.recNum);
                this.lastRec = this.getAllocatedTo(this.firstRec);
                this.lastRec = this.lastRec > l2 ? l2 : this.lastRec;
                Object object = this.getHyperData(this.firstRec, this.lastRec - this.firstRec + 1L, 1L, lArray3, lArray, lArray2);
                variable.putHyperData(l3 + this.firstRec, this.lastRec - this.firstRec + 1L, 1L, lArray3, lArray, lArray2, object);
                this.recNum = this.lastRec + 1L;
            }
        }
    }

    public synchronized void concatenateDataRecords(Variable variable) throws CDFException {
        this.copyDataRecords(variable, 2L);
    }

    public synchronized Object getEntryData(String string) throws CDFException {
        Attribute attribute = this.myCDF.getAttribute(string);
        Object object = attribute.getEntry(this).getData();
        return object;
    }

    public synchronized Object getSingleData(long l, long[] lArray) throws CDFException {
        return this.getSingleDataObject(l, lArray).getData();
    }

    public synchronized CDFData getSingleDataObject(long l, long[] lArray) throws CDFException {
        long[] lArray2;
        long[] lArray3;
        long[] lArray4;
        if (this.numDims > 0L) {
            lArray4 = new long[(int)this.numDims];
            lArray3 = new long[(int)this.numDims];
            lArray2 = lArray;
            int n = 0;
            while ((long)n < this.numDims) {
                lArray3[n] = 1L;
                lArray4[n] = 1L;
                ++n;
            }
        } else {
            lArray2 = new long[]{0L};
            lArray4 = new long[]{1L};
            lArray3 = new long[]{1L};
        }
        return CDFData.get(this, l, 1L, 1L, lArray2, lArray3, lArray4);
    }

    public synchronized Object getRecord(long l) throws CDFException {
        return this.getRecordObject(l).getData();
    }

    public synchronized CDFData getRecordObject(long l) throws CDFException {
        return this.getRecordsObject(l, 1L);
    }

    public synchronized CDFData getRecordsObject(long l, long l2) throws CDFException {
        long[] lArray;
        long[] lArray2;
        long[] lArray3;
        if (this.numDims == 0L) {
            lArray3 = new long[]{1L};
            lArray2 = new long[]{0L};
            lArray = new long[]{1L};
        } else {
            lArray3 = this.dimSizes;
            lArray2 = new long[(int)this.numDims];
            lArray = new long[(int)this.numDims];
            int n = 0;
            while ((long)n < this.numDims) {
                lArray2[n] = 0L;
                lArray[n] = 1L;
                ++n;
            }
        }
        return CDFData.get(this, l, l2, 1L, lArray2, lArray3, lArray);
    }

    public synchronized CDFData getAllRecordsObject() throws CDFException {
        long[] lArray;
        long[] lArray2;
        long[] lArray3;
        if (this.numDims == 0L) {
            lArray3 = new long[]{1L};
            lArray2 = new long[]{0L};
            lArray = new long[]{1L};
        } else {
            lArray3 = this.dimSizes;
            lArray2 = new long[(int)this.numDims];
            lArray = new long[(int)this.numDims];
            int n = 0;
            while ((long)n < this.numDims) {
                lArray2[n] = 0L;
                lArray[n] = 1L;
                ++n;
            }
        }
        long l = this.getMaxWrittenRecord();
        if (l == -1L) {
            return null;
        }
        return CDFData.get(this, 0L, l + 1L, 1L, lArray2, lArray3, lArray);
    }

    public synchronized Object getAllRecords() throws CDFException {
        return this.getAllRecordsObject().getData();
    }

    public synchronized Object getScalarData() throws CDFException {
        return this.getScalarDataObject(0L).getData();
    }

    public synchronized Object getScalarData(long l) throws CDFException {
        return this.getScalarDataObject(l).getData();
    }

    public synchronized CDFData getScalarDataObject() throws CDFException {
        return this.getScalarDataObject(0L);
    }

    public synchronized CDFData getScalarDataObject(long l) throws CDFException {
        long[] lArray = new long[]{0L};
        long[] lArray2 = new long[]{1L};
        long[] lArray3 = new long[]{1L};
        return CDFData.get(this, l, 1L, 1L, lArray, lArray3, lArray2);
    }

    public synchronized Object getHyperData(long l, long l2, long l3, long[] lArray, long[] lArray2, long[] lArray3) throws CDFException {
        return CDFData.get(this, l, l2, l3, lArray, lArray2, lArray3).getData();
    }

    public synchronized CDFData getHyperDataObject(long l, long l2, long l3, long[] lArray, long[] lArray2, long[] lArray3) throws CDFException {
        return CDFData.get(this, l, l2, l3, lArray, lArray2, lArray3);
    }

    public synchronized Map readVariable() {
        return this.readVariable(true, true, true, true);
    }

    public synchronized Map readVariableSpec() {
        return this.readVariable(true, true, false, false);
    }

    public synchronized Map readVariableMetaData() {
        return this.readVariable(true, false, true, false);
    }

    public synchronized Map readVariableData() {
        return this.readVariable(false, false, false, true);
    }

    public synchronized Map readVariable(boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        Object object;
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        if (bl2) {
            object = new HashMap<String, String>();
            object.put("VarName", this.name);
            object.put("DataType", this.getDataType());
            object.put("NumElements", this.getNumElements());
            object.put("NumDims", this.getNumDims());
            object.put("DimSizes", this.getDimSizes());
            try {
                Object object2 = this.getPadValue();
                if (bl) {
                    if (this.dataType == 31L) {
                        object.put("PadValue", Epoch.toEncode(object2));
                    } else if (this.dataType == 32L) {
                        object.put("PadValue", Epoch16.toEncode(object2));
                    } else if (this.dataType == 33L) {
                        object.put("PadValue", CDFTT2000.toEncode(object2));
                    } else {
                        object.put("PadValue", object2);
                    }
                } else {
                    object.put("PadValue", object2);
                }
            }
            catch (CDFException cDFException) {
                // empty catch block
            }
            hashMap.put("VarSpec", object);
        }
        if (bl3) {
            try {
                object = this.getAttributesandEntries(bl);
                if (object.size() > 0) {
                    hashMap.put("VarMetaData", object);
                }
            }
            catch (Exception exception) {
                hashMap.put("VarMetaData", null);
            }
        }
        if (bl4) {
            try {
                object = this.getAllRecords();
                if (object != null) {
                    if (!bl || this.dataType != 31L && this.dataType != 33L && this.dataType != 32L) {
                        hashMap.put("VarData", object);
                    } else if (this.dataType == 31L) {
                        hashMap.put("VarData", Epoch.toEncode(object));
                    } else if (this.dataType == 33L) {
                        hashMap.put("VarData", CDFTT2000.toEncode(object));
                    } else {
                        hashMap.put("VarData", Epoch16.toEncode(object));
                    }
                } else {
                    hashMap.put("VarData", null);
                }
            }
            catch (Exception exception) {
                hashMap.put("VarData", null);
            }
        }
        return hashMap;
    }

    public synchronized void putEntry(String string, long l, Object object) throws CDFException {
        Entry.create(this.myCDF.getAttribute(string), this.getID(), l, object);
    }

    public synchronized void putEntry(Attribute attribute, long l, Object object) throws CDFException {
        Entry.create(attribute, this.getID(), l, object);
    }

    public synchronized CDFData putSingleData(long l, long[] lArray, Object object) throws CDFException {
        long[] lArray2;
        long[] lArray3;
        long[] lArray4;
        if (this.numDims > 0L) {
            lArray4 = new long[(int)this.numDims];
            lArray3 = new long[(int)this.numDims];
            lArray2 = lArray;
            int n = 0;
            while ((long)n < this.numDims) {
                lArray3[n] = 1L;
                lArray4[n] = 1L;
                ++n;
            }
        } else {
            lArray3 = new long[]{1L};
            lArray2 = new long[]{0L};
            lArray4 = new long[]{1L};
        }
        return CDFData.put(this, l, 1L, 1L, lArray2, lArray3, lArray4, object);
    }

    public synchronized CDFData putScalarData(long l, Object object) throws CDFException {
        return this.putSingleData(l, new long[]{0L}, object);
    }

    public synchronized CDFData putScalarData(Object object) throws CDFException {
        return this.putSingleData(0L, new long[]{0L}, object);
    }

    public synchronized CDFData putRecord(long l, Object object) throws CDFException {
        long[] lArray;
        long[] lArray2;
        long[] lArray3;
        if (this.numDims > 0L) {
            lArray3 = new long[(int)this.numDims];
            lArray2 = new long[(int)this.numDims];
            lArray = this.dimSizes;
            int n = 0;
            while ((long)n < this.numDims) {
                lArray3[n] = 0L;
                lArray2[n] = 1L;
                ++n;
            }
        } else {
            lArray = new long[]{1L};
            lArray3 = new long[]{0L};
            lArray2 = new long[]{1L};
        }
        return CDFData.put(this, l, 1L, 1L, lArray3, lArray, lArray2, object);
    }

    public synchronized CDFData putRecord(Object object) throws CDFException {
        return this.putRecord(0L, object);
    }

    public synchronized CDFData putHyperData(long l, long l2, long l3, long[] lArray, long[] lArray2, long[] lArray3, Object object) throws CDFException {
        return CDFData.put(this, l, l2, l3, lArray, lArray2, lArray3, object);
    }

    public synchronized CDFData putRecords(long l, long l2, Object object) throws CDFException {
        long[] lArray;
        long[] lArray2;
        long[] lArray3;
        long l3 = this.getNumDims();
        if (l3 > 0L) {
            lArray3 = new long[(int)l3];
            lArray2 = this.getDimSizes();
            lArray = new long[(int)l3];
            for (int i = 0; i < (int)l3; ++i) {
                lArray3[i] = 0L;
                lArray[i] = 1L;
            }
        } else {
            lArray3 = new long[]{0L};
            lArray2 = new long[]{1L};
            lArray = new long[]{1L};
        }
        return CDFData.put(this, l, l2, 1L, lArray3, lArray2, lArray, object);
    }

    private final void select() throws CDFException {
        Vector<Long> vector = new Vector<Long>();
        vector.addElement(new Long(1000L));
        this.id = this.getID();
        this.myCDF.executeCommand(this, vector);
    }

    protected final synchronized void select(long l, long[] lArray) throws CDFException {
        Vector<Serializable> vector = new Vector<Serializable>();
        Vector<String> vector2 = new Vector<String>();
        Vector<String> vector3 = new Vector<String>();
        Vector<String> vector4 = new Vector<String>();
        Vector<String> vector5 = new Vector<String>();
        vector.addElement(new Long(1005L));
        vector.addElement(new Long(1L));
        vector5.addElement("cdfID");
        vector5.addElement("J");
        vector.addElement(vector5);
        vector.addElement(new Long(57L));
        vector2.addElement("id");
        vector2.addElement("J");
        vector.addElement(vector2);
        vector.addElement(new Long(79L));
        vector3.addElement("recNum");
        vector3.addElement("J");
        vector.addElement(vector3);
        vector.addElement(new Long(82L));
        vector4.addElement("dimIndices");
        vector4.addElement("[J");
        vector.addElement(vector4);
        vector.addElement(new Long(1000L));
        this.recNum = l;
        int n = 0;
        while ((long)n < this.numDims) {
            this.dimIndices[n] = lArray[n];
            ++n;
        }
        this.id = this.getID();
        this.cdfID = this.myCDF.getID();
        this.myCDF.executeCommand(this, vector);
    }

    protected final synchronized void select(long l, long l2, long l3, long[] lArray, long[] lArray2, long[] lArray3) throws CDFException {
        Vector<Serializable> vector = new Vector<Serializable>();
        Vector<String> vector2 = new Vector<String>();
        Vector<String> vector3 = new Vector<String>();
        Vector<String> vector4 = new Vector<String>();
        Vector<String> vector5 = new Vector<String>();
        Vector<String> vector6 = new Vector<String>();
        Vector<String> vector7 = new Vector<String>();
        Vector<String> vector8 = new Vector<String>();
        Vector<String> vector9 = new Vector<String>();
        vector.addElement(new Long(1005L));
        vector.addElement(new Long(1L));
        vector9.addElement("cdfID");
        vector9.addElement("J");
        vector.addElement(vector9);
        vector.addElement(new Long(57L));
        vector2.addElement("id");
        vector2.addElement("J");
        vector.addElement(vector2);
        vector.addElement(new Long(79L));
        vector3.addElement("recNum");
        vector3.addElement("J");
        vector.addElement(vector3);
        vector.addElement(new Long(80L));
        vector4.addElement("recCount");
        vector4.addElement("J");
        vector.addElement(vector4);
        vector.addElement(new Long(81L));
        vector5.addElement("recInterval");
        vector5.addElement("J");
        vector.addElement(vector5);
        vector.addElement(new Long(82L));
        vector6.addElement("dimIndices");
        vector6.addElement("[J");
        vector.addElement(vector6);
        vector.addElement(new Long(83L));
        vector7.addElement("dimCounts");
        vector7.addElement("[J");
        vector.addElement(vector7);
        vector.addElement(new Long(84L));
        vector8.addElement("dimIntervals");
        vector8.addElement("[J");
        vector.addElement(vector8);
        vector.addElement(new Long(1000L));
        this.recNum = l;
        this.recCount = l2;
        this.recInterval = l3;
        this.dimIndices = lArray;
        this.dimCounts = lArray2;
        this.dimIntervals = lArray3;
        this.id = this.getID();
        this.cdfID = this.myCDF.getID();
        this.myCDF.executeCommand(this, vector);
    }

    public synchronized CDF getMyCDF() {
        return this.myCDF;
    }

    public synchronized long getCompressionType() {
        return this.cType;
    }

    public synchronized long getCompressionPct() {
        return this.cPct;
    }

    public synchronized long[] getCompressionParms() {
        return this.cParms;
    }

    public synchronized void setCompression(long l, long[] lArray) throws CDFException {
        Vector<Serializable> vector = new Vector<Serializable>();
        Vector<String> vector2 = new Vector<String>();
        Vector<String> vector3 = new Vector<String>();
        Vector<String> vector4 = new Vector<String>();
        Vector<String> vector5 = new Vector<String>();
        vector.addElement(new Long(1005L));
        vector.addElement(new Long(1L));
        vector4.addElement("cdfID");
        vector4.addElement("J");
        vector.addElement(vector4);
        vector.addElement(new Long(57L));
        vector5.addElement("id");
        vector5.addElement("J");
        vector.addElement(vector5);
        vector.addElement(new Long(1008L));
        vector.addElement(new Long(131L));
        vector2.addElement("cTypeX");
        vector2.addElement("J");
        vector.addElement(vector2);
        vector3.addElement("cParmsX");
        vector3.addElement("[J");
        vector.addElement(vector3);
        vector.addElement(new Long(1000L));
        this.cTypeX = l;
        this.cParmsX = lArray;
        this.id = this.getID();
        this.cdfID = this.myCDF.getID();
        this.myCDF.executeCommand(this, vector);
        this.cType = l;
        this.cParms = lArray;
    }

    public synchronized String getCompression() throws CDFException {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.cType == 0L) {
            stringBuffer.append("No compression");
        } else {
            stringBuffer.append(CDFUtils.getStringCompressionType(this.cType)).append(".").append(this.cParms[0]);
        }
        return stringBuffer.toString();
    }

    public synchronized long getNumDims() {
        return this.numDims;
    }

    public synchronized long[] getDimSizes() {
        return this.dimSizes;
    }

    public synchronized long getNumElements() {
        return this.numElements;
    }

    @Override
    public synchronized String getName() {
        return this.name;
    }

    public synchronized long getID() {
        return this.myCDF.getVariableID(this.name);
    }

    public synchronized String toString() {
        return this.name;
    }

    public synchronized void setRecVariance(long l) throws CDFException {
        Vector<Serializable> vector = new Vector<Serializable>();
        Vector<String> vector2 = new Vector<String>();
        Vector<String> vector3 = new Vector<String>();
        Vector<String> vector4 = new Vector<String>();
        vector.addElement(new Long(1005L));
        vector.addElement(new Long(1L));
        vector3.addElement("cdfID");
        vector3.addElement("J");
        vector.addElement(vector3);
        vector.addElement(new Long(57L));
        vector4.addElement("id");
        vector4.addElement("J");
        vector.addElement(vector4);
        vector.addElement(new Long(1008L));
        vector.addElement(new Long(63L));
        vector2.addElement("recVarianceX");
        vector2.addElement("J");
        vector.addElement(vector2);
        vector.addElement(new Long(1000L));
        this.recVarianceX = l;
        this.id = this.getID();
        this.cdfID = this.myCDF.getID();
        this.myCDF.executeCommand(this, vector);
        this.recVariance = l;
    }

    public synchronized boolean getRecVariance() {
        return this.recVariance == -1L;
    }

    public synchronized void setDimVariances(long[] lArray) throws CDFException {
        Vector<Serializable> vector = new Vector<Serializable>();
        Vector<String> vector2 = new Vector<String>();
        Vector<String> vector3 = new Vector<String>();
        Vector<String> vector4 = new Vector<String>();
        vector.addElement(new Long(1005L));
        vector.addElement(new Long(1L));
        vector3.addElement("cdfID");
        vector3.addElement("J");
        vector.addElement(vector3);
        vector.addElement(new Long(57L));
        vector4.addElement("id");
        vector4.addElement("J");
        vector.addElement(vector4);
        vector.addElement(new Long(1008L));
        vector.addElement(new Long(64L));
        vector2.addElement("dimVariancesX");
        vector2.addElement("[J");
        vector.addElement(vector2);
        vector.addElement(new Long(1000L));
        this.dimVariancesX = lArray;
        this.id = this.getID();
        this.cdfID = this.myCDF.getID();
        this.myCDF.executeCommand(this, vector);
        this.dimVariances = lArray;
    }

    public synchronized long[] getDimVariances() {
        return this.dimVariances;
    }

    public synchronized long getDataType() {
        return this.dataType;
    }

    private void setSignature() {
        switch ((int)this.dataType) {
            case 1: 
            case 41: {
                this.dataSignature = "Ljava/lang/Byte;";
                break;
            }
            case 2: 
            case 11: {
                this.dataSignature = "Ljava/lang/Short;";
                break;
            }
            case 4: 
            case 12: {
                this.dataSignature = "Ljava/lang/Integer;";
                break;
            }
            case 8: 
            case 14: 
            case 33: {
                this.dataSignature = "Ljava/lang/Long;";
                break;
            }
            case 21: 
            case 44: {
                this.dataSignature = "Ljava/lang/Float;";
                break;
            }
            case 22: 
            case 31: 
            case 45: {
                this.dataSignature = "Ljava/lang/Double;";
                break;
            }
            case 32: {
                this.dataSignature = "[D";
                break;
            }
            case 51: 
            case 52: {
                this.dataSignature = "Ljava/lang/String;";
                break;
            }
        }
    }

    public synchronized void deleteRecords(long l, long l2) throws CDFException {
        this.toDeleteRecords(l, l2, false);
    }

    public synchronized void deleteRecordsRenumber(long l, long l2) throws CDFException {
        this.toDeleteRecords(l, l2, true);
    }

    private void toDeleteRecords(long l, long l2, boolean bl) throws CDFException {
        Vector<Serializable> vector = new Vector<Serializable>();
        Vector<String> vector2 = new Vector<String>();
        Vector<String> vector3 = new Vector<String>();
        Vector<String> vector4 = new Vector<String>();
        Vector<String> vector5 = new Vector<String>();
        vector.addElement(new Long(1005L));
        vector.addElement(new Long(1L));
        vector4.addElement("cdfID");
        vector4.addElement("J");
        vector.addElement(vector4);
        vector.addElement(new Long(57L));
        vector5.addElement("id");
        vector5.addElement("J");
        vector.addElement(vector5);
        vector.addElement(new Long(1003L));
        vector.addElement(new Long(bl ? 158L : 153L));
        vector2.addElement("firstRec");
        vector2.addElement("J");
        vector.addElement(vector2);
        vector3.addElement("lastRec");
        vector3.addElement("J");
        vector.addElement(vector3);
        vector.addElement(new Long(1000L));
        this.firstRec = l;
        this.lastRec = l2;
        this.id = this.getID();
        this.cdfID = this.myCDF.getID();
        this.myCDF.executeCommand(this, vector);
    }

    public synchronized void allocateBlock(long l, long l2) throws CDFException {
        Vector<Serializable> vector = new Vector<Serializable>();
        Vector<String> vector2 = new Vector<String>();
        Vector<String> vector3 = new Vector<String>();
        Vector<String> vector4 = new Vector<String>();
        Vector<String> vector5 = new Vector<String>();
        vector.addElement(new Long(1005L));
        vector.addElement(new Long(1L));
        vector4.addElement("cdfID");
        vector4.addElement("J");
        vector.addElement(vector4);
        vector.addElement(new Long(57L));
        vector5.addElement("id");
        vector5.addElement("J");
        vector.addElement(vector5);
        vector.addElement(new Long(1008L));
        vector.addElement(new Long(134L));
        vector2.addElement("firstRec");
        vector2.addElement("J");
        vector.addElement(vector2);
        vector3.addElement("lastRec");
        vector3.addElement("J");
        vector.addElement(vector3);
        vector.addElement(new Long(1000L));
        this.firstRec = l;
        this.lastRec = l2;
        this.id = this.getID();
        this.cdfID = this.myCDF.getID();
        this.myCDF.executeCommand(this, vector);
    }

    public synchronized void allocateRecords(long l) throws CDFException {
        Vector<Serializable> vector = new Vector<Serializable>();
        Vector<String> vector2 = new Vector<String>();
        Vector<String> vector3 = new Vector<String>();
        Vector<String> vector4 = new Vector<String>();
        vector.addElement(new Long(1005L));
        vector.addElement(new Long(1L));
        vector3.addElement("cdfID");
        vector3.addElement("J");
        vector.addElement(vector3);
        vector.addElement(new Long(57L));
        vector4.addElement("id");
        vector4.addElement("J");
        vector.addElement(vector4);
        vector.addElement(new Long(1008L));
        vector.addElement(new Long(124L));
        vector2.addElement("num0toRecords");
        vector2.addElement("J");
        vector.addElement(vector2);
        vector.addElement(new Long(1000L));
        this.num0toRecords = l;
        this.id = this.getID();
        this.cdfID = this.myCDF.getID();
        this.myCDF.executeCommand(this, vector);
    }

    public synchronized long getNumWrittenRecords() throws CDFException {
        Vector<Serializable> vector = new Vector<Serializable>();
        Vector<String> vector2 = new Vector<String>();
        Vector<String> vector3 = new Vector<String>();
        Vector<String> vector4 = new Vector<String>();
        vector.addElement(new Long(1005L));
        vector.addElement(new Long(1L));
        vector3.addElement("cdfID");
        vector3.addElement("J");
        vector.addElement(vector3);
        vector.addElement(new Long(57L));
        vector4.addElement("id");
        vector4.addElement("J");
        vector.addElement(vector4);
        vector.addElement(new Long(1007L));
        vector.addElement(new Long(135L));
        vector2.addElement("numRecords");
        vector2.addElement("J");
        vector.addElement(vector2);
        vector.addElement(new Long(1000L));
        this.id = this.getID();
        this.cdfID = this.myCDF.getID();
        this.myCDF.executeCommand(this, vector);
        return this.numRecords;
    }

    public synchronized long getMaxWrittenRecord() throws CDFException {
        Vector<Serializable> vector = new Vector<Serializable>();
        Vector<String> vector2 = new Vector<String>();
        Vector<String> vector3 = new Vector<String>();
        Vector<String> vector4 = new Vector<String>();
        vector.addElement(new Long(1005L));
        vector.addElement(new Long(1L));
        vector3.addElement("cdfID");
        vector3.addElement("J");
        vector.addElement(vector3);
        vector.addElement(new Long(57L));
        vector4.addElement("id");
        vector4.addElement("J");
        vector.addElement(vector4);
        vector.addElement(new Long(1007L));
        vector.addElement(new Long(70L));
        vector2.addElement("maxRec");
        vector2.addElement("J");
        vector.addElement(vector2);
        vector.addElement(new Long(1000L));
        this.id = this.getID();
        this.cdfID = this.myCDF.getID();
        this.myCDF.executeCommand(this, vector);
        return this.maxRec;
    }

    public synchronized long getNumAllocatedRecords() throws CDFException {
        Vector<Serializable> vector = new Vector<Serializable>();
        Vector<String> vector2 = new Vector<String>();
        Vector<String> vector3 = new Vector<String>();
        Vector<String> vector4 = new Vector<String>();
        vector.addElement(new Long(1005L));
        vector.addElement(new Long(1L));
        vector3.addElement("cdfID");
        vector3.addElement("J");
        vector.addElement(vector3);
        vector.addElement(new Long(57L));
        vector4.addElement("id");
        vector4.addElement("J");
        vector.addElement(vector4);
        vector.addElement(new Long(1007L));
        vector.addElement(new Long(136L));
        vector2.addElement("numAllocRecords");
        vector2.addElement("J");
        vector.addElement(vector2);
        vector.addElement(new Long(1000L));
        this.id = this.getID();
        this.cdfID = this.myCDF.getID();
        this.myCDF.executeCommand(this, vector);
        return this.numAllocRecords;
    }

    public synchronized long getMaxAllocatedRecord() throws CDFException {
        Vector<Serializable> vector = new Vector<Serializable>();
        Vector<String> vector2 = new Vector<String>();
        Vector<String> vector3 = new Vector<String>();
        Vector<String> vector4 = new Vector<String>();
        vector.addElement(new Long(1005L));
        vector.addElement(new Long(1L));
        vector3.addElement("cdfID");
        vector3.addElement("J");
        vector.addElement(vector3);
        vector.addElement(new Long(57L));
        vector4.addElement("id");
        vector4.addElement("J");
        vector.addElement(vector4);
        vector.addElement(new Long(1007L));
        vector.addElement(new Long(71L));
        vector2.addElement("maxAllocRecord");
        vector2.addElement("J");
        vector.addElement(vector2);
        vector.addElement(new Long(1000L));
        this.id = this.getID();
        this.cdfID = this.myCDF.getID();
        this.myCDF.executeCommand(this, vector);
        return this.maxAllocRecord;
    }

    public synchronized void setPadValue(Object object) throws CDFException {
        Vector<Serializable> vector = new Vector<Serializable>();
        Vector<String> vector2 = new Vector<String>();
        Vector<String> vector3 = new Vector<String>();
        Vector<String> vector4 = new Vector<String>();
        this.padValue = this.dataType == 51L || this.dataType == 52L ? object : object;
        try {
            vector.addElement(new Long(1005L));
            vector.addElement(new Long(1L));
            vector3.addElement("cdfID");
            vector3.addElement("J");
            vector.addElement(vector3);
            vector.addElement(new Long(57L));
            vector4.addElement("id");
            vector4.addElement("J");
            vector.addElement(vector4);
            vector.addElement(new Long(1008L));
            vector.addElement(new Long(73L));
            vector2.addElement("padValue");
            vector2.addElement("Ljava/lang/Object;");
            vector.addElement(vector2);
            vector.addElement(new Long(1000L));
            this.padValueX = object;
            this.id = this.getID();
            this.cdfID = this.myCDF.getID();
            this.myCDF.executeCommand(this, vector);
        }
        catch (CDFException cDFException) {
            throw new CDFException(-2051L);
        }
    }

    public synchronized boolean checkPadValueExistence() throws CDFException {
        Vector<Serializable> vector = new Vector<Serializable>();
        Vector<String> vector2 = new Vector<String>();
        Vector<String> vector3 = new Vector<String>();
        try {
            vector.addElement(new Long(1005L));
            vector.addElement(new Long(1L));
            vector2.addElement("cdfID");
            vector2.addElement("J");
            vector.addElement(vector2);
            vector.addElement(new Long(57L));
            vector3.addElement("id");
            vector3.addElement("J");
            vector.addElement(vector3);
            vector.addElement(new Long(1006L));
            vector.addElement(new Long(73L));
            vector.addElement(new Long(1000L));
            this.id = this.getID();
            this.cdfID = this.myCDF.getID();
            this.myCDF.executeCommand(this, vector);
            long l = this.myCDF.getStatus();
            return l == 0L;
        }
        catch (CDFException cDFException) {
            throw new CDFException(-2034L);
        }
    }

    public synchronized Object getPadValue() throws CDFException {
        if (this.padValue != null) {
            return this.padValue;
        }
        Vector<Serializable> vector = new Vector<Serializable>();
        Vector<String> vector2 = new Vector<String>();
        Vector<String> vector3 = new Vector<String>();
        Vector<String> vector4 = new Vector<String>();
        if (this.getDataType() == 32L) {
            this.padValue = new double[2];
        }
        vector.addElement(new Long(1005L));
        vector.addElement(new Long(1L));
        vector3.addElement("cdfID");
        vector3.addElement("J");
        vector.addElement(vector3);
        vector.addElement(new Long(57L));
        vector4.addElement("id");
        vector4.addElement("J");
        vector.addElement(vector4);
        vector.addElement(new Long(1007L));
        vector.addElement(new Long(73L));
        vector2.addElement("padValue");
        vector2.addElement("Ljava/lang/Object;");
        vector.addElement(vector2);
        vector.addElement(new Long(1000L));
        this.id = this.getID();
        this.cdfID = this.myCDF.getID();
        this.myCDF.executeCommand(this, vector);
        this.padValueX = this.padValue;
        return this.padValue;
    }

    public synchronized void setSparseRecords(long l) throws CDFException {
        Vector<Serializable> vector = new Vector<Serializable>();
        Vector<String> vector2 = new Vector<String>();
        Vector<String> vector3 = new Vector<String>();
        Vector<String> vector4 = new Vector<String>();
        vector.addElement(new Long(1005L));
        vector.addElement(new Long(1L));
        vector3.addElement("cdfID");
        vector3.addElement("J");
        vector.addElement(vector3);
        vector.addElement(new Long(57L));
        vector4.addElement("id");
        vector4.addElement("J");
        vector.addElement(vector4);
        vector.addElement(new Long(1008L));
        vector.addElement(new Long(132L));
        vector2.addElement("sparseRecordsX");
        vector2.addElement("J");
        vector.addElement(vector2);
        vector.addElement(new Long(1000L));
        this.sparseRecordsX = l;
        this.id = this.getID();
        this.cdfID = this.myCDF.getID();
        this.myCDF.executeCommand(this, vector);
        this.sparseRecords = l;
    }

    public synchronized long getSparseRecords() {
        return this.sparseRecords;
    }

    public synchronized void setBlockingFactor(long l) throws CDFException {
        Vector<Serializable> vector = new Vector<Serializable>();
        Vector<String> vector2 = new Vector<String>();
        Vector<String> vector3 = new Vector<String>();
        Vector<String> vector4 = new Vector<String>();
        vector.addElement(new Long(1005L));
        vector.addElement(new Long(1L));
        vector3.addElement("cdfID");
        vector3.addElement("J");
        vector.addElement(vector3);
        vector.addElement(new Long(57L));
        vector4.addElement("id");
        vector4.addElement("J");
        vector.addElement(vector4);
        vector.addElement(new Long(1008L));
        vector.addElement(new Long(75L));
        vector2.addElement("blockingFactorX");
        vector2.addElement("J");
        vector.addElement(vector2);
        vector.addElement(new Long(1000L));
        this.blockingFactorX = l;
        this.id = this.getID();
        this.cdfID = this.myCDF.getID();
        this.myCDF.executeCommand(this, vector);
        this.blockingFactor = l;
    }

    public synchronized long getBlockingFactor() throws CDFException {
        return this.blockingFactor;
    }

    public synchronized void setInitialRecords(long l) throws CDFException {
        Vector<Serializable> vector = new Vector<Serializable>();
        Vector<String> vector2 = new Vector<String>();
        Vector<String> vector3 = new Vector<String>();
        Vector<String> vector4 = new Vector<String>();
        vector.addElement(new Long(1005L));
        vector.addElement(new Long(1L));
        vector3.addElement("cdfID");
        vector3.addElement("J");
        vector.addElement(vector3);
        vector.addElement(new Long(57L));
        vector4.addElement("id");
        vector4.addElement("J");
        vector.addElement(vector4);
        vector.addElement(new Long(1008L));
        vector.addElement(new Long(74L));
        vector2.addElement("nRecords");
        vector2.addElement("J");
        vector.addElement(vector2);
        vector.addElement(new Long(1000L));
        this.nRecords = l;
        this.id = this.getID();
        this.cdfID = this.myCDF.getID();
        this.myCDF.executeCommand(this, vector);
    }

    public synchronized void selectCacheSize(long l) throws CDFException {
        Vector<Serializable> vector = new Vector<Serializable>();
        Vector<String> vector2 = new Vector<String>();
        Vector<String> vector3 = new Vector<String>();
        Vector<String> vector4 = new Vector<String>();
        vector.addElement(new Long(1005L));
        vector.addElement(new Long(1L));
        vector3.addElement("cdfID");
        vector3.addElement("J");
        vector.addElement(vector3);
        vector.addElement(new Long(57L));
        vector4.addElement("id");
        vector4.addElement("J");
        vector.addElement(vector4);
        vector.addElement(new Long(121L));
        vector2.addElement("cacheSize");
        vector2.addElement("J");
        vector.addElement(vector2);
        vector.addElement(new Long(1000L));
        this.cacheSize = l;
        this.id = this.getID();
        this.cdfID = this.myCDF.getID();
        this.myCDF.executeCommand(this, vector);
    }

    public synchronized long confirmCacheSize() throws CDFException {
        Vector<Serializable> vector = new Vector<Serializable>();
        Vector<String> vector2 = new Vector<String>();
        Vector<String> vector3 = new Vector<String>();
        Vector<String> vector4 = new Vector<String>();
        vector.addElement(new Long(1005L));
        vector.addElement(new Long(1L));
        vector3.addElement("cdfID");
        vector3.addElement("J");
        vector.addElement(vector3);
        vector.addElement(new Long(57L));
        vector4.addElement("id");
        vector4.addElement("J");
        vector.addElement(vector4);
        vector.addElement(new Long(1006L));
        vector.addElement(new Long(121L));
        vector2.addElement("cacheSize");
        vector2.addElement("J");
        vector.addElement(vector2);
        vector.addElement(new Long(1000L));
        this.id = this.getID();
        this.cdfID = this.myCDF.getID();
        this.myCDF.executeCommand(this, vector);
        return this.cacheSize;
    }

    public synchronized void selectReservePercent(long l) throws CDFException {
        Vector<Serializable> vector = new Vector<Serializable>();
        Vector<String> vector2 = new Vector<String>();
        Vector<String> vector3 = new Vector<String>();
        Vector<String> vector4 = new Vector<String>();
        vector.addElement(new Long(1005L));
        vector.addElement(new Long(1L));
        vector3.addElement("cdfID");
        vector3.addElement("J");
        vector.addElement(vector3);
        vector.addElement(new Long(57L));
        vector4.addElement("id");
        vector4.addElement("J");
        vector.addElement(vector4);
        vector.addElement(new Long(151L));
        vector2.addElement("reservePercent");
        vector2.addElement("J");
        vector.addElement(vector2);
        vector.addElement(new Long(1000L));
        this.reservePercent = l;
        this.id = this.getID();
        this.cdfID = this.myCDF.getID();
        this.myCDF.executeCommand(this, vector);
    }

    public synchronized long confirmReservePercent() throws CDFException {
        Vector<Serializable> vector = new Vector<Serializable>();
        Vector<String> vector2 = new Vector<String>();
        Vector<String> vector3 = new Vector<String>();
        Vector<String> vector4 = new Vector<String>();
        vector.addElement(new Long(1005L));
        vector.addElement(new Long(1L));
        vector3.addElement("cdfID");
        vector3.addElement("J");
        vector.addElement(vector3);
        vector.addElement(new Long(57L));
        vector4.addElement("id");
        vector4.addElement("J");
        vector.addElement(vector4);
        vector.addElement(new Long(1006L));
        vector.addElement(new Long(151L));
        vector2.addElement("reservePercent");
        vector2.addElement("J");
        vector.addElement(vector2);
        vector.addElement(new Long(1000L));
        this.id = this.getID();
        this.cdfID = this.myCDF.getID();
        this.myCDF.executeCommand(this, vector);
        return this.reservePercent;
    }

    public synchronized long confirmPadValue() throws CDFException {
        Vector<Serializable> vector = new Vector<Serializable>();
        Vector<String> vector2 = new Vector<String>();
        Vector<String> vector3 = new Vector<String>();
        vector.addElement(new Long(1005L));
        vector.addElement(new Long(1L));
        vector2.addElement("cdfID");
        vector2.addElement("J");
        vector.addElement(vector2);
        vector.addElement(new Long(57L));
        vector3.addElement("id");
        vector3.addElement("J");
        vector.addElement(vector3);
        vector.addElement(new Long(1006L));
        vector.addElement(new Long(73L));
        vector.addElement(new Long(1000L));
        this.id = this.getID();
        this.cdfID = this.myCDF.getID();
        this.myCDF.executeCommand(this, vector);
        return this.myCDF.getStatus();
    }

    public synchronized long getAllocatedFrom(long l) throws CDFException {
        Vector<Serializable> vector = new Vector<Serializable>();
        Vector<String> vector2 = new Vector<String>();
        Vector<String> vector3 = new Vector<String>();
        Vector<String> vector4 = new Vector<String>();
        Vector<String> vector5 = new Vector<String>();
        vector.addElement(new Long(1005L));
        vector.addElement(new Long(1L));
        vector4.addElement("cdfID");
        vector4.addElement("J");
        vector.addElement(vector4);
        vector.addElement(new Long(57L));
        vector5.addElement("id");
        vector5.addElement("J");
        vector.addElement(vector5);
        vector.addElement(new Long(1007L));
        vector.addElement(new Long(145L));
        vector2.addElement("recNum");
        vector2.addElement("J");
        vector.addElement(vector2);
        vector3.addElement("firstRec");
        vector3.addElement("J");
        vector.addElement(vector3);
        vector.addElement(new Long(1000L));
        this.recNum = l;
        this.id = this.getID();
        this.cdfID = this.myCDF.getID();
        this.myCDF.executeCommand(this, vector);
        return this.firstRec;
    }

    public synchronized long getAllocatedTo(long l) throws CDFException {
        Vector<Serializable> vector = new Vector<Serializable>();
        Vector<String> vector2 = new Vector<String>();
        Vector<String> vector3 = new Vector<String>();
        Vector<String> vector4 = new Vector<String>();
        Vector<String> vector5 = new Vector<String>();
        vector.addElement(new Long(1005L));
        vector.addElement(new Long(1L));
        vector4.addElement("cdfID");
        vector4.addElement("J");
        vector.addElement(vector4);
        vector.addElement(new Long(57L));
        vector5.addElement("id");
        vector5.addElement("J");
        vector.addElement(vector5);
        vector.addElement(new Long(1007L));
        vector.addElement(new Long(146L));
        vector2.addElement("firstRec");
        vector2.addElement("J");
        vector.addElement(vector2);
        vector3.addElement("lastRec");
        vector3.addElement("J");
        vector.addElement(vector3);
        vector.addElement(new Long(1000L));
        this.firstRec = l;
        this.id = this.getID();
        this.cdfID = this.myCDF.getID();
        this.myCDF.executeCommand(this, vector);
        return this.lastRec;
    }

    public synchronized void updateDataSpec(long l, long l2) throws CDFException {
        Vector<Serializable> vector = new Vector<Serializable>();
        Vector<String> vector2 = new Vector<String>();
        Vector<String> vector3 = new Vector<String>();
        Vector<String> vector4 = new Vector<String>();
        Vector<String> vector5 = new Vector<String>();
        vector.addElement(new Long(1005L));
        vector.addElement(new Long(1L));
        vector4.addElement("cdfID");
        vector4.addElement("J");
        vector.addElement(vector4);
        vector.addElement(new Long(57L));
        vector5.addElement("id");
        vector5.addElement("J");
        vector.addElement(vector5);
        vector.addElement(new Long(1008L));
        vector.addElement(new Long(72L));
        vector2.addElement("xdataType");
        vector2.addElement("J");
        vector.addElement(vector2);
        vector3.addElement("xnumElements");
        vector3.addElement("J");
        vector.addElement(vector3);
        vector.addElement(new Long(1000L));
        this.xdataType = l;
        this.xnumElements = l2;
        this.id = this.getID();
        this.cdfID = this.myCDF.getID();
        this.myCDF.executeCommand(this, vector);
        this.dataType = l;
        this.numElements = l2;
        this.setSignature();
    }

    public synchronized Vector getAttributes() {
        Variable variable = null;
        try {
            variable = this.myCDF.getVariable(this.getName());
            Vector<Attribute> vector = new Vector<Attribute>();
            Vector vector2 = this.myCDF.getVariableAttributes();
            Enumeration enumeration = vector2.elements();
            while (enumeration.hasMoreElements()) {
                Attribute attribute = (Attribute)enumeration.nextElement();
                try {
                    Entry entry = attribute.getEntry(variable);
                    if (entry == null) continue;
                    vector.addElement(attribute);
                }
                catch (CDFException cDFException) {}
            }
            return vector;
        }
        catch (CDFException cDFException) {
            return new Vector();
        }
    }

    public synchronized Map getAttributesandEntries() {
        return this.getAttributesandEntries(true);
    }

    public synchronized Map getAttributesandEntries(boolean bl) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        Vector vector = this.getAttributes();
        long l = this.getID();
        if (vector.size() == 0) {
            return null;
        }
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Attribute attribute = (Attribute)enumeration.nextElement();
            String string = attribute.getName();
            try {
                Entry entry = attribute.getEntry(l);
                Object object = entry.getData();
                if (bl) {
                    long l2 = entry.getDataType();
                    if (l2 == 31L) {
                        hashMap.put(string, Epoch.toEncode(object));
                        continue;
                    }
                    if (l2 == 32L) {
                        hashMap.put(string, Epoch16.toEncode(object));
                        continue;
                    }
                    if (l2 == 33L) {
                        hashMap.put(string, CDFTT2000.toEncode(object));
                        continue;
                    }
                    hashMap.put(string, object);
                    continue;
                }
                hashMap.put(string, object);
            }
            catch (CDFException cDFException) {
                System.out.println("error entry=" + cDFException);
            }
        }
        return hashMap;
    }

    public synchronized void dumpDataWithFormat(Object object) {
        String string;
        try {
            string = (String)this.getEntryData("FORMAT");
        }
        catch (CDFException cDFException) {
            string = null;
        }
        String string2 = CDFUtils.CFtoJformat(string);
        CDFUtils.printDataWithFormat(object, string2);
    }

    public synchronized void dumpDataWithFormat(Object object, PrintWriter printWriter) {
        String string;
        try {
            string = (String)this.getEntryData("FORMAT");
        }
        catch (CDFException cDFException) {
            string = null;
        }
        String string2 = CDFUtils.CFtoJformat(string);
        CDFUtils.printDataWithFormat(object, string2, printWriter, 0);
    }

    public synchronized void dumpDataWithFormat(CDFData cDFData) {
        String string;
        try {
            string = (String)this.getEntryData("FORMAT");
        }
        catch (CDFException cDFException) {
            string = null;
        }
        String string2 = CDFUtils.CFtoJformat(string);
        cDFData.dumpDataWithFormat(string2);
    }
}

