/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 */

/* Patch directory path traversal failure test */

async function run_test() {
  if (!setupTestCommon()) {
    return;
  }
  const STATE_AFTER_RUNUPDATE = gIsServiceTest
    ? STATE_PENDING_SVC
    : STATE_PENDING;
  gTestFiles = gTestFilesCompleteSuccess;
  gTestDirs = gTestDirsCompleteSuccess;
  setTestFilesAndDirsForFailure();
  await setupUpdaterTest(FILE_COMPLETE_MAR, false);
  let path = getUpdateDirFile(DIR_PATCH);
  if (AppConstants.platform == "win") {
    path = path + "\\..\\";
  } else {
    path = path + "/../";
  }
  runUpdate(STATE_AFTER_RUNUPDATE, false, 1, true, path, null, null, null);
  await testPostUpdateProcessing();
  checkPostUpdateRunningFile(false);
  checkFilesAfterUpdateFailure(getApplyDirFile);
  await waitForUpdateXMLFiles(true, false);
  await checkUpdateManager(
    STATE_AFTER_RUNUPDATE,
    true,
    STATE_AFTER_RUNUPDATE,
    0,
    0
  );
  await waitForFilesInUse();
}
