// DO NOT EDIT! This test has been generated by /html/canvas/tools/gentest.py.
// OffscreenCanvas test in a worker:2d.color.type.u8srgb.to.u8p3.to.u8srgb
// Description:test display-p3 unorm8 canvas not storing 8-bit srgb data accurately
// Note:

importScripts("/resources/testharness.js");
importScripts("/html/canvas/resources/canvas-tests.js");

var t = async_test("test display-p3 unorm8 canvas not storing 8-bit srgb data accurately");
var t_pass = t.done.bind(t);
var t_fail = t.step_func(function(reason) {
    throw reason;
});
t.step(function() {

  var canvas = new OffscreenCanvas(100, 50);
  var ctx = canvas.getContext('2d', {colorType: "unorm8", colorSpace: "display-p3"});

  // Consider the color in sRGB:
  //   (5,250,128)/255
  // In Display P3 this is:
  //   (0.4504003868394956, 0.9659537930632748, 0.5523945982276097)
  // Quantized to 8-bit, this is:
  //   (115, 246, 141)/255
  // Converted back to sRGB this is:
  //   (8.909609662725, 249.672568247041, 128.228541784731)/255
  // Quantized to 8-bit, this is:
  //   (9, 250, 128)
  var input = new ImageData(new Uint8ClampedArray([5, 250, 128, 255]),
                            1, 1, {colorSpace: "srgb"});
  ctx.putImageData(input, 0, 0);
  var readback = ctx.getImageData(0, 0, 1, 1, {colorSpace:"srgb"});
  const kEpsilon = 2;
  assert_approx_equals(readback.data[0], 9, kEpsilon);
  assert_approx_equals(readback.data[1], 250, kEpsilon);
  assert_approx_equals(readback.data[2], 128, kEpsilon);
  t.done();
});
done();
