/* SPDX-License-Identifier: GPL-2.0-only */

#include <mainboard/gpio.h>
#include <soc/gpio.h>

static const struct pad_config gpio_table[] = {
	/* ------- GPIO Group GPD ------- */
	PAD_CFG_NF(GPD0, UP_20K, PWROK, NF1), // PM_BATLOW@
	PAD_CFG_NF(GPD1, NATIVE, PWROK, NF1), // AC_PRESENT
	PAD_CFG_GPI(GPD2, NONE, PWROK), // LAN_WAKEUP#
	PAD_CFG_NF(GPD3, UP_20K, PWROK, NF1), // PWR_BTN#
	PAD_CFG_NF(GPD4, NONE, PWROK, NF1), // SUSB#_PCH
	PAD_CFG_NF(GPD5, NONE, PWROK, NF1), // SUSC#_PCH
	PAD_NC(GPD6, NONE),
	PAD_CFG_GPO(GPD7, 1, PWROK), // GPD7_REST
	PAD_CFG_NF(GPD8, NONE, PWROK, NF1), // SUS_CLK
	PAD_CFG_GPO(GPD9, 0, PWROK), // PCH_SLP_WLAN#_R / GPD9_RTD3
	PAD_NC(GPD10, NONE),
	PAD_CFG_GPI(GPD11, UP_20K, DEEP), // LAN_DISABLE#

	/* ------- GPIO Group GPP_A ------- */
	PAD_CFG_NF(GPP_A0, UP_20K, DEEP, NF1), // ESPI_AD0
	PAD_CFG_NF(GPP_A1, UP_20K, DEEP, NF1), // ESPI_AD1
	PAD_CFG_NF(GPP_A2, UP_20K, DEEP, NF1), // ESPI_AD2
	PAD_CFG_NF(GPP_A3, UP_20K, DEEP, NF1), // ESPI_AD3
	PAD_CFG_NF(GPP_A4, UP_20K, DEEP, NF1), // ESPI_CS#
	PAD_CFG_NF(GPP_A5, DN_20K, DEEP, NF1), // ESPI_CLK_EC
	PAD_CFG_NF(GPP_A6, NONE, DEEP, NF1), // ESPI_RESET#
	PAD_NC(GPP_A7, NONE),
	PAD_CFG_NF(GPP_A8, NONE, DEEP, NF2), // CNVI_RST#
	PAD_CFG_NF(GPP_A9, NONE, DEEP, NF3), // CNVI_CLKREQ
	PAD_NC(GPP_A10, NONE),
	PAD_NC(GPP_A11, NONE),
	PAD_CFG_NF(GPP_A12, UP_20K, DEEP, NF1), // SATAGP1
	PAD_CFG_GPO(GPP_A13, 1, PLTRST), // PCH_BT_EN
	PAD_NC(GPP_A14, NONE),
	PAD_NC(GPP_A15, NONE),
	PAD_NC(GPP_A16, NONE),
	PAD_NC(GPP_A17, NONE),
	PAD_CFG_NF(GPP_A18, NONE, DEEP, NF1), // HDMI_HDP
	PAD_NC(GPP_A19, NONE),
	PAD_NC(GPP_A20, NONE),
	PAD_NC(GPP_A21, NONE),
	PAD_NC(GPP_A22, NONE),
	PAD_CFG_GPO(GPP_A23, 0, PLTRST), // GPP_A23_TBT_FORCE_PWR

	/* ------- GPIO Group GPP_B ------- */
	PAD_CFG_NF(GPP_B0, NONE, DEEP, NF1), // VCCIN_AUX_VID0
	PAD_CFG_NF(GPP_B1, NONE, DEEP, NF1), // VCCIN_AUX_VID1
	PAD_CFG_GPI(GPP_B2, UP_20K, DEEP), // VRALERT#_PD
	PAD_CFG_GPI_INT(GPP_B3, NONE, PLTRST, LEVEL), // GPP_B3 - touchpad interrupt
	PAD_NC(GPP_B4, NONE),
	PAD_NC(GPP_B5, NONE),
	PAD_NC(GPP_B6, NONE),
	PAD_NC(GPP_B7, NONE),
	PAD_CFG_GPO(GPP_B8, 1, DEEP), // SB_BLON
	PAD_NC(GPP_B9, NONE),
	PAD_NC(GPP_B10, NONE),
	PAD_CFG_NF(GPP_B11, NONE, PWROK, NF1), // TBTA-PCH_I2C_INT
	PAD_CFG_NF(GPP_B12, NONE, DEEP, NF1), // SLP_S0#
	PAD_CFG_NF(GPP_B13, NONE, DEEP, NF1), // PLT_RST#
	PAD_CFG_GPO(GPP_B14, 0, DEEP), // PCH_SPKR
	PAD_CFG_GPO(GPP_B15, 1, DEEP), // PCH_GPP_B15
	_PAD_CFG_STRUCT(GPP_B16, 0x44000301, 0x0000), // SDD1_PWR_EN
	PAD_NC(GPP_B17, NONE),
	PAD_NC(GPP_B18, NONE), // NO REBOOT strap
	PAD_NC(GPP_B19, NONE),
	PAD_NC(GPP_B20, NONE),
	PAD_NC(GPP_B21, NONE),
	PAD_NC(GPP_B22, NONE),
	PAD_CFG_GPO(GPP_B23, 0, DEEP), // strap

	/* ------- GPIO Group GPP_C ------- */
	PAD_CFG_NF(GPP_C0, NONE, DEEP, NF1), // SMB_CLK / SMB_CLK_DDR
	PAD_CFG_NF(GPP_C1, NONE, DEEP, NF1), // SMB_DATA / SMB_DAT_DDR
	PAD_NC(GPP_C2, NONE), // Intel ME Crypto TLS strap
	PAD_CFG_NF(GPP_C3, NONE, DEEP, NF1), // SML0_CLK
	PAD_CFG_NF(GPP_C4, NONE, DEEP, NF1), // SML0_DATA
	PAD_NC(GPP_C5, NONE), // boot config strap, bit 0
	PAD_CFG_NF(GPP_C6, NONE, PWROK, NF1), // TBT-PCH_I2C_SCL
	PAD_CFG_NF(GPP_C7, NONE, PWROK, NF1), // TBT-PCH_I2C_SDA
	PAD_NC(GPP_C8, NONE),
	PAD_NC(GPP_C9, NONE),
	PAD_NC(GPP_C10, NONE),
	PAD_NC(GPP_C11, NONE),
	PAD_NC(GPP_C12, NONE),
	PAD_NC(GPP_C13, NONE),
	_PAD_CFG_STRUCT(GPP_C14, 0x40100100, 0x3000), // TPM_PIRQ#
	PAD_NC(GPP_C15, NONE),
	PAD_CFG_NF(GPP_C16, NONE, DEEP, NF1), // T_SCL
	PAD_CFG_NF(GPP_C17, NONE, DEEP, NF1), // T_SDA
	PAD_CFG_NF(GPP_C18, NONE, DEEP, NF1), // PCH_I2C_SDA
	PAD_CFG_NF(GPP_C19, NONE, DEEP, NF1), // PCH_I2C_SCL
	//PAD_CFG_NF(GPP_C20, UP_20K, DEEP, NF1), // UART2_RXD
	//PAD_CFG_NF(GPP_C21, UP_20K, DEEP, NF1), // UART2_TXD
	PAD_CFG_GPO(GPP_C22, 1, PLTRST), // LAN_PLT_RST#
	_PAD_CFG_STRUCT(GPP_C23, 0x40880100, 0x0000), // PCH_GPP_C23

	/* ------- GPIO Group GPP_D ------- */
	PAD_NC(GPP_D0, NONE),
	PAD_NC(GPP_D1, NONE),
	PAD_CFG_GPI(GPP_D2, NONE, PLTRST), // GPP_D2_SDCARD_RST#
	PAD_CFG_GPI(GPP_D3, NONE, PLTRST), // GPP_D3_WLAN_PLT_RST#
	PAD_NC(GPP_D4, NONE),
	PAD_CFG_NF(GPP_D5, NONE, DEEP, NF1), // SSD1_CLKREQ#
	PAD_CFG_NF(GPP_D6, NONE, DEEP, NF1), // WLAN_CLKREQ#
	PAD_CFG_NF(GPP_D7, NONE, DEEP, NF1), // CARD_CLKREQ#
	PAD_CFG_NF(GPP_D8, NONE, DEEP, NF1), // GLAN_CLKREQ#
	PAD_NC(GPP_D9, NONE),
	PAD_NC(GPP_D10, NONE), // DPP3 I2C / TBT_LSX2 strap
	PAD_CFG_GPI(GPP_D11, DN_20K, DEEP), // BOARD_ID
	PAD_CFG_GPI(GPP_D12, DN_20K, DEEP), // DDP4 I2C / TBT_LSX3 strap
	PAD_CFG_GPO(GPP_D13, 1, PLTRST), // GPP_D13_SSD1_PLT_RST#
	PAD_CFG_GPO(GPP_D14, 1, PLTRST), // SSD_PWR_EN
	PAD_NC(GPP_D15, NONE),
	PAD_NC(GPP_D16, NONE),
	PAD_NC(GPP_D17, NONE),
	PAD_NC(GPP_D18, NONE),
	PAD_NC(GPP_D19, NONE),

	/* ------- GPIO Group GPP_E ------- */
	PAD_CFG_NF(GPP_E0, NONE, DEEP, NF1), // SATAGP0
	PAD_CFG_GPO(GPP_E1, 0, PLTRST), // ROM_I2C_EN
	_PAD_CFG_STRUCT(GPP_E2, 0x40880100, 0x0000), // SWI#
	PAD_CFG_GPI(GPP_E3, DN_20K, DEEP), // SCI#
	PAD_NC(GPP_E4, NONE), // DEVSLP0
	PAD_NC(GPP_E5, NONE), // DEVSLP1
	PAD_NC(GPP_E6, NONE), // PCH_GPP_E6 strap
	_PAD_CFG_STRUCT(GPP_E7, 0x82840100, 0x0000), // SMI#
	PAD_NC(GPP_E8, NONE),
	PAD_NC(GPP_E9, NONE),
	PAD_NC(GPP_E10, NONE), // THC0_SPI1 chip select
	PAD_NC(GPP_E11, NONE), // THC0_SPI1 clock
	PAD_NC(GPP_E12, NONE),
	PAD_NC(GPP_E13, NONE),
	PAD_CFG_NF(GPP_E14, NONE, DEEP, NF1), // EDP_HPD
	PAD_NC(GPP_E15, NONE), // ALERT#
	PAD_CFG_GPI(GPP_E16, DN_20K, DEEP), // SB_KBCRST#
	PAD_NC(GPP_E17, NONE),
	// GPP_E18 (TBT_LSX0_TXD) configured by FSP (Ref: Intel doc 617016)
	// GPP_E19 (TBT_LSX0_RXD) configured by FSP (Ref: Intel doc 617016)
	PAD_NC(GPP_E20, NONE), // SWI#
	PAD_NC(GPP_E21, NONE), // DDP2 I2C / TBT_LSX1 strap
	PAD_NC(GPP_E22, NONE),
	PAD_NC(GPP_E23, NONE),

	/* ------- GPIO Group GPP_F ------- */
	PAD_CFG_NF(GPP_F0, NONE, DEEP, NF1), // CNVI_BRI_DT
	PAD_CFG_NF(GPP_F1, UP_20K, DEEP, NF1), // CNVI_BRI_RSP
	PAD_CFG_NF(GPP_F2, NONE, DEEP, NF1), // CNVI_RGI_DT
	PAD_CFG_NF(GPP_F3, UP_20K, DEEP, NF1), // CNVI_RGI_RSP
	PAD_NC(GPP_F4, NONE),
	PAD_NC(GPP_F5, NONE),
	PAD_NC(GPP_F6, NONE), // CNVI_GNSS_PA_BLANKING
	PAD_CFG_GPO(GPP_F7, 1, DEEP), // GPIO_LANRTD3
	PAD_NC(GPP_F8, NONE),
	PAD_CFG_GPO(GPP_F9, 1, DEEP), // GPIO_LAN_EN
	PAD_NC(GPP_F10, NONE), // strap
	PAD_NC(GPP_F11, NONE),
	PAD_NC(GPP_F12, NONE),
	PAD_NC(GPP_F13, NONE),
	PAD_NC(GPP_F14, NONE),
	PAD_NC(GPP_F15, NONE),
	PAD_NC(GPP_F16, NONE),
	PAD_CFG_GPI(GPP_F17, NONE, PLTRST), // TPM_DET#
	PAD_NC(GPP_F18, NONE),
	PAD_NC(GPP_F19, NONE),
	PAD_NC(GPP_F20, NONE), // EXT_PWR_GATE1#
	PAD_CFG_GPI(GPP_F21, DN_20K, DEEP), // EXT_PWR_GATE#
	PAD_NC(GPP_F22, NONE), // VNN_CTRL
	PAD_NC(GPP_F23, NONE), // 1P05_CTRL

	/* ------- GPIO Group GPP_H ------- */
	PAD_CFG_GPO(GPP_H0, 1, PLTRST), // boot config strap, bit 1
	PAD_NC(GPP_H1, NONE), // boot config strap, bit 2
	PAD_NC(GPP_H2, NONE), // boot config strap, bit 3
	PAD_NC(GPP_H3, NONE),
	PAD_CFG_NF(GPP_H4, NONE, DEEP, NF1), // GPPH_I2C2_SDA
	PAD_CFG_NF(GPP_H5, NONE, DEEP, NF1), // GPPH_I2C2_SCL
	PAD_NC(GPP_H6, NONE),
	PAD_NC(GPP_H7, NONE), // SWI#
	PAD_CFG_GPI(GPP_H8, DN_20K, DEEP), // CNVI_MFUART2_RXD
	PAD_CFG_GPI(GPP_H9, DN_20K, DEEP), // CNVI_MFUART2_TXD
	PAD_CFG_NF(GPP_H10, NONE, DEEP, NF1), // SSD0_CLKREQ#
	PAD_NC(GPP_H11, NONE),
	PAD_NC(GPP_H12, NONE),
	PAD_NC(GPP_H13, NONE),
	PAD_NC(GPP_H14, NONE),
	PAD_NC(GPP_H15, NONE),
	PAD_CFG_NF(GPP_H16, NONE, DEEP, NF1), // HDMI_CTRLCLK
	PAD_CFG_NF(GPP_H17, NONE, DEEP, NF1), // HDMI_CTRLDATA
	PAD_CFG_NF(GPP_H18, NONE, DEEP, NF1), // CPU_C10_GATE#
	PAD_NC(GPP_H19, NONE), // CNVI_WAKE#
	PAD_NC(GPP_H20, NONE), // PM_CLKRUN#
	PAD_NC(GPP_H21, NONE),
	PAD_NC(GPP_H22, NONE),
	PAD_NC(GPP_H23, NONE),

	/* ------- GPIO Group GPP_R ------- */
	PAD_CFG_NF(GPP_R0, NONE, DEEP, NF1), // HDA_BITCLK
	PAD_CFG_NF(GPP_R1, NATIVE, DEEP, NF1), // HDA_SYNC
	PAD_CFG_NF(GPP_R2, NATIVE, DEEP, NF1), // HDA_SDOUT / ME_WE
	PAD_CFG_NF(GPP_R3, NATIVE, DEEP, NF1), // HDA_SDIN0
	PAD_CFG_NF(GPP_R4, NONE, DEEP, NF1), // AZ_RST#
	PAD_NC(GPP_R5, NONE),
	PAD_NC(GPP_R6, NONE),
	PAD_NC(GPP_R7, NONE), // ALERT#

	/* ------- GPIO Group GPP_S ------- */
	PAD_NC(GPP_S0, NONE),
	PAD_NC(GPP_S1, NONE),
	PAD_NC(GPP_S2, NONE),
	PAD_NC(GPP_S3, NONE),
	PAD_NC(GPP_S4, NONE),
	PAD_NC(GPP_S5, NONE),
	PAD_NC(GPP_S6, NONE), // GPPC_DMIC_CLK
	PAD_NC(GPP_S7, NONE), // GPPC_DMIC_DATA

	/* ------- GPIO Group GPP_T ------- */
	PAD_NC(GPP_T2, NONE),
	PAD_NC(GPP_T3, NONE),

	/* ------- GPIO Group GPP_U ------- */
	PAD_CFG_GPO(GPP_U4, 0, PLTRST), // GPIO_SDCARD_EN
	PAD_CFG_GPO(GPP_U5, 1, PLTRST), // SDCARD_WAKE#
};

void mainboard_configure_gpios(void)
{
	gpio_configure_pads(gpio_table, ARRAY_SIZE(gpio_table));
}
