/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.fishbone.structures;

import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.xmind.gef.draw2d.IRotatableFigure;
import org.xmind.gef.draw2d.IRotatableReferencedFigure;
import org.xmind.gef.draw2d.geometry.IPrecisionTransformer;
import org.xmind.gef.draw2d.geometry.PrecisionDimension;
import org.xmind.gef.draw2d.geometry.PrecisionHorizontalFlipper;
import org.xmind.gef.draw2d.geometry.PrecisionInsets;
import org.xmind.gef.draw2d.geometry.PrecisionRotator;
import org.xmind.gef.graphicalpolicy.IStyleSelector;
import org.xmind.gef.part.IGraphicalPart;
import org.xmind.ui.branch.BranchStructureData;
import org.xmind.ui.internal.fishbone.structures.FishboneData;
import org.xmind.ui.internal.fishbone.structures.ISubDirection;
import org.xmind.ui.mindmap.IBranchPart;
import org.xmind.ui.mindmap.ILabelPart;
import org.xmind.ui.mindmap.ITopicPart;
import org.xmind.ui.style.StyleUtils;

public class SubFishboneData
extends BranchStructureData {
    private static final int PADDING = 1;
    private static final double fMinor = 1.0;
    private ISubDirection direction;
    private FishboneData data = null;
    private double padding = -1.0;
    public final IPrecisionTransformer h = new PrecisionHorizontalFlipper();
    public final PrecisionRotator r1 = new PrecisionRotator();
    public final PrecisionRotator r2 = new PrecisionRotator();

    public SubFishboneData(IBranchPart branch, ISubDirection direction) {
        super(branch);
        this.direction = direction;
        this.r1.setAngle(direction.isRotated() ? direction.getRotateAngle() : direction.getSubDirection().getRotateAngle());
        this.r1.setEnabled(direction.isRotated());
        this.h.setEnabled(direction.isRightHeaded());
        this.r2.setAngle(this.h.isEnabled() ? this.r1.getAngle() : -this.r1.getAngle());
    }

    public FishboneData getFishboneData() {
        if (this.data == null) {
            this.data = this.createFishboneData();
        }
        return this.data;
    }

    public double getPadding() {
        if (this.padding < 0.0) {
            this.padding = this.calcPadding();
        }
        return this.padding;
    }

    private double calcPadding() {
        int p = 1;
        IStyleSelector ss = this.getBranch().getBranchPolicy().getStyleSelector((IGraphicalPart)this.getBranch());
        int lineWidth = StyleUtils.getInteger((IGraphicalPart)this.getBranch(), (IStyleSelector)ss, (String)"line-width", (int)1);
        p = (int)((double)p + (double)lineWidth * 0.5);
        return p;
    }

    private FishboneData createFishboneData() {
        ILabelPart label;
        IFigure figure;
        FishboneData data = new FishboneData();
        ITopicPart topicPart = this.getBranch().getTopicPart();
        if (topicPart != null && (figure = topicPart.getFigure()) instanceof IRotatableReferencedFigure) {
            data.topicRefIns = new PrecisionInsets(((IRotatableReferencedFigure)figure).getNormalReferenceDescription());
        }
        if ((label = this.getBranch().getLabel()) != null && label.getFigure().isVisible()) {
            IFigure labelFigure = label.getFigure();
            PrecisionDimension size = labelFigure instanceof IRotatableFigure ? ((IRotatableFigure)labelFigure).getNormalPreferredSize(-1, -1) : new PrecisionDimension(label.getFigure().getPreferredSize());
            if (data.topicRefIns == null) {
                data.topicRefIns = new PrecisionInsets(0.0, size.width / 2.0, size.height, size.width / 2.0);
            } else {
                data.topicRefIns.left = Math.max(data.topicRefIns.left, size.width / 2.0);
                data.topicRefIns.right = Math.max(data.topicRefIns.right, size.width / 2.0);
                data.topicRefIns.bottom += size.height;
            }
        }
        if (data.topicRefIns == null) {
            data.topicRefIns = new PrecisionInsets();
        }
        data.rTopicRefIns = this.h.ri(this.r2.ti(this.h.ti(data.topicRefIns)));
        data.branchRefIns = new PrecisionInsets(data.topicRefIns);
        data.rBranchRefIns = this.h.ri(this.r2.ti(this.h.ti(data.branchRefIns)));
        List calloutBranches = this.getBranch().getCalloutBranches();
        if (!calloutBranches.isEmpty() && !this.getBranch().isFolded()) {
            this.direction.fillFishboneExtraData(this.getBranch(), data, this.h, this.r2, 0.0, true);
        }
        if (!this.getSubBranches().isEmpty() && !this.getBranch().isFolded()) {
            double spacing = (double)this.getMinorSpacing() * 1.0;
            this.direction.fillFishboneData(this.getBranch(), data, this.h, this.r2, spacing, this.getSubBranches());
            double padding = this.getPadding();
            data.branchRefIns.add(padding);
            data.rBranchRefIns.add(padding);
        }
        return data;
    }
}

