/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.fishbone.decorations;

import org.eclipse.draw2d.IFigure;
import org.xmind.gef.draw2d.IAnchor;
import org.xmind.gef.draw2d.geometry.Geometry;
import org.xmind.gef.draw2d.geometry.PrecisionLine;
import org.xmind.gef.draw2d.geometry.PrecisionPoint;
import org.xmind.gef.draw2d.graphics.Path;
import org.xmind.ui.decorations.AbstractBranchConnection;
import org.xmind.ui.internal.fishbone.structures.ISubDirection;
import org.xmind.ui.mindmap.IBranchPart;

public class FishboneBranchConnection
extends AbstractBranchConnection {
    private IBranchPart branch;
    private PrecisionPoint joint = null;

    public FishboneBranchConnection(IBranchPart branch, String id) {
        super(id);
        this.branch = branch;
    }

    protected boolean usesFill() {
        return false;
    }

    protected void route(IFigure figure, Path shape) {
        PrecisionPoint sp = this.getSourcePosition(figure);
        PrecisionPoint tp = this.getTargetPosition(figure);
        shape.moveTo(sp);
        if (this.joint != null) {
            shape.lineTo(this.joint);
        }
        shape.lineTo(tp);
    }

    protected void reroute(IFigure figure, PrecisionPoint sourcePos, PrecisionPoint targetPos, boolean validating) {
        IAnchor sa = this.getSourceAnchor();
        IAnchor ta = this.getTargetAnchor();
        if (sa != null && ta != null) {
            PrecisionPoint p4;
            PrecisionPoint p3;
            PrecisionPoint p2;
            PrecisionPoint p1 = sa.getLocation(Geometry.getOppositePosition((int)this.getSourceOrientation()), 0.0);
            PrecisionPoint j = this.calcJoint(p1, p2 = sa.getLocation(this.getSourceOrientation(), (double)this.getSourceExpansion()), p3 = ta.getLocation(this.getTargetOrientation(), (double)this.getTargetExpansion()), p4 = ta.getLocation(Geometry.getOppositePosition((int)this.getTargetOrientation()), 0.0));
            if (j == null) {
                if (p3.getDistance2(p2) > p4.getDistance2(p2)) {
                    PrecisionPoint temp = p3;
                    p3 = p4;
                    p4 = temp;
                }
                j = this.calcJoint2(ta.getOwner(), p1, p2, p3, p4);
            }
            if (this.needsSourceLine(ta.getOwner())) {
                this.joint = j;
                sourcePos.setLocation(p2);
                targetPos.setLocation(this.calcTarget(ta.getOwner(), p3, p4));
            } else {
                this.joint = null;
                sourcePos.setLocation(j);
                targetPos.setLocation(this.calcTarget(ta.getOwner(), p3, p4));
            }
        }
    }

    private PrecisionPoint calcJoint2(IFigure child, PrecisionPoint p1, PrecisionPoint p2, PrecisionPoint p3, PrecisionPoint p4) {
        double angle = this.calcAngle(p1, p2, p3, p4);
        PrecisionPoint p6 = p3.getMoved(Math.toRadians(angle), 100.0);
        PrecisionPoint j = this.calcJoint(p1, p2, p3, p6);
        if (j == null) {
            return p3;
        }
        return j;
    }

    private double calcAngle(PrecisionPoint p1, PrecisionPoint p2, PrecisionPoint p3, PrecisionPoint p4) {
        if (Math.abs(p1.y - p2.y) < 2.0) {
            if (p1.x > p2.x) {
                if (p3.y < p1.y) {
                    return ISubDirection.NWR.getRotateAngle();
                }
                return ISubDirection.SWR.getRotateAngle();
            }
            if (p3.y < p1.y) {
                return ISubDirection.NER.getRotateAngle();
            }
            return ISubDirection.SER.getRotateAngle();
        }
        return 0.0;
    }

    private PrecisionPoint calcJoint(PrecisionPoint p1, PrecisionPoint p2, PrecisionPoint p3, PrecisionPoint p4) {
        if (this.isParalell(p1, p2, p3, p4)) {
            return null;
        }
        PrecisionLine line1 = new PrecisionLine(p1, p2, PrecisionLine.LineType.Line);
        PrecisionLine line2 = new PrecisionLine(p4, p3, PrecisionLine.LineType.Line);
        return line1.intersect(line2);
    }

    private boolean isParalell(PrecisionPoint p1, PrecisionPoint p2, PrecisionPoint p3, PrecisionPoint p4) {
        double dx1 = p1.x - p2.x;
        double dy1 = p1.y - p2.y;
        double dx2 = p3.x - p4.x;
        double dy2 = p3.y - p4.y;
        if (Math.abs(dx1) < 2.0) {
            return Math.abs(dx2) < 2.0;
        }
        if (Math.abs(dy1) < 2.0) {
            return Math.abs(dy2) < 2.0;
        }
        double s1 = dy1 / dx1;
        double s2 = dy2 / dx2;
        return Math.abs(s1 / s2 - 1.0) < 0.01;
    }

    private PrecisionPoint calcTarget(IFigure child, PrecisionPoint p3, PrecisionPoint p4) {
        return p3;
    }

    private boolean needsSourceLine(IFigure child) {
        return child == null || !this.isChild(child, this.branch.getFigure());
    }

    private boolean isChild(IFigure figure, IFigure branchFigure) {
        IFigure parent = figure.getParent();
        if (parent == branchFigure) {
            return true;
        }
        if (parent == null || parent == branchFigure.getParent()) {
            return false;
        }
        return this.isChild(parent, branchFigure);
    }

    public void invalidate() {
        this.joint = null;
        super.invalidate();
    }
}

