/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.ideafactory;

import org.xmind.core.ITopic;
import org.xmind.core.ITopicExtensionElement;
import org.xmind.core.event.ICoreEventSource;
import org.xmind.gef.command.SourceCommand;
import org.xmind.ui.internal.ideafactory.IdeaFactoryMessages;

public class ModifyIdeaGroupTitleCommand
extends SourceCommand {
    private ITopic rootTopic;
    private ITopicExtensionElement modifiedGroup;
    private String groupTitle;
    private String oldGroupTitle;
    private int index;

    public ModifyIdeaGroupTitleCommand(ITopic rootTopic, ITopicExtensionElement modifiedGroup, String groupTitle) {
        super((Object)rootTopic);
        this.rootTopic = rootTopic;
        this.modifiedGroup = modifiedGroup;
        this.groupTitle = groupTitle == null ? "" : groupTitle;
        this.setLabel(IdeaFactoryMessages.ModifyIdeaGroupTitleCommand_Modify_Idea_Title);
    }

    public void redo() {
        if (!this.canRedo()) {
            return;
        }
        if (this.oldGroupTitle == null) {
            this.oldGroupTitle = this.modifiedGroup.getTextContent();
            this.index = ((ITopicExtensionElement)this.modifiedGroup.getParent()).getChildren("group").indexOf(this.modifiedGroup);
        }
        this.modifiedGroup.setTextContent(this.groupTitle);
        this.fireCoreEvent(this.rootTopic, "ideaGroupTitle");
        super.redo();
    }

    public void undo() {
        if (!this.canUndo()) {
            return;
        }
        if (this.oldGroupTitle != null) {
            this.modifiedGroup.setTextContent(this.oldGroupTitle);
            this.fireCoreEvent(this.rootTopic, "ideaGroupTitle");
        }
        super.undo();
    }

    private void fireCoreEvent(ITopic topic, String eventType) {
        if (topic instanceof ICoreEventSource) {
            ((ICoreEventSource)topic).getCoreEventSupport().dispatchIndexedTargetChange((ICoreEventSource)topic, eventType, (Object)this.modifiedGroup, this.index);
        }
    }
}

