/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.viewers;

import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.xmind.ui.viewers.HintedListLayout;
import org.xmind.ui.viewers.MListViewer;

public class StraightListLayout
extends HintedListLayout {
    private boolean horizontal;

    public StraightListLayout(int style) {
        this.horizontal = (style & 0x100) != 0;
    }

    @Override
    public Point computeSize(MListViewer viewer, Composite composite, int wHint, int hHint, boolean flushCache) {
        if (wHint >= 0 && hHint >= 0) {
            return new Point(wHint, hHint);
        }
        Control[] items = composite.getChildren();
        int hListAlignment = this.getHint("alignment.list.horizontal", this.horizontal ? 16384 : 4);
        int vListAlignment = this.getHint("alignment.list.vertical", this.horizontal ? 4 : 16384);
        int itemWHint = this.getHint("item.width", this.horizontal || hListAlignment != 4 ? -1 : wHint);
        int itemHHint = this.getHint("item.height", this.horizontal && vListAlignment == 4 ? hHint : -1);
        int spacing = this.getHint(this.horizontal ? "spacing.horizontal" : "spacing.vertical", 0);
        Point listSize = new Point(0, 0);
        int i = 0;
        while (i < items.length) {
            Control item = items[i];
            Point itemSize = item.computeSize(itemWHint, itemHHint, flushCache);
            if (this.horizontal) {
                listSize.x += itemSize.x;
                listSize.y = Math.max(listSize.y, itemSize.y);
            } else {
                listSize.x = Math.max(listSize.x, itemSize.x);
                listSize.y += itemSize.y;
            }
            ++i;
        }
        if (items.length > 0) {
            if (this.horizontal) {
                listSize.x += spacing * (items.length - 1);
            } else {
                listSize.y += spacing * (items.length - 1);
            }
        }
        listSize.x += this.getHint("margin.left", 0) + this.getHint("margin.right", 0);
        listSize.y += this.getHint("margin.top", 0) + this.getHint("margin.bottom", 0);
        return listSize;
    }

    @Override
    public void layout(MListViewer viewer, Composite composite, boolean flushCache) {
        Point itemSize;
        Control item;
        Rectangle area = composite.getClientArea();
        Control[] items = composite.getChildren();
        if (items.length <= 0) {
            return;
        }
        int marginTop = this.getHint("margin.top", 0);
        int marginBottom = this.getHint("margin.bottom", 0);
        int marginLeft = this.getHint("margin.left", 0);
        int marginRight = this.getHint("margin.right", 0);
        int spacing = this.getHint(this.horizontal ? "spacing.horizontal" : "spacing.vertical", 0);
        int hListAlignment = this.getHint("alignment.list.horizontal", this.horizontal ? 16384 : 4);
        int vListAlignment = this.getHint("alignment.list.vertical", this.horizontal ? 4 : 16384);
        int hItemAlignment = this.getHint("alignment.item.horizontal", 4);
        int vItemAlignment = this.getHint("alignment.item.vertical", 4);
        if (marginLeft + marginRight > area.width) {
            area.x += (marginLeft + marginRight - area.width) / 2;
            area.width = marginLeft + marginRight;
        }
        if (marginTop + marginBottom > area.height) {
            area.y += (marginTop + marginBottom - area.height) / 2;
            area.height = marginTop + marginBottom;
        }
        int left = area.x + marginLeft;
        int top = area.y + marginTop;
        int wHint = area.width - marginLeft - marginRight;
        int hHint = area.height - marginTop - marginBottom;
        int itemWHint = this.getHint("item.width", this.horizontal || hListAlignment != 4 ? -1 : wHint);
        int itemHHint = this.getHint("item.height", this.horizontal && vListAlignment == 4 ? hHint : -1);
        Point listSize = new Point(0, 0);
        Point[] itemSizes = new Point[items.length];
        int i = 0;
        while (i < items.length) {
            item = items[i];
            itemSize = item.computeSize(itemWHint, itemHHint, flushCache);
            itemSizes[i] = new Point(itemSize.x, itemSize.y);
            if (this.horizontal) {
                listSize.x += itemSize.x;
                listSize.y = Math.max(listSize.y, itemSize.y);
            } else {
                listSize.x = Math.max(listSize.x, itemSize.x);
                listSize.y += itemSize.y;
            }
            ++i;
        }
        int allSpacing = spacing * (items.length - 1);
        int allAdjustment = 0;
        if (hListAlignment == 4) {
            if (this.horizontal) {
                allAdjustment = wHint - allSpacing - listSize.x;
            } else {
                listSize.x = wHint;
            }
        } else if (hListAlignment == 0x1000000) {
            left += (wHint - allSpacing - listSize.x) / 2;
        } else if (hListAlignment == 131072) {
            left += wHint - allSpacing - listSize.x;
        }
        if (vListAlignment == 4) {
            if (this.horizontal) {
                listSize.y = hHint;
            } else {
                allAdjustment = hHint - allSpacing - listSize.y;
            }
        } else if (vListAlignment == 0x1000000) {
            top += (hHint - allSpacing - listSize.y) / 2;
        } else if (vListAlignment == 131072) {
            top += hHint - allSpacing - listSize.y;
        }
        int i2 = 0;
        while (i2 < items.length) {
            if (i2 > 0) {
                if (this.horizontal) {
                    left += spacing;
                } else {
                    top += spacing;
                }
            }
            item = items[i2];
            itemSize = itemSizes[i2];
            int adjustment = allAdjustment / (items.length - i2);
            allAdjustment -= adjustment;
            Point cellSize = this.horizontal ? new Point(itemSize.x + adjustment, listSize.y) : new Point(listSize.x, itemSize.y + adjustment);
            Rectangle itemBounds = new Rectangle(left, top, itemSize.x, itemSize.y);
            if (hItemAlignment == 4) {
                itemBounds.width = cellSize.x;
            } else if (hItemAlignment == 0x1000000) {
                itemBounds.x += (cellSize.x - itemBounds.width) / 2;
            } else if (hItemAlignment == 131072) {
                itemBounds.x += cellSize.x - itemBounds.width;
            }
            if (vItemAlignment == 4) {
                itemBounds.height = cellSize.y;
            } else if (vItemAlignment == 0x1000000) {
                itemBounds.y += (cellSize.y - itemBounds.height) / 2;
            } else if (vItemAlignment == 131072) {
                itemBounds.y += cellSize.y - itemBounds.height;
            }
            item.setBounds(itemBounds);
            if (this.horizontal) {
                left += cellSize.x;
            } else {
                top += cellSize.y;
            }
            ++i2;
        }
    }

    @Override
    public void itemAdded(MListViewer viewer, Composite composite, Control item) {
    }

    @Override
    public void itemRemoved(MListViewer viewer, Composite composite, Control item) {
    }
}

