/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.util;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IProduct;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IPluginContribution;
import org.eclipse.ui.dialogs.PreferencesUtil;

public class PrefUtils {
    public static final String GENERAL_PREF_PAGE_ID = "org.xmind.ui.prefPage.General";
    private static final Set<String> HIDDEN_PAGE_IDS = new HashSet<String>(Arrays.asList("org.eclipse.equinox.security.ui.category", "org.eclipse.equinox.security.ui.storage"));

    public static void openPrefDialog(Shell shell, String prefPageId, Object data) {
        PreferenceDialog dialog = PreferencesUtil.createPreferenceDialogOn((Shell)shell, (String)prefPageId, null, (Object)data);
        if (dialog == null) {
            return;
        }
        IProduct product = Platform.getProduct();
        if (product != null && "org.xmind.cathy.application".equals(product.getApplication())) {
            PrefUtils.configTreeViewerFilter(dialog);
            dialog.getTreeViewer().setExpandPreCheckFilters(true);
            dialog.getTreeViewer().expandAll();
        }
        dialog.open();
    }

    private static void configTreeViewerFilter(PreferenceDialog dialog) {
        dialog.getTreeViewer().addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (element instanceof IPluginContribution) {
                    String id = ((IPluginContribution)element).getLocalId();
                    if (HIDDEN_PAGE_IDS.contains(id)) {
                        return false;
                    }
                }
                return true;
            }
        });
    }

    public static void openPrefDialog(Shell shell, String prefPageId) {
        PrefUtils.openPrefDialog(shell, prefPageId, null);
    }
}

