/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.gantt2.gefext;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.widgets.Display;
import org.xmind.gef.IDecorator;
import org.xmind.gef.IViewer;
import org.xmind.gef.Request;
import org.xmind.gef.draw2d.IUseTransparency;
import org.xmind.gef.part.EditPart;
import org.xmind.gef.part.IGraphicalEditPart;
import org.xmind.gef.part.IGraphicalPart;
import org.xmind.gef.part.IPart;
import org.xmind.ui.gantt2.gefext.IEditPart;
import org.xmind.ui.gantt2.gefext.IFeedback;
import org.xmind.ui.gantt2.gefext.IGraphicalViewer2;
import org.xmind.ui.gantt2.gefext.ITracker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GraphicalEditPart
extends EditPart
implements IGraphicalEditPart,
IEditPart {
    private IFigure figure = null;
    private List<Object> feedbackKeys = new ArrayList<Object>();
    private List<IFeedback> feedbacks = new ArrayList<IFeedback>();

    public IFigure getFigure() {
        if (this.figure == null) {
            this.figure = this.createFigure();
        }
        return this.figure;
    }

    public void setFigure(IFigure figure) {
        this.figure = figure;
    }

    public IFigure getContentPane() {
        return this.getFigure();
    }

    protected IFigure createFigure() {
        return new Figure();
    }

    protected void addChildView(IPart child, int index) {
        this.getContentPane().add(((IGraphicalPart)child).getFigure(), index);
    }

    protected void removeChildView(IPart child) {
        this.getContentPane().remove(((IGraphicalPart)child).getFigure());
    }

    public IDecorator getDecorator() {
        return null;
    }

    public Object getAdapter(Class adapter) {
        IFigure f;
        if (adapter == IFigure.class) {
            return this.getFigure();
        }
        if (adapter == IUseTransparency.class && (f = this.getFigure()) instanceof IUseTransparency) {
            return (IUseTransparency)f;
        }
        return super.getAdapter(adapter);
    }

    public IPart findAt(Point position) {
        return this.findAt(position, null);
    }

    public IPart findAt(Point position, IViewer.IPartSearchCondition condition) {
        IPart part = this.findChildAt(this.getChildren(), position, condition);
        if (part != null) {
            return part;
        }
        if (this.containsPoint(position) && (condition == null || condition.evaluate((IPart)this))) {
            return this;
        }
        return null;
    }

    protected IPart findChildAt(List<? extends IPart> children, Point position, IViewer.IPartSearchCondition condition) {
        int i = children.size() - 1;
        while (i >= 0) {
            IPart child = children.get(i);
            IPart part = this.findChildAt(child, position, condition);
            if (part != null) {
                return part;
            }
            --i;
        }
        return null;
    }

    protected IPart findChildAt(IPart child, Point position, IViewer.IPartSearchCondition condition) {
        if (child instanceof IGraphicalEditPart) {
            return ((IGraphicalEditPart)child).findAt(position, condition);
        }
        return null;
    }

    public IFigure findTooltipAt(Point position) {
        for (IFeedback feedback : this.feedbacks) {
            IFigure toolTip = feedback.findTooltip(position);
            if (toolTip == null) continue;
            return toolTip;
        }
        return this.getMainFigure().getToolTip();
    }

    public Cursor getCursor(Point pos) {
        for (IFeedback feedback : this.feedbacks) {
            Cursor cursor = feedback.findCursor(pos);
            if (cursor == null) continue;
            return cursor;
        }
        return this.getMainFigure().getCursor();
    }

    protected void updateToolTip() {
        Display.getCurrent().asyncExec(new Runnable(){

            public void run() {
                if (!GraphicalEditPart.this.getStatus().isActive()) {
                    return;
                }
                IViewer viewer = GraphicalEditPart.this.getSite().getViewer();
                if (viewer == null || viewer.getControl().isDisposed()) {
                    return;
                }
                viewer.updateToolTip();
            }
        });
    }

    public void installFeedback(Object key, IFeedback feedback) {
        if (feedback == null) {
            return;
        }
        this.uninstallFeedback(key);
        int index = this.feedbackKeys.indexOf(key);
        if (index < 0) {
            this.feedbackKeys.add(key);
            this.feedbacks.add(feedback);
        } else {
            this.feedbacks.set(index, feedback);
        }
        feedback.setHost(this);
        if (this.getStatus().isActive()) {
            feedback.activate();
        }
    }

    public void uninstallFeedback(Object key) {
        int index = this.feedbackKeys.indexOf(key);
        if (index < 0) {
            return;
        }
        IFeedback feedback = this.feedbacks.get(index);
        if (feedback == null) {
            return;
        }
        if (this.getStatus().isActive()) {
            feedback.deactivate();
        }
        feedback.setHost(null);
    }

    public IFeedback getFeedback(Object key) {
        if (key == null) {
            return null;
        }
        int index = this.feedbackKeys.indexOf(key);
        return index < 0 ? null : this.feedbacks.get(index);
    }

    protected void onActivated() {
        super.onActivated();
        for (IFeedback feedback : this.feedbacks) {
            feedback.activate();
        }
    }

    protected void onDeactivated() {
        for (IFeedback feedback : this.feedbacks) {
            feedback.deactivate();
        }
        super.onDeactivated();
    }

    @Override
    public ITracker findTracker(Point cursorLocation) {
        ITracker tracker;
        for (IFeedback feedback : this.feedbacks) {
            ITracker tracker2 = feedback.findTracker(cursorLocation);
            if (tracker2 == null) continue;
            return tracker2;
        }
        if (this.getParent() != null && this.getParent() instanceof IEditPart && (tracker = ((IEditPart)this.getParent()).findTracker(cursorLocation)) != null) {
            return tracker;
        }
        return null;
    }

    public boolean containsPoint(Point position) {
        IFigure mainFigure = this.getMainFigure();
        if (mainFigure != null && mainFigure.isShowing() && mainFigure.containsPoint(position)) {
            return true;
        }
        for (IFeedback feedback : this.feedbacks) {
            if (!feedback.containsPoint(position)) continue;
            return true;
        }
        return false;
    }

    protected IFigure getMainFigure() {
        return this.getFigure();
    }

    @Override
    public void update(Object property) {
        this.updateView(property);
        this.updateChildren(property);
        this.updateFeedbacks(property);
    }

    private void updateFeedbacks(Object property) {
        for (IFeedback feedback : this.feedbacks) {
            feedback.update(property);
        }
    }

    public void update() {
        this.update(null);
    }

    protected void updateView() {
        this.updateView(null);
    }

    protected void updateChildren() {
        this.updateChildren(null);
    }

    protected void updateView(Object property) {
    }

    protected void updateChildren(Object property) {
    }

    protected void registerFigure(IFigure figure) {
        IViewer viewer = this.getSite().getViewer();
        if (viewer instanceof IGraphicalViewer2) {
            ((IGraphicalViewer2)viewer).registerView((IGraphicalPart)this, figure);
        }
    }

    protected void unregisterFigure(IFigure figure) {
        IViewer viewer = this.getSite().getViewer();
        if (viewer instanceof IGraphicalViewer2) {
            ((IGraphicalViewer2)viewer).unregisterView((IGraphicalPart)this, figure);
        }
    }

    @Override
    public void showTargetFeedback(Request request) {
        for (IFeedback feedback : this.feedbacks) {
            feedback.showTargetFeedback(request);
        }
    }

    @Override
    public void hideTargetFeedback(Request request) {
        for (IFeedback feedback : this.feedbacks) {
            feedback.hideTargetFeedback(request);
        }
    }

    @Override
    public void showSourceFeedback(Request request) {
        for (IFeedback feedback : this.feedbacks) {
            feedback.showSourceFeedback(request);
        }
    }

    @Override
    public void hideSourceFeedback(Request request) {
        for (IFeedback feedback : this.feedbacks) {
            feedback.hideSourceFeedback(request);
        }
    }
}

