/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.cathy.internal;

import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.ComboFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.xmind.cathy.internal.CathyPlugin;
import org.xmind.cathy.internal.WorkbenchMessages;
import org.xmind.ui.internal.MindMapUIPlugin;
import org.xmind.ui.preference.PreferenceFieldEditorPageSection;

public class GeneralPreferencePageSection
extends PreferenceFieldEditorPageSection
implements IWorkbenchPreferencePage {
    private FieldEditor autoSaveInterval;
    private String[][] saveIntervals = new String[][]{{"5", "5"}, {"10", "10"}, {"30", "30"}, {"60", "60"}};
    private String[][] filesList = new String[][]{{"4", "4"}, {"5", "5"}, {"10", "10"}, {"20", "20"}, {"50", "50"}};
    private boolean autoBackup = true;
    private BooleanFieldEditor autoBackupField;
    private Composite autoSaveIntervalsParent;
    private Button startupActionButton;
    private Composite container;

    public void init(IWorkbench workbench) {
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return CathyPlugin.getDefault().getPreferenceStore();
    }

    protected void createFieldEditors() {
        this.addStartupGroup(this.container);
        new Label(this.container, 0);
        this.addRecentFileCountSection(this.container);
        this.addAutoSaveGroup(this.container);
        this.initialize();
    }

    private void addStartupGroup(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText(WorkbenchMessages.Startup_title);
        Composite container = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().applyTo(container);
        GridData data = new GridData();
        data.horizontalIndent = 25;
        data.minimumHeight = 0;
        container.setLayoutData((Object)data);
        this.startupActionButton = new Button(container, 32);
        this.startupActionButton.setText(WorkbenchMessages.RestoreLastSession_label);
        this.addField((FieldEditor)new BooleanFieldEditor("checkUpdatesOnStartup", WorkbenchMessages.CheckUpdates_label, container));
    }

    private void addRecentFileCountSection(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText(WorkbenchMessages.GeneralPrefPageSection_RecentFileCountSection_title);
        Composite composite = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().extendedMargins(0, 0, 0, 15).applyTo(composite);
        Composite container = new Composite(composite, 0);
        GridData data = new GridData();
        data.horizontalIndent = 25;
        container.setLayoutData((Object)data);
        GridLayoutFactory.fillDefaults().numColumns(1).applyTo(container);
        this.addField((FieldEditor)new ComboFieldEditor("RECENT_FILES", WorkbenchMessages.RecentFiles_label, this.filesList, container));
    }

    private void addAutoSaveGroup(Composite parent) {
        String message = WorkbenchMessages.AutoSave_label2;
        int index = message.indexOf("{0}");
        String label1 = message.substring(0, index);
        String label2 = message.substring(index + 3, index + 7);
        if (this.saveIntervals != null) {
            String[][] stringArray = this.saveIntervals;
            int n = this.saveIntervals.length;
            int n2 = 0;
            while (n2 < n) {
                String[] interval = stringArray[n2];
                interval[0] = String.valueOf(interval[0]) + " " + label2;
                ++n2;
            }
        }
        Label label = new Label(parent, 0);
        label.setText(WorkbenchMessages.GeneralPrefPageSection_AutoSaveGroup_title);
        Composite container = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().extendedMargins(23, 0, 0, 0).numColumns(1).applyTo(container);
        Composite saveParent = this.createContainer(container, 2);
        Composite enableParent = this.createContainer(saveParent, 1);
        this.addField((FieldEditor)new BooleanFieldEditor("autoSaveEnabled", label1, enableParent));
        this.autoSaveIntervalsParent = this.createContainer(saveParent, 1);
        this.autoSaveInterval = new ComboFieldEditor("autoSaveIntervals", "", this.saveIntervals, this.autoSaveIntervalsParent);
        this.addField(this.autoSaveInterval);
        this.autoSaveInterval.setEnabled(this.getPreferenceStore().getBoolean("autoSaveEnabled"), this.autoSaveIntervalsParent);
        Composite boolParent = this.createContainer(container, 1);
        this.autoBackupField = new BooleanFieldEditor("autoBackupEnable", WorkbenchMessages.AutoBackup_label, boolParent);
        this.autoBackupField.setPropertyChangeListener((IPropertyChangeListener)this);
    }

    private Composite createContainer(Composite parent, int cols) {
        Composite container = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(cols).applyTo(container);
        return container;
    }

    protected Control createContents(Composite parent) {
        if (this.container == null) {
            this.container = parent;
        }
        return super.createContents(parent);
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getSource() instanceof FieldEditor) {
            FieldEditor fe = (FieldEditor)event.getSource();
            if (event.getProperty().equals("field_editor_value")) {
                String prefName = fe.getPreferenceName();
                if ("autoSaveEnabled".equals(prefName)) {
                    this.autoSaveInterval.setEnabled(((Boolean)event.getNewValue()).booleanValue(), this.autoSaveIntervalsParent);
                } else if ("autoBackupEnable".equals(prefName)) {
                    this.autoBackup = (Boolean)event.getNewValue();
                }
            }
        }
    }

    public boolean performOk() {
        if (!super.performOk()) {
            return false;
        }
        if (this.startupActionButton.getSelection()) {
            this.getPreferenceStore().setValue("startupAction2", 3);
        } else {
            this.getPreferenceStore().setValue("startupAction2", 0);
        }
        MindMapUIPlugin.getDefault().getPreferenceStore().setValue("autoBackupEnable", this.autoBackup);
        return true;
    }

    protected void initialize() {
        super.initialize();
        int startupAction = this.getPreferenceStore().getInt("startupAction2");
        this.startupActionButton.setSelection(startupAction == 3);
        this.autoBackupField.setPreferenceStore(MindMapUIPlugin.getDefault().getPreferenceStore());
        this.autoBackupField.load();
    }

    public void apply() {
        this.performApply();
    }

    public boolean ok() {
        return this.performOk();
    }

    public void excuteDefault() {
        this.performDefaults();
    }

    public boolean cancel() {
        return this.performCancel();
    }
}

