/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.gef.service;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.FreeformFigure;
import org.eclipse.draw2d.Layer;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.xmind.gef.GEF;
import org.xmind.gef.IGraphicalViewer;
import org.xmind.gef.service.GraphicalViewerService;

public class CenterPreservationService
extends GraphicalViewerService
implements Listener,
PropertyChangeListener {
    protected static final org.eclipse.draw2d.geometry.Rectangle TEMP_AREA = new org.eclipse.draw2d.geometry.Rectangle();
    private boolean centerOnContents;
    private Display display = null;
    protected Viewport viewport = null;
    protected Point centerPoint = new Point();
    private boolean mousePressing = false;
    private boolean keyPressing = false;
    private boolean resizedDuringMousePress = false;
    private boolean resizedDuringKeyPress = false;

    public CenterPreservationService(IGraphicalViewer viewer) {
        this(viewer, false);
    }

    public CenterPreservationService(IGraphicalViewer viewer, boolean centerOnContents) {
        super(viewer);
        this.centerOnContents = centerOnContents;
    }

    protected void hookControl(Control control) {
        super.hookControl(control);
        FigureCanvas canvas = (FigureCanvas)control;
        if (canvas != null && !canvas.isDisposed()) {
            canvas.addListener(11, (Listener)this);
            canvas.addListener(15, (Listener)this);
            canvas.addListener(16, (Listener)this);
            canvas.addListener(9, (Listener)this);
            this.viewport = canvas.getViewport();
            if (this.viewport != null) {
                this.viewport.addPropertyChangeListener("viewLocation", (PropertyChangeListener)this);
            }
            this.display = canvas.getDisplay();
            if (this.display != null) {
                this.display.addFilter(3, (Listener)this);
                this.display.addFilter(4, (Listener)this);
                this.display.addFilter(1, (Listener)this);
                this.display.addFilter(2, (Listener)this);
            }
        }
        this.mousePressing = false;
        this.keyPressing = false;
        this.resizedDuringMousePress = false;
        this.resizedDuringKeyPress = false;
        this.updateCenterPoint();
    }

    protected void unhookControl(Control control) {
        FigureCanvas canvas = (FigureCanvas)control;
        if (canvas != null && !canvas.isDisposed()) {
            canvas.removeListener(11, (Listener)this);
            canvas.removeListener(15, (Listener)this);
            canvas.removeListener(9, (Listener)this);
        }
        if (this.viewport != null) {
            this.viewport.removePropertyChangeListener("viewLocation", (PropertyChangeListener)this);
        }
        if (this.display != null && !this.display.isDisposed()) {
            this.display.removeFilter(3, (Listener)this);
            this.display.removeFilter(4, (Listener)this);
            this.display.removeFilter(1, (Listener)this);
            this.display.removeFilter(2, (Listener)this);
        }
        this.mousePressing = false;
        this.keyPressing = false;
        this.resizedDuringMousePress = false;
        this.resizedDuringKeyPress = false;
        super.unhookControl(control);
    }

    protected void activate() {
    }

    protected void deactivate() {
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (!this.isActive()) {
            return;
        }
        if (this.mousePressing && this.resizedDuringMousePress || this.keyPressing && this.resizedDuringKeyPress) {
            return;
        }
        this.updateCenterPoint();
    }

    private void updateCenterPoint() {
        if (!this.isActive() || this.viewport == null) {
            return;
        }
        if (this.centerOnContents) {
            Layer layer = this.getViewer().getLayer(GEF.LAYER_CONTENTS);
            org.eclipse.draw2d.geometry.Rectangle bounds = layer instanceof FreeformFigure ? ((FreeformFigure)layer).getFreeformExtent() : layer.getBounds();
            this.centerPoint.setLocation(bounds.x + bounds.width / 2, bounds.y + bounds.height / 2);
        } else {
            org.eclipse.draw2d.geometry.Rectangle r = this.viewport.getClientArea(TEMP_AREA);
            this.centerPoint.setLocation(r.x + r.width / 2, r.y + r.height / 2);
        }
    }

    private void centerViewportOnResize() {
        if (!this.isActive() || this.viewport == null) {
            return;
        }
        org.eclipse.draw2d.geometry.Rectangle r = this.viewport.getClientArea(TEMP_AREA);
        this.viewport.setViewLocation(this.centerPoint.x - r.width / 2, this.centerPoint.y - r.height / 2);
    }

    public void handleEvent(Event event) {
        if (!this.isActive()) {
            return;
        }
        if (event.type == 11) {
            if (this.needsCenterWhenResizing()) {
                this.centerViewportOnResize();
            }
        } else if (event.type == 15 || event.type == 9) {
            FigureCanvas fc = (FigureCanvas)event.widget;
            Rectangle clientArea = fc.getClientArea();
            if (clientArea.width > 0 || clientArea.height > 0) {
                this.centerViewportOnResize();
                fc.removeListener(event.type, (Listener)this);
            }
        } else if (event.type == 3) {
            this.mousePressing = true;
        } else if (event.type == 1) {
            this.keyPressing = true;
        } else if (event.type == 4) {
            this.mousePressing = false;
            if (this.resizedDuringMousePress) {
                this.resizedDuringMousePress = false;
                this.centerViewportOnResize();
            }
        } else if (event.type == 2) {
            this.keyPressing = false;
            if (this.resizedDuringKeyPress) {
                this.resizedDuringKeyPress = false;
                this.centerViewportOnResize();
            }
        }
    }

    private boolean needsCenterWhenResizing() {
        if (!this.mousePressing && !this.keyPressing) {
            return true;
        }
        if (this.mousePressing) {
            this.resizedDuringMousePress = true;
        }
        if (this.keyPressing) {
            this.resizedDuringKeyPress = true;
        }
        return false;
    }
}

