/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.gef.draw2d.geometry;

import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.xmind.gef.draw2d.geometry.AbstractPositionSolver;
import org.xmind.gef.draw2d.geometry.Geometry;
import org.xmind.gef.draw2d.geometry.ITransformer;
import org.xmind.gef.draw2d.geometry.Transposer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AlignmentSolver
extends AbstractPositionSolver
implements Comparator<Object> {
    private int alignmentHint;
    private ITransformer t;

    public AlignmentSolver(int alignmentHint) {
        this.alignmentHint = alignmentHint;
        this.t = new Transposer();
        this.t.setEnabled(!this.isHorizontal());
    }

    public int getAlignmentHint() {
        return this.alignmentHint;
    }

    public void setAlignmentHint(int alignmentHint) {
        this.alignmentHint = alignmentHint;
        boolean horizontal = this.isHorizontal();
        this.t.setEnabled(!horizontal);
    }

    protected boolean isHorizontal() {
        return (this.getAlignmentHint() & 7) != 0;
    }

    @Override
    public void setOrigin(int x, int y) {
        this.t.setOrigin(x, y);
        super.setOrigin(x, y);
    }

    @Override
    public void setOrigin(Point origin) {
        this.t.setOrigin(origin);
        super.setOrigin(origin);
    }

    @Override
    public void solve() {
        Object[] keys;
        Rectangle refBounds = this.getReferenceBounds();
        if (refBounds == null) {
            return;
        }
        this.setOrigin(refBounds.x + refBounds.width / 2, refBounds.y + refBounds.height / 2);
        this.t.t(refBounds);
        int refLine = this.getReferenceLine(refBounds);
        Object[] objectArray = keys = this.sort(this.getFreeKeys().toArray());
        int n = keys.length;
        int n2 = 0;
        while (n2 < n) {
            Object key = objectArray[n2];
            Point pos = this.getSolvedPosition(key);
            Rectangle bounds = this.getSolvedBounds(key);
            this.t.t(pos);
            pos.x += refLine - this.getReferenceLine(this.t.tr(bounds));
            this.t.r(pos);
            ++n2;
        }
    }

    protected Collection<Object> getFreeKeys() {
        return this.getKeys("free");
    }

    private Object[] sort(Object[] keys) {
        Arrays.sort(keys, this);
        return keys;
    }

    protected Collection<Object> getReferenceKeys() {
        return this.getKeys();
    }

    protected Rectangle getReferenceBounds() {
        Rectangle r = null;
        for (Object key : this.getReferenceKeys()) {
            r = Geometry.union(r, this.getSolvedBounds(key));
        }
        return r;
    }

    private int getReferenceLine(Rectangle bounds) {
        if (this.isLead()) {
            return bounds.x;
        }
        if (this.isTrail()) {
            return bounds.x + bounds.width;
        }
        return bounds.x + bounds.width / 2;
    }

    private boolean isLead() {
        return (this.getAlignmentHint() & 1) != 0 || (this.getAlignmentHint() & 8) != 0;
    }

    private boolean isTrail() {
        return (this.getAlignmentHint() & 4) != 0 || (this.getAlignmentHint() & 0x20) != 0;
    }

    @Override
    public int compare(Object o1, Object o2) {
        Rectangle r1 = this.t.tr(this.getSolvedBounds(o1));
        Rectangle r2 = this.t.tr(this.getSolvedBounds(o2));
        int c1 = r1.y + r1.height / 2;
        int c2 = r2.y + r2.height / 2;
        if (c1 == c2) {
            return 1;
        }
        return c1 - c2;
    }
}

