/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.net.http;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import org.xmind.core.net.Field;
import org.xmind.core.net.FieldSet;
import org.xmind.core.net.http.HttpEntity;
import org.xmind.core.net.internal.EncodingUtils;

public class FormEntity
extends HttpEntity {
    private static final String FORM_CONTENT_TYPE = "application/x-www-form-urlencoded; charset=utf-8";
    private FieldSet parameters;
    private byte[] formData = null;

    public FormEntity(FieldSet parameters) {
        this.parameters = parameters;
    }

    public FieldSet getParameters() {
        return this.parameters;
    }

    private byte[] getFormData() {
        if (this.formData != null) {
            return this.formData;
        }
        this.formData = EncodingUtils.toAsciiBytes(FormEntity.toQueryString(this.parameters.toList()));
        return this.formData;
    }

    @Override
    public String getContentType() {
        return FORM_CONTENT_TYPE;
    }

    @Override
    public long getContentLength() {
        return this.getFormData().length;
    }

    @Override
    public void writeTo(OutputStream stream) throws IOException {
        stream.write(this.getFormData());
    }

    private static String toQueryString(Collection<Field> parameters) {
        StringBuffer buffer = new StringBuffer(parameters.size() * 15);
        for (Field param : parameters) {
            if (buffer.length() > 0) {
                buffer.append('&');
            }
            buffer.append(param.getEncodedName());
            buffer.append('=');
            buffer.append(param.getEncodedValue());
        }
        return buffer.toString();
    }

    public String toString() {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        try {
            try {
                this.writeTo(bytes);
            }
            catch (IOException e) {
                throw new AssertionError("Failed to dump form data using byte array stream", e);
            }
        }
        catch (Throwable throwable) {
            try {
                bytes.close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            bytes.close();
        }
        catch (IOException iOException) {}
        try {
            return bytes.toString("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw EncodingUtils.wrapEncodingException(e, "UTF-8");
        }
    }
}

