/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.tools;

import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Layer;
import org.eclipse.draw2d.UpdateManager;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.xmind.gef.GEF;
import org.xmind.gef.IViewer;
import org.xmind.gef.Request;
import org.xmind.gef.draw2d.DecoratedShapeFigure;
import org.xmind.gef.draw2d.IReferencedFigure;
import org.xmind.gef.draw2d.decoration.IShapeDecorationEx;
import org.xmind.gef.draw2d.decoration.PathShapeDecoration;
import org.xmind.gef.draw2d.graphics.Path;
import org.xmind.gef.event.DragDropEvent;
import org.xmind.gef.event.KeyEvent;
import org.xmind.gef.event.MouseEvent;
import org.xmind.gef.graphicalpolicy.IStructure;
import org.xmind.gef.part.IPart;
import org.xmind.gef.tool.GraphicalTool;
import org.xmind.ui.branch.IInsertableBranchStructureExtension;
import org.xmind.ui.branch.ILockableBranchStructureExtension;
import org.xmind.ui.branch.IMovableBranchStructureExtension;
import org.xmind.ui.internal.tools.BranchDummy;
import org.xmind.ui.internal.tools.TopicMoveToolHelper;
import org.xmind.ui.mindmap.IBranchPart;
import org.xmind.ui.mindmap.ISheetPart;
import org.xmind.ui.mindmap.ITopicPart;
import org.xmind.ui.tools.ITopicMoveToolHelper;
import org.xmind.ui.tools.ParentSearchKey;
import org.xmind.ui.tools.ParentSearcher;

public class MindMapDndTool
extends GraphicalTool {
    private static ITopicMoveToolHelper defaultHelper = null;
    private BranchDummy dummy = null;
    private IFigure invent = null;
    private IBranchPart targetParent = null;
    private ParentSearcher parentSearcher = null;
    private ParentSearchKey key = null;
    private boolean insideTopicAllowed = false;
    private ITopicMoveToolHelper helper = null;
    private Request request = null;
    private boolean mouseDown = false;

    protected boolean acceptEvent(DragDropEvent de) {
        return true;
    }

    protected boolean handleDragStarted(DragDropEvent de) {
        this.targetParent = null;
        this.request = null;
        this.insideTopicAllowed = this.isInsideTopicAllowed(de);
        if (this.acceptEvent(de)) {
            this.createDummy(de);
            this.lockBranchStructures((IPart)this.getTargetViewer().getRootPart());
            return true;
        }
        return false;
    }

    private void lockBranchStructures(IPart part) {
        IBranchPart branch;
        IStructure sa;
        if (part instanceof IBranchPart && (sa = (branch = (IBranchPart)part).getBranchPolicy().getStructure(branch)) instanceof ILockableBranchStructureExtension) {
            ((ILockableBranchStructureExtension)sa).lock(branch);
        }
        for (IPart child : part.getChildren()) {
            this.lockBranchStructures(child);
        }
    }

    private void unlockBranchStructures(IPart part) {
        IBranchPart branch;
        IStructure sa;
        if (part instanceof IBranchPart && (sa = (branch = (IBranchPart)part).getBranchPolicy().getStructure(branch)) instanceof ILockableBranchStructureExtension) {
            ((ILockableBranchStructureExtension)sa).unlock(branch);
        }
        for (IPart child : part.getChildren()) {
            this.unlockBranchStructures(child);
        }
    }

    private void createDummy(DragDropEvent de) {
        if (this.dummy != null) {
            this.dummy.dispose();
            this.dummy = null;
        }
        this.dummy = new BranchDummy(this.getTargetViewer(), false);
        this.decorateDummy(this.dummy, de);
    }

    protected void decorateDummy(BranchDummy dummy, DragDropEvent de) {
        dummy.setStyle("shape-class", "org.xmind.topicShape.noBorder");
        dummy.getTopic().setTitleText("");
        dummy.getBranch().refresh();
    }

    public IFigure getInvent() {
        return this.invent;
    }

    private void doCreateInvent() {
        if (this.invent != null) {
            return;
        }
        this.invent = this.createInvent();
    }

    private IFigure createInvent() {
        DecoratedShapeFigure figure = new DecoratedShapeFigure();
        figure.setSize(60, 15);
        figure.setDecoration((IShapeDecorationEx)new RoundedRectDecoration());
        Layer layer = this.getTargetViewer().getLayer(GEF.LAYER_PRESENTATION);
        if (layer != null) {
            layer.add((IFigure)figure);
        }
        return figure;
    }

    private void destroyInvent() {
        if (this.invent != null) {
            if (this.invent.getParent() != null) {
                this.invent.getParent().remove(this.invent);
            }
            this.invent = null;
        }
    }

    protected boolean isInsideTopicAllowed(DragDropEvent de) {
        return true;
    }

    protected boolean handleDragOver(DragDropEvent de) {
        if (this.acceptEvent(de) && this.dummy != null) {
            this.key = new ParentSearchKey(null, (IReferencedFigure)this.dummy.getBranch().getTopicPart().getFigure(), this.getCursorPosition());
            this.key.setFeedback(this.dummy.getBranch());
            this.targetParent = this.updateTargetParent();
            if (this.invent == null) {
                this.doCreateInvent();
            }
            this.key.setInvent(this.invent);
            this.updateWithParent(this.targetParent);
            return true;
        }
        return false;
    }

    private IBranchPart updateTargetParent() {
        return this.getParentSearcher().searchTargetParent((IPart)this.getTargetViewer().getRootPart(), this.key);
    }

    private void updateWithParent(IBranchPart parent) {
        this.updateDummyWithParent(parent);
        this.updateHelperWithParent(parent);
    }

    private void updateDummyWithParent(IBranchPart parent) {
        this.updateDummyPosition(this.getCursorPosition());
        this.updateInventPosition(this.getCursorPosition());
        this.updateInventVisible(parent);
    }

    private void updateInventVisible(IBranchPart parent) {
        if (this.invent != null) {
            this.invent.setVisible(parent != null && !parent.getTopicPart().getFigure().containsPoint(this.getCursorPosition()));
        }
    }

    private void updateInventPosition(Point cursorPosition) {
        IFigure fig = this.getInvent();
        Point pos = new Point();
        if (fig != null) {
            if (this.targetParent != null && this.key != null) {
                pos = this.calcInsertionPosition(this.targetParent, this.key);
            }
            if (fig instanceof IReferencedFigure) {
                ((IReferencedFigure)fig).setReference(pos);
            } else {
                fig.setLocation(pos);
            }
        }
    }

    private Point calcInsertionPosition(IBranchPart parent, ParentSearchKey key) {
        IStructure structure;
        UpdateManager um = key.getFigure().getUpdateManager();
        if (um != null) {
            um.performValidation();
        }
        if (parent != null && (structure = parent.getBranchPolicy().getStructure(parent)) instanceof IInsertableBranchStructureExtension) {
            return ((IInsertableBranchStructureExtension)structure).calcInsertionPosition(parent, null, key);
        }
        return new Point();
    }

    protected void updateDummyPosition(Point pos) {
        IFigure fig = this.dummy.getBranch().getFigure();
        if (fig != null) {
            if (fig instanceof IReferencedFigure) {
                ((IReferencedFigure)fig).setReference(pos);
            } else {
                fig.setLocation(pos);
            }
        }
    }

    private void updateHelperWithParent(IBranchPart parent) {
        ITopicMoveToolHelper oldHelper = this.helper;
        ITopicMoveToolHelper newHelper = this.getHelper(parent);
        if (newHelper != oldHelper) {
            if (oldHelper != null) {
                oldHelper.deactivate(this.getDomain(), (IViewer)this.getTargetViewer());
            }
            if (newHelper != null) {
                newHelper.activate(this.getDomain(), (IViewer)this.getTargetViewer());
            }
            this.helper = newHelper;
        }
        if (this.helper != null) {
            this.helper.update(parent, this.key);
        }
    }

    private ITopicMoveToolHelper getHelper(IBranchPart parent) {
        return MindMapDndTool.getDefaultHelper();
    }

    protected static ITopicMoveToolHelper getDefaultHelper() {
        if (defaultHelper == null) {
            defaultHelper = new TopicMoveToolHelper();
        }
        return defaultHelper;
    }

    protected ParentSearcher getParentSearcher() {
        if (this.parentSearcher == null) {
            this.parentSearcher = new ParentSearcher(this.insideTopicAllowed);
        }
        return this.parentSearcher;
    }

    protected boolean handleDragDismissed(DragDropEvent de) {
        if (this.acceptEvent(de)) {
            this.request = this.createRequest(de);
            this.destroyDummy();
            this.destroyInvent();
            this.changeActiveTool("default tool");
            return true;
        }
        return false;
    }

    private IPart findDropTarget(IPart target) {
        if (target == null) {
            return null;
        }
        if (target.hasRole("drop target role")) {
            return target;
        }
        return this.findDropTarget(target.getParent());
    }

    private Request createRequest(DragDropEvent de) {
        IStructure structure;
        ITopicPart targetTopic;
        Request req = new Request("drop");
        Object target = this.findDropTarget(de.target);
        if (target == null) {
            target = (ISheetPart)this.getTargetViewer().getAdapter(ISheetPart.class);
        }
        req.setPrimaryTarget(target);
        ITopicPart iTopicPart = targetTopic = this.targetParent == null ? null : this.targetParent.getTopicPart();
        if (targetTopic != null) {
            req.setParameter("parent", (Object)targetTopic);
            int targetIndex = -1;
            if (this.targetParent != null) {
                targetIndex = this.getParentSearcher().getIndex(this.targetParent, this.key);
            }
            req.setParameter("index", (Object)targetIndex);
            req.setParameter("positionAbsolute", (Object)this.getCursorPosition());
        }
        if (this.targetParent == null) {
            Point position = this.getCursorPosition();
            req.setParameter("position", (Object)position);
        }
        req.setParameter("dropOperation", (Object)de.detail);
        if (this.targetParent != null && (structure = this.targetParent.getBranchPolicy().getStructure(this.targetParent)) instanceof IMovableBranchStructureExtension) {
            ((IMovableBranchStructureExtension)structure).decorateMoveInRequest(this.targetParent, this.key, null, req);
        }
        return req;
    }

    private void destroyDummy() {
        this.unlockBranchStructures((IPart)this.getTargetViewer().getRootPart());
        ITopicMoveToolHelper oldHelper = this.helper;
        BranchDummy oldDummy = this.dummy;
        if (oldHelper != null) {
            oldHelper.deactivate(this.getDomain(), (IViewer)this.getTargetViewer());
        }
        if (oldDummy != null) {
            oldDummy.dispose();
        }
        this.helper = null;
        this.dummy = null;
    }

    protected boolean handleDrop(DragDropEvent de) {
        try {
            Request req;
            if (this.acceptEvent(de) && (req = this.request) != null) {
                req.setParameter("dndData", (Object)de.dndData);
                Display.getCurrent().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                            public void run() throws Exception {
                                BusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)new Runnable(){

                                    @Override
                                    public void run() {
                                        MindMapDndTool.this.getDomain().handleRequest(req);
                                    }
                                });
                            }
                        });
                    }
                });
                return true;
            }
            return false;
        }
        finally {
            this.request = null;
        }
    }

    protected boolean handleKeyTraversed(KeyEvent ke) {
        if (ke.traverse == 2) {
            this.destroyDummy();
            this.destroyInvent();
            this.changeActiveTool("default tool");
            ke.consume();
            return true;
        }
        return super.handleKeyTraversed(ke);
    }

    protected boolean handleMouseDown(MouseEvent me) {
        this.mouseDown = true;
        return super.handleMouseDown(me);
    }

    protected boolean handleMouseUp(MouseEvent me) {
        if (this.mouseDown) {
            this.mouseDown = false;
            this.destroyDummy();
            this.destroyInvent();
            this.changeActiveTool("default tool");
            return true;
        }
        return super.handleMouseUp(me);
    }

    private class RoundedRectDecoration
    extends PathShapeDecoration {
        private RoundedRectDecoration() {
        }

        public Insets getPreferredInsets(IFigure figure, int width, int height) {
            int lineWidth = this.getLineWidth();
            return new Insets(lineWidth, lineWidth, lineWidth, lineWidth);
        }

        protected void sketch(IFigure figure, Path shape, Rectangle box, int purpose) {
            shape.addRoundedRectangle(box, 5.0f);
        }
    }
}

