/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.outline.resource;

import org.xmind.core.ISheet;
import org.xmind.ui.internal.outline.resource.AZResourceForSheet;
import org.xmind.ui.internal.outline.resource.AZResourceForWorkbook;
import org.xmind.ui.internal.outline.resource.AssigneeResourceForSheet;
import org.xmind.ui.internal.outline.resource.AssigneeResourceForWorkbook;
import org.xmind.ui.internal.outline.resource.IAZResource;
import org.xmind.ui.internal.outline.resource.IOutlineResource;
import org.xmind.ui.internal.outline.resource.ITaskDateResource;
import org.xmind.ui.internal.outline.resource.LabelResourceForSheet;
import org.xmind.ui.internal.outline.resource.LabelResourceForWorkbook;
import org.xmind.ui.internal.outline.resource.MarkerResourceForSheet;
import org.xmind.ui.internal.outline.resource.MarkerResourceForWorkbook;
import org.xmind.ui.internal.outline.resource.TaskDateResourceForSheet;
import org.xmind.ui.internal.outline.resource.TaskDateResourceForWorkbook;
import org.xmind.ui.mindmap.IWorkbookRef;

public class OutlineResources {
    private IOutlineResource markerResourceForWorkbook;
    private IOutlineResource markerResourceForSheet;
    private IOutlineResource labelResourceForWorkbook;
    private IOutlineResource labelResourceForSheet;
    private IOutlineResource assigneeResourceForWorkbook;
    private IOutlineResource assigneeResourceForSheet;
    private ITaskDateResource taskDateResourceForWorkbook;
    private ITaskDateResource taskDateResourceForSheet;
    private IAZResource azResourceForWorkbook;
    private IAZResource azResourceForSheet;

    public Object getResourceForSheet(ISheet sheet, int indexType, boolean forceUpdate) {
        Object resource = null;
        if (sheet != null) {
            switch (indexType) {
                case 0: {
                    resource = sheet;
                    break;
                }
                case 1: {
                    resource = this.getMarkerResourceForSheet(sheet, forceUpdate);
                    break;
                }
                case 2: {
                    resource = this.getLabelResourceForSheet(sheet, forceUpdate);
                    break;
                }
                case 5: {
                    resource = this.getAssigneeResourceForSheet(sheet, forceUpdate);
                    break;
                }
                case 3: {
                    resource = this.getTaskDateResourceForSheet(sheet, indexType, forceUpdate);
                    break;
                }
                case 4: {
                    resource = this.getTaskDateResourceForSheet(sheet, indexType, forceUpdate);
                    break;
                }
                case 6: {
                    resource = this.getAZResourceForSheet(sheet, true, forceUpdate);
                    break;
                }
                case 7: {
                    resource = this.getAZResourceForSheet(sheet, false, forceUpdate);
                }
            }
        }
        return resource;
    }

    public Object getResourceForWorkbook(IWorkbookRef workbookRef, int indexType, boolean forceUpdate) {
        Object resource = null;
        if (workbookRef != null) {
            switch (indexType) {
                case 0: {
                    resource = workbookRef;
                    break;
                }
                case 1: {
                    resource = this.getMarkerResourceForWorkbook(workbookRef, forceUpdate);
                    break;
                }
                case 2: {
                    resource = this.getLabelResourceForWorkbook(workbookRef, forceUpdate);
                    break;
                }
                case 5: {
                    resource = this.getAssigneeResourceForWorkbook(workbookRef, forceUpdate);
                    break;
                }
                case 3: {
                    resource = this.getTaskDateResourceForWorkbook(workbookRef, indexType, forceUpdate);
                    break;
                }
                case 4: {
                    resource = this.getTaskDateResourceForWorkbook(workbookRef, indexType, forceUpdate);
                    break;
                }
                case 6: {
                    resource = this.getAZResourceForWorkbook(workbookRef, true, forceUpdate);
                    break;
                }
                case 7: {
                    resource = this.getAZResourceForWorkbook(workbookRef, false, forceUpdate);
                }
            }
        }
        return resource;
    }

    private IOutlineResource getMarkerResourceForWorkbook(IWorkbookRef workbookRef, boolean forceUpdate) {
        if (this.markerResourceForWorkbook != null && forceUpdate) {
            this.markerResourceForWorkbook.reset(workbookRef, true);
        }
        if (this.markerResourceForWorkbook == null) {
            this.markerResourceForWorkbook = new MarkerResourceForWorkbook(workbookRef);
        }
        return this.markerResourceForWorkbook;
    }

    private IOutlineResource getMarkerResourceForSheet(ISheet sheet, boolean forceUpdate) {
        if (this.markerResourceForSheet != null && forceUpdate) {
            this.markerResourceForSheet.reset(sheet, true);
        }
        if (this.markerResourceForSheet == null) {
            this.markerResourceForSheet = new MarkerResourceForSheet(sheet);
        }
        return this.markerResourceForSheet;
    }

    private IOutlineResource getLabelResourceForSheet(ISheet sheet, boolean forceUpdate) {
        if (this.labelResourceForSheet != null && forceUpdate) {
            this.labelResourceForSheet.reset(sheet, true);
        }
        if (this.labelResourceForSheet == null) {
            this.labelResourceForSheet = new LabelResourceForSheet(sheet);
        }
        return this.labelResourceForSheet;
    }

    private IOutlineResource getLabelResourceForWorkbook(IWorkbookRef workbookRef, boolean forceUpdate) {
        if (this.labelResourceForWorkbook != null && forceUpdate) {
            this.labelResourceForWorkbook.reset(workbookRef, true);
        }
        if (this.labelResourceForWorkbook == null) {
            this.labelResourceForWorkbook = new LabelResourceForWorkbook(workbookRef);
        }
        return this.labelResourceForWorkbook;
    }

    private IOutlineResource getAssigneeResourceForSheet(ISheet sheet, boolean forceUpdate) {
        if (this.assigneeResourceForSheet != null && forceUpdate) {
            this.assigneeResourceForSheet.reset(sheet, true);
        }
        if (this.assigneeResourceForSheet == null) {
            this.assigneeResourceForSheet = new AssigneeResourceForSheet(sheet);
        }
        return this.assigneeResourceForSheet;
    }

    private IOutlineResource getAssigneeResourceForWorkbook(IWorkbookRef workbookRef, boolean forceUpdate) {
        if (this.assigneeResourceForWorkbook != null && forceUpdate) {
            this.assigneeResourceForWorkbook.reset(workbookRef, true);
        }
        if (this.assigneeResourceForWorkbook == null) {
            this.assigneeResourceForWorkbook = new AssigneeResourceForWorkbook(workbookRef);
        }
        return this.assigneeResourceForWorkbook;
    }

    private IOutlineResource getTaskDateResourceForSheet(ISheet sheet, int taskDateType, boolean forceUpdate) {
        if (this.taskDateResourceForSheet != null && forceUpdate) {
            this.taskDateResourceForSheet.reset(sheet, forceUpdate);
        }
        if (this.taskDateResourceForSheet == null) {
            this.taskDateResourceForSheet = new TaskDateResourceForSheet(sheet, taskDateType);
        }
        this.taskDateResourceForSheet.setTaskDateResourceType(taskDateType);
        return this.taskDateResourceForSheet;
    }

    private IOutlineResource getTaskDateResourceForWorkbook(IWorkbookRef workbookRef, int taskDateType, boolean forceUpdate) {
        if (this.taskDateResourceForWorkbook != null && forceUpdate) {
            this.taskDateResourceForWorkbook.reset(workbookRef, forceUpdate);
        }
        if (this.taskDateResourceForWorkbook == null) {
            this.taskDateResourceForWorkbook = new TaskDateResourceForWorkbook(workbookRef, taskDateType);
        }
        this.taskDateResourceForWorkbook.setTaskDateResourceType(taskDateType);
        return this.taskDateResourceForWorkbook;
    }

    private IOutlineResource getAZResourceForSheet(ISheet sheet, boolean isPositiveSequence, boolean forceUpdate) {
        if (this.azResourceForSheet != null && forceUpdate) {
            this.azResourceForSheet.reset(sheet, true);
        }
        if (this.azResourceForSheet == null) {
            this.azResourceForSheet = new AZResourceForSheet(sheet);
        }
        this.azResourceForSheet.setSequence(isPositiveSequence);
        return this.azResourceForSheet;
    }

    private IOutlineResource getAZResourceForWorkbook(IWorkbookRef workbookRef, boolean isPositiveSequence, boolean forceUpdate) {
        if (this.azResourceForWorkbook != null && forceUpdate) {
            this.azResourceForWorkbook.reset(workbookRef, true);
        }
        if (this.azResourceForWorkbook == null) {
            this.azResourceForWorkbook = new AZResourceForWorkbook(workbookRef);
        }
        this.azResourceForWorkbook.setSequence(isPositiveSequence);
        return this.azResourceForWorkbook;
    }
}

