/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.outline.resource;

import java.util.List;
import org.xmind.core.ISheet;
import org.xmind.core.ITopic;
import org.xmind.ui.internal.outline.resource.IOutlineResource;
import org.xmind.ui.mindmap.IWorkbookRef;

public abstract class AbstractIndexResource
implements IOutlineResource {
    protected void collectResourceForWorkbook(IWorkbookRef workbookRef) {
        if (workbookRef == null) {
            return;
        }
        List sheets = workbookRef.getWorkbook().getSheets();
        for (ISheet sheet : sheets) {
            this.collectResourceForSheet(sheet);
        }
    }

    protected void collectResourceForSheet(ISheet sheet) {
        ITopic rootTopic = sheet.getRootTopic();
        this.collectResourceForTopic(rootTopic);
        this.collectResourceForParentTopic(rootTopic);
    }

    protected void collectResourceForParentTopic(ITopic parentTopic) {
        for (ITopic child : parentTopic.getAllChildren()) {
            this.collectResourceForTopic(child);
            this.collectResourceForParentTopic(child);
        }
    }

    protected abstract void collectResourceForTopic(ITopic var1);
}

