/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.layers;

import org.eclipse.draw2d.FreeformLayer;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.xmind.gef.draw2d.ITransparentableFigure;
import org.xmind.gef.draw2d.graphics.AlphaGraphics;
import org.xmind.gef.draw2d.graphics.GraphicsUtils;

public class BaseLayer
extends FreeformLayer
implements ITransparentableFigure {
    private int alpha = 255;
    private int subAlpha = 255;

    public int getMainAlpha() {
        return this.alpha;
    }

    public int getSubAlpha() {
        return this.subAlpha;
    }

    public void setMainAlpha(int alpha) {
        if (alpha == this.alpha) {
            return;
        }
        this.alpha = alpha;
        this.repaint();
    }

    public void setSubAlpha(int alpha) {
        if (alpha == this.subAlpha) {
            return;
        }
        this.subAlpha = alpha;
        this.repaint();
    }

    public void paint(Graphics graphics) {
        GraphicsUtils.fixGradientBugForCarbon((Graphics)graphics, (IFigure)this);
        if (this.usesMainAlphaGraphics()) {
            Graphics ag = this.createAlphaGraphics(graphics, this.getMainAlpha());
            this.simplePaint(ag);
            ag.dispose();
        } else {
            graphics.setAlpha(this.getMainAlpha());
            this.simplePaint(graphics);
        }
    }

    protected boolean usesMainAlphaGraphics() {
        return this.getMainAlpha() >= 0 && this.getMainAlpha() < 255;
    }

    protected void simplePaint(Graphics graphics) {
        super.paint(graphics);
    }

    protected void paintClientArea(Graphics graphics) {
        if (this.usesSubAlphaGraphics()) {
            Graphics ag = this.createAlphaGraphics(graphics, this.getSubAlpha());
            this.simplePaintClientArea(ag);
            ag.dispose();
        } else {
            graphics.setAlpha(this.getSubAlpha());
            this.simplePaintClientArea(graphics);
        }
    }

    protected void simplePaintClientArea(Graphics graphics) {
        super.paintClientArea(graphics);
    }

    protected boolean usesSubAlphaGraphics() {
        return this.getSubAlpha() >= 0 && this.getSubAlpha() < 255;
    }

    protected Graphics createAlphaGraphics(Graphics graphics, int alpha) {
        AlphaGraphics ag = new AlphaGraphics(graphics);
        ag.setMainAlpha(alpha);
        return ag;
    }
}

