/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.editpolicies;

import org.xmind.gef.ISourceProvider;
import org.xmind.gef.IViewer;
import org.xmind.gef.Request;
import org.xmind.gef.command.Command;
import org.xmind.gef.dnd.DndData;
import org.xmind.gef.dnd.IDndClient;
import org.xmind.gef.dnd.IDndSupport;
import org.xmind.ui.commands.CommandMessages;
import org.xmind.ui.internal.editpolicies.MindMapPolicyBase;

public class DropTargetPolicy
extends MindMapPolicyBase {
    public boolean understands(String requestType) {
        return super.understands(requestType) || "drop".equals(requestType);
    }

    public void handle(Request request) {
        String type = request.getType();
        if ("drop".equals(type)) {
            this.drop(request);
        }
    }

    private void drop(Request request) {
        DndData dndData = (DndData)request.getParameter("dndData");
        if (dndData == null) {
            return;
        }
        IViewer viewer = request.getTargetViewer();
        if (viewer == null) {
            return;
        }
        IDndSupport dndSupport = viewer.getDndSupport();
        if (dndSupport == null) {
            return;
        }
        IDndClient client = dndSupport.getDndClient(dndData.clientId);
        if (client == null) {
            return;
        }
        Command command = client.makeDNDCommand(dndData.parsedData, request);
        if (command == null) {
            return;
        }
        command.setLabel(CommandMessages.Command_AddResources);
        this.saveAndRun(command, request.getTargetDomain());
        if (command instanceof ISourceProvider) {
            this.select(((ISourceProvider)command).getSources(), viewer);
        }
    }
}

