/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.e4handlers;

import java.io.File;
import javax.inject.Inject;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.xmind.ui.dialogs.IDialogConstants;
import org.xmind.ui.internal.MindMapMessages;
import org.xmind.ui.internal.MindMapUIPlugin;
import org.xmind.ui.internal.e4handlers.OpenWorkbooksHandler;
import org.xmind.ui.internal.protocols.FilePathParser;
import org.xmind.ui.util.PrefUtils;

public class OpenHomeMapHandler {
    @Inject
    public void execute(IWorkbenchWindow window) {
        if (window == null) {
            return;
        }
        String filePath = MindMapUIPlugin.getDefault().getPreferenceStore().getString("homeMapLocation");
        String errorMessage = null;
        if (filePath == null || "".equals(filePath)) {
            errorMessage = MindMapMessages.OpenHomeMap_Error_message;
        } else if (!new File(filePath).exists()) {
            errorMessage = MindMapMessages.OpenHomeMapAction_HomeMapMissingMessage;
        }
        if (errorMessage != null) {
            boolean ok = MessageDialog.openConfirm((Shell)window.getShell(), (String)IDialogConstants.COMMON_TITLE, (String)errorMessage);
            if (!ok) {
                return;
            }
            PrefUtils.openPrefDialog((Shell)window.getShell(), (String)"org.xmind.ui.prefPage.General");
            filePath = MindMapUIPlugin.getDefault().getPreferenceStore().getString("homeMapLocation");
        }
        if (filePath == null || "".equals(filePath) || !new File(filePath).exists()) {
            return;
        }
        OpenWorkbooksHandler.execute(window, FilePathParser.toURI(filePath, false));
    }
}

