/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.actions;

import java.io.File;
import java.io.InputStream;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.ActionFactory;
import org.xmind.core.Core;
import org.xmind.core.IWorkbook;
import org.xmind.core.util.FileUtils;
import org.xmind.ui.internal.dialogs.DialogMessages;
import org.xmind.ui.internal.editor.MME;

public abstract class BaseNewFromTemplateAction
extends Action
implements ActionFactory.IWorkbenchAction {
    private IWorkbenchWindow window;
    private final IEditorPart[] editorPart = new IEditorPart[1];

    protected BaseNewFromTemplateAction(IWorkbenchWindow window) {
        if (window == null) {
            throw new IllegalArgumentException();
        }
        this.window = window;
    }

    public void run() {
        InputStream templateStream;
        if (this.window == null) {
            return;
        }
        final IWorkbenchPage page = this.window.getActivePage();
        if (page == null) {
            return;
        }
        try {
            templateStream = this.getTemplateStream(this.window.getShell());
        }
        catch (Exception exception) {
            this.notifyTemplateMissing(this.window.getShell());
            return;
        }
        if (templateStream == null) {
            return;
        }
        SafeRunner.run((ISafeRunnable)new SafeRunnable(){

            public void run() throws Exception {
                IEditorInput input = MME.createTemplatedEditorInput(templateStream);
                ((BaseNewFromTemplateAction)BaseNewFromTemplateAction.this).editorPart[0] = page.openEditor(input, "org.xmind.ui.MindMapEditor");
            }
        });
    }

    public IEditorPart getEditorPart() {
        return this.editorPart[0];
    }

    protected void notifyTemplateMissing(Shell shell) {
        MessageDialog.openError((Shell)shell, (String)DialogMessages.CommonDialogTitle, (String)NLS.bind((String)DialogMessages.TemplateMissing_message, (Object)this.getText()));
    }

    protected abstract InputStream getTemplateStream(Shell var1) throws Exception;

    protected IWorkbook createWorkbookFromTemplate(InputStream is) throws Exception {
        String tempLocation = Core.getWorkspace().getTempFile(String.valueOf(Core.getIdFactory().createId()) + ".xmind");
        FileUtils.ensureDirectory((File)new File(tempLocation));
        return Core.getWorkbookBuilder().loadFromStream(is, tempLocation);
    }

    public void dispose() {
        this.window = null;
    }
}

