/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver.requesthandlers;

import com.google.inject.Inject;
import com.google.jstestdriver.annotations.RequestProtocol;
import com.google.jstestdriver.requesthandlers.HttpMethod;
import java.io.IOException;
import javax.servlet.http.HttpServletResponse;

class UnsupportedMethodErrorSender {
    private static final String MESSAGE = "HTTP method %s is not supported by this URL";
    private static final String ONE_ONE = "1.1";
    private final HttpMethod requestMethod;
    private final String requestProtocol;
    private final HttpServletResponse response;

    @Inject
    public UnsupportedMethodErrorSender(HttpMethod requestMethod, @RequestProtocol String requestProtocol, HttpServletResponse response) {
        this.requestMethod = requestMethod;
        this.requestProtocol = requestProtocol;
        this.response = response;
    }

    public void methodNotAllowed() throws IOException {
        if (this.requestProtocol.endsWith(ONE_ONE)) {
            this.sendError(405);
        } else {
            this.sendError(400);
        }
    }

    private void sendError(int errorCode) throws IOException {
        this.response.sendError(errorCode, String.format(MESSAGE, new Object[]{this.requestMethod}));
    }
}

