/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.JsonParseException;
import com.google.gson.reflect.TypeToken;
import com.google.inject.Inject;
import com.google.jstestdriver.BrowserInfo;
import com.google.jstestdriver.FailureParser;
import com.google.jstestdriver.Response;
import com.google.jstestdriver.TestResult;
import com.google.jstestdriver.model.NullPathPrefix;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestResultGenerator {
    private static String NEW_LINE = System.getProperty("line.separator");
    private final Gson gson = new Gson();
    private final FailureParser failureParser;

    @Deprecated
    public TestResultGenerator() {
        this(new FailureParser(new NullPathPrefix()));
    }

    @Inject
    public TestResultGenerator(FailureParser failureParser) {
        this.failureParser = failureParser;
    }

    public Collection<TestResult> getTestResults(Response response) {
        try {
            if (response.getResponseType() != Response.ResponseType.TEST_RESULT) {
                return Collections.emptyList();
            }
            Collection results = (Collection)this.gson.fromJson(response.getResponse(), new TypeToken<Collection<TestResult>>(){}.getType());
            for (TestResult result : results) {
                BrowserInfo browserInfo = response.getBrowser();
                result.setBrowserInfo(browserInfo);
                if (result.getResult() == TestResult.Result.passed) continue;
                List<FailureParser.Failure> failures = this.failureParser.parse(result.getMessage());
                result.setParsedMessage(Joiner.on(NEW_LINE).join(Lists.transform(failures, new Function<FailureParser.Failure, String>(){

                    @Override
                    public String apply(FailureParser.Failure failure) {
                        return failure.getMessage();
                    }
                })));
                StringBuilder sb = new StringBuilder();
                for (FailureParser.Failure failure : failures) {
                    for (String l : failure.getStack()) {
                        sb.append(l);
                        sb.append(NEW_LINE);
                    }
                    sb.append(NEW_LINE);
                }
                result.setStack(sb.toString());
            }
            return results;
        }
        catch (JsonParseException e) {
            throw new RuntimeException(e);
        }
    }
}

