/*
 * Decompiled with CFR 0.152.
 */
package net.humblestar.gcalcdemo.calculus;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import javax.swing.Box;
import javax.swing.JPanel;
import net.gcalc.calc.gui.SwingGUI;
import net.gcalc.calc.main.SymbolTable;
import net.gcalc.calc.main.ValueTable;
import net.gcalc.calc.math.functions.Function;
import net.gcalc.calc.math.functions.FunctionFactory;
import net.gcalc.calc.models.ColoredModel;
import net.gcalc.calc.models.Model;
import net.gcalc.calc.parser.BadSyntaxException;
import net.gcalc.calc.parser.Token;
import net.gcalc.plugin.gui.AbstractCartesianGraphPlugin;
import net.gcalc.plugin.gui.InputPanel;
import net.gcalc.plugin.gui.PropertiesPanel;
import net.gcalc.plugin.gui.SimpleColorChooser;
import net.gcalc.plugin.plane.CartesianGraphPlugin;
import net.gcalc.plugin.plane.graph.CartesianGraph;
import net.gcalc.plugin.plane.gui.FlagPanel;
import net.gcalc.plugin.plane.gui.ModelListPanel;
import net.gcalc.plugin.properties.GraphProperties;
import net.humblestar.gcalcdemo.calculus.NumericalIntegrationInputPanel;

public class NumericalIntegrationPlugin
extends CartesianGraphPlugin {
    public static final int LH_RIEMANN = 0;
    public static final int RH_RIEMANN = 1;
    public static final int MIDPOINT = 2;
    public static final int TRAPEZOIDAL = 3;
    public static final int SIMPSON = 4;

    public NumericalIntegrationPlugin() {
        this.graph = new NumericalIntegrationGraph(this);
    }

    protected void initPropertiesPanel() {
        JPanel flagPanel = this.makeFlagPanel();
        Box viewPanel = SwingGUI.wrap(this.makeViewPanel());
        this.colorChooser = new SimpleColorChooser(this.firstColor());
        PropertiesPanel propertiesPanel = this.getPropertiesPanel();
        propertiesPanel.addTab("Properties", flagPanel);
        propertiesPanel.addTab("View", viewPanel);
        propertiesPanel.addTab("Screen", this.makeGraphDimensionPanel());
    }

    protected JPanel makeFlagPanel() {
        return new FlagPanel(this.graph.getProperties(), 5, 2, new String[]{GraphProperties.H_GRID, GraphProperties.V_GRID, GraphProperties.H_AXIS, GraphProperties.V_AXIS, GraphProperties.H_LABEL, GraphProperties.V_LABEL, GraphProperties.H_SCALE, GraphProperties.V_SCALE, GraphProperties.H_TITLE, GraphProperties.V_TITLE});
    }

    protected InputPanel getInputPanel() {
        return new NumericalIntegrationInputPanel();
    }

    protected JPanel makeModelListPanel() {
        return new ModelListPanel(this.graph.getProperties(), false, true);
    }

    public String getDescription() {
        return "<p>Demonstrates numerical integration methods.</p>";
    }

    public String getPluginName() {
        return "Numerical Integration Plugin";
    }

    public void actionPerformed(ActionEvent event) {
        if (event.getSource() == this.ip) {
            int method;
            int subdiv;
            double x1;
            double x0;
            String[] values = this.ip.getValues();
            String s1 = values[0].trim();
            String s2 = values[1].trim();
            String s3 = values[2].trim();
            String s4 = values[3].trim();
            String s5 = values[4].trim();
            Function f = null;
            try {
                x0 = Double.parseDouble(s2);
            }
            catch (NumberFormatException e) {
                this.popupMessageDialog("'" + s2 + "' is not a number!\n" + e.getMessage(), 0);
                return;
            }
            try {
                x1 = Double.parseDouble(s3);
            }
            catch (NumberFormatException e) {
                this.popupMessageDialog("'" + s3 + "' is not a number!\n" + e.getMessage(), 0);
                return;
            }
            try {
                subdiv = Integer.parseInt(s4);
            }
            catch (NumberFormatException e) {
                this.popupMessageDialog("'" + s4 + "' is not a number!\n" + e.getMessage(), 0);
                return;
            }
            try {
                method = Integer.parseInt(s5);
            }
            catch (NumberFormatException e) {
                this.popupMessageDialog("Bad Method (" + s5 + ")\n" + e.getMessage(), 0);
                return;
            }
            try {
                f = FunctionFactory.getFunction(s1);
            }
            catch (BadSyntaxException e) {
                this.popupMessageDialog("Bad Syntax in '" + s1 + "'!\n" + e.getMessage(), 0);
                return;
            }
            double sum = ((NumericalIntegrationGraph)this.graph).numericalIntegration(f, x0, x1, subdiv, method);
            ((NumericalIntegrationInputPanel)this.ip).setAnswer(sum);
            this.drawGraph(new ColoredModel(f, s1, this.getNewColor()));
            this.statusBar.setText("Graphing: " + s1);
        }
    }

    protected void drawGraph(ColoredModel model) {
        this.graph.draw((Model)model);
        this.ip.addCurrentValuesToHistory();
    }

    class NumericalIntegrationGraph
    extends CartesianGraph {
        private Function f = null;
        private double min;
        private double max;
        private int subdivision;
        private int method;

        public NumericalIntegrationGraph(AbstractCartesianGraphPlugin plugin) {
            super(plugin);
        }

        public Dimension defaultDimension() {
            return new Dimension(425, 425);
        }

        protected double calculateAndDrawSimpleRule(Function f, double min, double max, int n, int rule, SymbolTable st, ValueTable vt, boolean draw) {
            Token X = new Token("x", 3);
            double sum = 0.0;
            int i = 0;
            while (i < n) {
                double x1 = min + (max - min) * (double)i / (double)n;
                double x2 = min + (max - min) * (double)(i + 1) / (double)n;
                switch (rule) {
                    case 0: {
                        vt.setValue(X, x1);
                        break;
                    }
                    case 1: {
                        vt.setValue(X, x2);
                        break;
                    }
                    case 2: {
                        vt.setValue(X, (x1 + x2) / 2.0);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Bad Integration Rule for this method.");
                    }
                }
                double yy = f.evaluate(st, vt);
                sum += yy * (x2 - x1);
                if (draw) {
                    int sx1 = this.cartesianXtoScreen(x1);
                    int sx2 = this.cartesianXtoScreen(x2);
                    int y1 = this.cartesianYtoScreen(yy);
                    int y2 = this.cartesianYtoScreen(0.0);
                    int sy1 = Math.max(y1, y2);
                    int sy2 = Math.min(y1, y2);
                    this.gr.setColor(new Color(200, 200, 255));
                    this.gr.fillRect(sx1, sy2, sx2 - sx1, sy1 - sy2);
                    this.gr.setColor(new Color(0, 0, 255));
                    this.gr.drawRect(sx1, sy2, sx2 - sx1, sy1 - sy2);
                }
                ++i;
            }
            return sum;
        }

        protected double calculateAndDrawTrapezoidal(Function f, double min, double max, int n, SymbolTable st, ValueTable vt, boolean draw) {
            Token X = new Token("x", 3);
            double sum = 0.0;
            int i = 0;
            while (i < n) {
                double x1 = min + (max - min) * (double)i / (double)n;
                double x2 = min + (max - min) * (double)(i + 1) / (double)n;
                vt.setValue(X, x1);
                double yy1 = f.evaluate(st, vt);
                vt.setValue(X, x2);
                double yy2 = f.evaluate(st, vt);
                sum += (x2 - x1) * 0.5 * (yy1 + yy2);
                if (draw) {
                    int sx1 = this.cartesianXtoScreen(x1);
                    int sx2 = this.cartesianXtoScreen(x2);
                    int h1 = this.cartesianYtoScreen(yy1);
                    int h2 = this.cartesianYtoScreen(yy2);
                    int h0 = this.cartesianYtoScreen(0.0);
                    this.gr.setColor(new Color(200, 200, 255));
                    if (sx1 != sx2) {
                        int j = sx1;
                        while (j <= sx2) {
                            this.gr.drawLine(j, h0, j, h1 + (h2 - h1) * (j - sx1) / (sx2 - sx1));
                            ++j;
                        }
                    } else {
                        this.gr.drawLine(sx1, h0, sx1, h1);
                    }
                    this.gr.setColor(Color.blue);
                    this.gr.drawLine(sx1, h0, sx1, h1);
                    this.gr.drawLine(sx2, h0, sx2, h2);
                    this.gr.drawLine(sx1, h1, sx2, h2);
                    this.gr.drawLine(sx1, h0, sx2, h0);
                }
                ++i;
            }
            return sum;
        }

        protected double calculateAndDrawSimpson(Function f, double min, double max, int n, SymbolTable st, ValueTable vt, boolean draw) {
            Token X = new Token("x", 3);
            double sum = 0.0;
            int i = 0;
            while (i < n) {
                double x1 = min + (max - min) * (double)i / (double)n;
                double x3 = min + (max - min) * (double)(i + 1) / (double)n;
                double x2 = (x3 + x1) / 2.0;
                vt.setValue(X, x1);
                double yy1 = f.evaluate(st, vt);
                vt.setValue(X, x2);
                double yy2 = f.evaluate(st, vt);
                vt.setValue(X, x3);
                double yy3 = f.evaluate(st, vt);
                sum += (x2 - x1) * (yy1 + 4.0 * yy2 + yy3) / 3.0;
                int sx1 = this.cartesianXtoScreen(x1);
                int sx3 = this.cartesianXtoScreen(x3);
                int h1 = this.cartesianYtoScreen(yy1);
                int h3 = this.cartesianYtoScreen(yy3);
                int h0 = this.cartesianYtoScreen(0.0);
                if (sx1 != sx3) {
                    int j = sx1;
                    while (j <= sx3) {
                        double xx = this.screenXtoCartesian(j);
                        double yy = (xx - x2) * (xx - x3) * yy1 / (x1 - x2) / (x1 - x3) + (xx - x1) * (xx - x3) * yy2 / (x2 - x1) / (x2 - x3) + (xx - x1) * (xx - x2) * yy3 / (x3 - x1) / (x3 - x2);
                        int h = this.cartesianYtoScreen(yy);
                        if (draw) {
                            this.gr.setColor(new Color(200, 200, 255));
                            this.gr.drawLine(j, h0, j, h);
                            this.gr.setColor(Color.blue);
                            this.gr.drawLine(j, h, j, h);
                        }
                        ++j;
                    }
                } else if (draw) {
                    this.gr.setColor(new Color(200, 200, 255));
                    this.gr.drawLine(sx1, h0, sx1, h1);
                    this.gr.setColor(Color.blue);
                    this.gr.drawLine(sx1, h1, sx1, h1);
                }
                if (draw) {
                    this.gr.setColor(Color.blue);
                    this.gr.drawLine(sx1, h0, sx1, h1);
                    this.gr.drawLine(sx3, h0, sx3, h3);
                    this.gr.drawLine(sx1, h0, sx3, h0);
                }
                ++i;
            }
            return sum;
        }

        public double numericalIntegration(Function f, double min, double max, int n, int method) {
            this.f = f;
            this.min = min;
            this.max = max;
            this.subdivision = n;
            this.method = method;
            this.getModelList().removeAllModels();
            this.redrawAll();
            return this.calculateAndDrawNumericalIntegration(false);
        }

        public void drawModelList() {
            if (this.f != null) {
                this.calculateAndDrawNumericalIntegration(true);
            }
            super.drawModelList();
        }

        private double calculateAndDrawNumericalIntegration(boolean draw) {
            SymbolTable st = new SymbolTable();
            ValueTable vt = new ValueTable();
            double sum = Double.NaN;
            switch (this.method) {
                case 0: 
                case 1: 
                case 2: {
                    sum = this.calculateAndDrawSimpleRule(this.f, this.min, this.max, this.subdivision, this.method, st, vt, draw);
                    break;
                }
                case 3: {
                    sum = this.calculateAndDrawTrapezoidal(this.f, this.min, this.max, this.subdivision, st, vt, draw);
                    break;
                }
                case 4: {
                    sum = this.calculateAndDrawSimpson(this.f, this.min, this.max, this.subdivision, st, vt, draw);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unrecognized method " + this.method);
                }
            }
            return sum;
        }
    }
}

