/*
 * Decompiled with CFR 0.152.
 */
package net.gcalc.proto.plugin.space;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.Arrays;
import java.util.Vector;
import net.gcalc.calc.main.ValueTable;
import net.gcalc.calc.math.functions.Function;
import net.gcalc.calc.models.Model;
import net.gcalc.calc.parser.VariableToken;
import net.gcalc.plugin.gui.BufferedCanvas;
import net.gcalc.proto.plugin.space.DoubleTriple;
import net.gcalc.proto.plugin.space.Segment3D;

class Graph3DCanvas
extends BufferedCanvas
implements Runnable {
    private int res = 45;
    private double scalingFactor;
    private double rho;
    private double theta;
    private double phi;
    private int px;
    private int py;
    private double phi0;
    private double theta0;
    private double dtheta = 0.0;
    private double dphi = 0.0;
    boolean mousePressed = false;
    double xmin = -2.0;
    double ymin = -2.0;
    double zmin = -2.0;
    double xmax = 2.0;
    double ymax = 2.0;
    double zmax = 2.0;
    private double maxz = Double.NaN;
    private double minz = Double.NaN;
    protected Segment3D[] Q = new Segment3D[0];
    protected Vector axes;

    public Graph3DCanvas() {
        this.setSize(400, 400);
        this.setPreferredSize(new Dimension(400, 400));
        this.addMouseListener(new CustomMouseAdapter());
        this.addMouseMotionListener(new CustomMouseMotionAdapter());
        this.setCursor(new Cursor(1));
        double m = Math.max(this.xmax - this.xmin, this.ymax - this.ymin);
        m = Math.max(m, this.zmax - this.zmin);
        this.scalingFactor = 5600.0 / m;
        this.rho = 30.0;
        this.initAxes();
        this.defaultPerspective();
    }

    protected void initAxes() {
        double[] X = new double[]{this.xmin, this.xmax};
        double[] Y = new double[]{this.ymin, this.ymax};
        double[] Z = new double[]{this.zmin, this.zmax};
        this.axes = new Vector();
        int i = 0;
        while (i < 2) {
            int j = 0;
            while (j < 2) {
                this.axes.add(new Segment3D(new DoubleTriple(X[0], Y[i], Z[j]), new DoubleTriple(X[1], Y[i], Z[j]), Color.gray, Color.red, true));
                this.axes.add(new Segment3D(new DoubleTriple(X[i], Y[0], Z[j]), new DoubleTriple(X[i], Y[1], Z[j]), Color.gray, Color.green, true));
                this.axes.add(new Segment3D(new DoubleTriple(X[i], Y[j], Z[0]), new DoubleTriple(X[i], Y[j], Z[1]), Color.gray, Color.blue, true));
                ++j;
            }
            ++i;
        }
    }

    private double[][] getGrid(Function F) {
        ValueTable vt = new ValueTable();
        double[][] data = new double[this.res][this.res];
        int i = 0;
        while (i < this.res) {
            double x = this.xmin + (this.xmax - this.xmin) * (double)i / (double)(this.res - 1);
            vt.setValue(VariableToken.X_VAR, x);
            int j = 0;
            while (j < this.res) {
                double y = this.ymin + (this.ymax - this.ymin) * (double)j / (double)(this.res - 1);
                vt.setValue(VariableToken.Y_VAR, y);
                data[i][j] = F.evaluate(vt);
                ++j;
            }
            ++i;
        }
        return data;
    }

    public double gridXtoCartesian(int i) {
        return this.xmin + (this.xmax - this.xmin) * (double)i / (double)(this.res - 1);
    }

    public double gridYtoCartesian(int j) {
        return this.ymin + (this.ymax - this.ymin) * (double)j / (double)(this.res - 1);
    }

    private Vector getGridSegments(double[][] r) {
        Vector<Segment3D> v = new Vector<Segment3D>();
        int i = 0;
        while (i < this.res) {
            double x = this.gridXtoCartesian(i);
            int j = 0;
            while (j < this.res) {
                if (r[i][j] <= this.zmax && this.zmin <= r[i][j]) {
                    double y = this.gridYtoCartesian(j);
                    DoubleTriple A = new DoubleTriple(x, y, r[i][j]);
                    if (i + 1 < this.res && !Double.isNaN(r[i + 1][j]) && r[i + 1][j] <= this.zmax && this.zmin <= r[i + 1][j]) {
                        DoubleTriple B = new DoubleTriple(this.gridXtoCartesian(i + 1), y, r[i + 1][j]);
                        v.add(new Segment3D(A, B, Color.gray, Color.black));
                    }
                    if (j + 1 < this.res && !Double.isNaN(r[i][j + 1]) && r[i][j + 1] <= this.zmax && this.zmin <= r[i][j + 1]) {
                        DoubleTriple C = new DoubleTriple(x, this.gridYtoCartesian(j + 1), r[i][j + 1]);
                        v.add(new Segment3D(A, C, Color.gray, Color.black));
                    }
                }
                ++j;
            }
            ++i;
        }
        return v;
    }

    public synchronized void setModel(Model fg) {
        this.Q = new Segment3D[0];
        double[][] r = this.getGrid(fg.getFunction());
        Vector v = this.getGridSegments(r);
        v.addAll(this.axes);
        Segment3D[] segs = new Segment3D[this.Q.length + v.size()];
        System.arraycopy(this.Q, 0, segs, 0, this.Q.length);
        int k = 0;
        while (k < v.size()) {
            segs[this.Q.length + k] = (Segment3D)v.elementAt(k);
            ++k;
        }
        this.Q = segs;
        this.redrawAll();
    }

    public void defaultPerspective() {
        this.phi = 1.0471975511965976;
        this.theta = -2.0943951023931953;
        this.dphi = 0.0;
        this.dtheta = 0.0;
    }

    private void transformation(double theta, double phi, double rho, double sf) {
        if (this.Q.length == 0) {
            return;
        }
        double s1 = Math.sin(theta);
        double c1 = Math.cos(theta);
        double s2 = Math.sin(phi);
        double c2 = Math.cos(phi);
        double x0 = (this.xmin + this.xmax) / 2.0;
        double y0 = (this.ymin + this.ymax) / 2.0;
        double z0 = (this.zmin + this.zmax) / 2.0;
        int i = 0;
        while (i < this.Q.length) {
            this.Q[i].transform(s1, c1, s2, c2, x0, y0, z0, rho, sf);
            ++i;
        }
        Arrays.sort(this.Q);
        this.minz = this.Q[0].averageDistance();
        this.maxz = this.Q[this.Q.length - 1].averageDistance();
    }

    public synchronized void clear() {
        this.Q = new Segment3D[this.axes.size()];
        int k = 0;
        while (k < this.axes.size()) {
            this.Q[k] = (Segment3D)this.axes.elementAt(k);
            ++k;
        }
        this.redrawAll();
    }

    public void run() {
        double t = 0.0;
        double p = 0.0;
        double r = 0.0;
        double d = 0.0;
        while (true) {
            if (!this.mousePressed && this.Q.length >= this.axes.size()) {
                this.theta += this.dtheta;
                this.phi += this.dphi;
                if ((t != this.theta || p != this.phi || r != this.rho || d != this.scalingFactor) && this.isShowing()) {
                    this.redrawAll();
                    t = this.theta;
                    p = this.phi;
                    r = this.rho;
                    d = this.scalingFactor;
                }
            }
            try {
                Thread.sleep(60L);
            }
            catch (InterruptedException e) {
                return;
            }
        }
    }

    public synchronized void redrawAll() {
        if (this.gr == null) {
            return;
        }
        this.gr.setColor(Color.white);
        this.gr.fillRect(0, 0, 400, 400);
        if (this.Q.length == 0) {
            this.repaint();
            return;
        }
        this.transformation(this.theta, this.phi, this.rho, this.scalingFactor);
        int i = this.Q.length - 1;
        while (i >= 0) {
            this.drawSegment(this.Q[i]);
            --i;
        }
        this.repaint();
    }

    private void drawSegment(Segment3D s) {
        DoubleTriple p1 = s.getP1();
        DoubleTriple p2 = s.getP2();
        int x1 = (int)(p1.getX() / p1.getZ() + (double)(this.getWidth() / 2));
        int y1 = (int)((double)(this.getHeight() / 2) - p1.getY() / p1.getZ());
        int x2 = (int)(p2.getX() / p2.getZ() + (double)(this.getWidth() / 2));
        int y2 = (int)((double)(this.getHeight() / 2) - p2.getY() / p2.getZ());
        double avgz = s.averageDistance();
        double percentage = (avgz - this.minz) / (this.maxz - this.minz);
        double dx = x2 - x1;
        double dy = y2 - y1;
        double len = Math.sqrt(dx * dx + dy * dy);
        dx /= len;
        dy /= len;
        double scl = 5.0;
        this.gr.setColor(this.colorGradient(s.nearColor(), s.farColor(), (float)percentage));
        this.gr.drawLine(x1, y1, x2, y2);
        if (s.isArrow()) {
            this.gr.drawLine((int)((double)x2 - (dx - dy) * scl), (int)((double)y2 - (dx + dy) * scl), x2, y2);
            this.gr.drawLine((int)((double)x2 - (dx + dy) * scl), (int)((double)y2 - (-dx + dy) * scl), x2, y2);
        }
    }

    private Color colorGradient(Color a, Color b, float f) {
        float[] c = a.getRGBComponents(null);
        float[] d = b.getRGBComponents(null);
        float[] e = new float[4];
        int i = 0;
        while (i < 4) {
            e[i] = c[i] + f * (d[i] - c[i]);
            ++i;
        }
        return new Color(e[0], e[1], e[2]);
    }

    class CustomMouseAdapter
    extends MouseAdapter {
        CustomMouseAdapter() {
        }

        public void mousePressed(MouseEvent e) {
            Graph3DCanvas.this.px = e.getX();
            Graph3DCanvas.this.py = e.getY();
            Graph3DCanvas.this.phi0 = Graph3DCanvas.this.phi;
            Graph3DCanvas.this.theta0 = Graph3DCanvas.this.theta;
            Graph3DCanvas.this.dphi = 0.0;
            Graph3DCanvas.this.dtheta = 0.0;
            Graph3DCanvas.this.mousePressed = true;
        }

        public void mouseReleased(MouseEvent e) {
            Graph3DCanvas.this.mousePressed = false;
        }
    }

    class CustomMouseMotionAdapter
    extends MouseMotionAdapter {
        CustomMouseMotionAdapter() {
        }

        public void mouseDragged(MouseEvent e) {
            double p = Graph3DCanvas.this.phi0 + (double)((Graph3DCanvas.this.py - e.getY()) * 2) * Math.PI / (double)Graph3DCanvas.this.getHeight();
            double t = Graph3DCanvas.this.theta0 + (double)((e.getX() - Graph3DCanvas.this.px) * 2) * Math.PI / (double)Graph3DCanvas.this.getWidth();
            Graph3DCanvas.this.dphi = p - Graph3DCanvas.this.phi;
            Graph3DCanvas.this.dtheta = t - Graph3DCanvas.this.theta;
            Graph3DCanvas.this.phi = p;
            Graph3DCanvas.this.theta = t;
            Graph3DCanvas.this.redrawAll();
        }
    }
}

