/*
 * Decompiled with CFR 0.152.
 */
package net.gcalc.proto.plugin.mandelbrot;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import net.gcalc.calc.gui.gradient.CompoundGradient;
import net.gcalc.plugin.gui.AbstractCartesianGraphPlugin;
import net.gcalc.plugin.plane.graph.CartesianGraph;
import net.gcalc.plugin.properties.GraphProperties;
import net.gcalc.plugin.properties.Range;
import net.gcalc.plugin.properties.View;
import net.gcalc.proto.plugin.mandelbrot.Mandelbrot;

class MandelbrotGraph
extends CartesianGraph {
    private MandelbrotDrawingThread drawingThread;
    private Mandelbrot mandel;
    private CompoundGradient gradient;

    public MandelbrotGraph(AbstractCartesianGraphPlugin plugin) {
        super(plugin);
        this.removeMouseListener(this.normalMouseAdapter);
        this.addMouseListener(new MandelbrotMouseAdapter());
        this.gradient = new CompoundGradient(Color.blue, Color.red);
        this.mandel = new Mandelbrot(20000);
    }

    public void killThread() {
        this.drawingThread.die();
    }

    protected void setDefaultView() {
        this.properties.initDefault(GraphProperties.VIEW, new View(new Range(-2.0, 2.0, 1.0), new Range(-2.0, 2.0, 1.0)));
        this.properties.initDefault(GraphProperties.TRACE, false);
        this.properties.revertToDefault(GraphProperties.VIEW);
    }

    protected void setDefaultScreenDimension() {
        this.properties.put(GraphProperties.SCREEN_DIMENSION, new Dimension(400, 400));
    }

    public void redrawAll(boolean b) {
        if (this.drawingThread != null) {
            this.drawingThread.die();
        }
        this.drawingThread = new MandelbrotDrawingThread();
        this.drawingThread.start();
    }

    public CompoundGradient getGradient() {
        return this.gradient;
    }

    public void setGradient(CompoundGradient g) {
        this.gradient = g;
    }

    class MandelbrotMouseAdapter
    extends MouseAdapter {
        MandelbrotMouseAdapter() {
        }

        public void mouseClicked(MouseEvent e) {
            double factor = 0.6666666865348816;
            if (e.getButton() == 3) {
                factor = 1.0 / factor;
            }
            Range xRange = MandelbrotGraph.this.getXRange();
            Range yRange = MandelbrotGraph.this.getYRange();
            double w = MandelbrotGraph.this.getWidth();
            double h = MandelbrotGraph.this.getHeight();
            double aspect = h / w;
            double x = MandelbrotGraph.this.screenXtoCartesian(e.getX());
            double y = MandelbrotGraph.this.screenYtoCartesian(e.getY());
            if (MandelbrotGraph.this.drawingThread != null) {
                MandelbrotGraph.this.drawingThread.die();
            }
            double size = xRange.getWidth();
            xRange = new Range(x - factor * (double)e.getX() / w * size, x + factor * (1.0 - (double)e.getX() / w) * size);
            yRange = new Range(y - factor * (1.0 - (double)e.getY() / h) * size * aspect, y + factor * ((double)e.getY() / h) * size * aspect);
            MandelbrotGraph.this.setXYRange(xRange, yRange);
            MandelbrotGraph.this.redrawAll();
        }
    }

    class MandelbrotDrawingThread
    extends Thread {
        boolean die = false;

        MandelbrotDrawingThread() {
        }

        public void die() {
            this.die = true;
        }

        private void drawSquare(int i, int j, int size) {
            double x = MandelbrotGraph.this.screenXtoCartesian(i);
            double y = MandelbrotGraph.this.screenYtoCartesian(j);
            int c = MandelbrotGraph.this.mandel.escape(x, y);
            if (c == MandelbrotGraph.this.mandel.maxIteration()) {
                MandelbrotGraph.this.gr.setColor(Color.black);
            } else {
                float h = (float)(2 * c % 1000) / 1000.0f;
                MandelbrotGraph.this.gr.setColor(MandelbrotGraph.this.gradient.getColor(h));
            }
            MandelbrotGraph.this.gr.fillRect(i, j, size, size);
        }

        public void run() {
            if (!MandelbrotGraph.this.isShowing()) {
                return;
            }
            int N = Math.max(MandelbrotGraph.this.getWidth(), MandelbrotGraph.this.getHeight());
            int n = 1;
            while (n < N) {
                n *= 2;
            }
            this.drawSquare(0, 0, 16);
            int pow2 = 1;
            int size = n;
            int x = 0;
            int y = 0;
            int x2 = 0;
            int y2 = 0;
            int count = 0;
            int max = MandelbrotGraph.this.getHeight() * MandelbrotGraph.this.getWidth();
            int g = 0;
            while (g < (int)(Math.log(n) / Math.log(2.0))) {
                int i = 0;
                while (i < pow2 && !this.die) {
                    x = i * size;
                    if (x < MandelbrotGraph.this.getWidth()) {
                        x2 = x + size / 2;
                        int j = 0;
                        while (j < pow2 && !this.die) {
                            y = j * size;
                            if (y < MandelbrotGraph.this.getHeight()) {
                                y2 = y + size / 2;
                                if (y2 < MandelbrotGraph.this.getHeight()) {
                                    this.drawSquare(x, y2, size);
                                    if (x2 < MandelbrotGraph.this.getWidth()) {
                                        this.drawSquare(x2, y2, size);
                                    }
                                }
                                if (x2 < MandelbrotGraph.this.getHeight()) {
                                    this.drawSquare(x2, y, size);
                                }
                                count += 3;
                            } else {
                                j = pow2;
                            }
                            ++j;
                        }
                    }
                    MandelbrotGraph.this.getProperties().put("progress", new Integer(count));
                    ++i;
                }
                if (this.die) {
                    return;
                }
                if (size < 16) {
                    Thread.yield();
                    MandelbrotGraph.this.repaint();
                }
                size = n / (pow2 *= 2);
                ++g;
            }
            MandelbrotGraph.this.getProperties().put("progress", new Integer(max));
            Toolkit.getDefaultToolkit().beep();
        }
    }
}

