/*
 * Decompiled with CFR 0.152.
 */
package net.gcalc.plugin.plane.graph;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Observable;
import java.util.Vector;
import net.gcalc.calc.main.ValueTable;
import net.gcalc.calc.math.functions.Function;
import net.gcalc.calc.models.ModelList;
import net.gcalc.calc.models.RenderableModel;
import net.gcalc.calc.parser.VariableToken;
import net.gcalc.plugin.gui.AbstractCartesianGraphPlugin;
import net.gcalc.plugin.plane.graph.GraphCanvas;
import net.gcalc.plugin.plane.gui.CoordinatePanel;
import net.gcalc.plugin.plane.gui.ExtendedMouseAdapter;
import net.gcalc.plugin.plane.gui.ResizeAndPackAdapter;
import net.gcalc.plugin.properties.GraphProperties;
import net.gcalc.plugin.properties.Range;
import net.gcalc.plugin.properties.StaticZoom;
import net.gcalc.plugin.properties.View;
import net.gcalc.plugin.properties.Zoom;

public class CartesianGraph
extends GraphCanvas {
    public static final int VANILLA_MODE = 0;
    public static final int TRACE_MODE = 1;
    public static final int DRAW_MODE = 2;
    private String[] labels = new String[2];
    protected ExtendedMouseAdapter normalMouseAdapter = new NormalMouseAdapter();
    protected ExtendedMouseAdapter traceMouseAdapter = new TraceMouseAdapter();
    protected ExtendedMouseAdapter tangentMouseAdapter = new TangentMouseAdapter();
    protected Rectangle highlightRectangle = null;
    private final Color LIGHT_YELLOW = new Color(255, 255, 200);

    public CartesianGraph(AbstractCartesianGraphPlugin plugin) {
        this(new GraphProperties());
        this.getProperties().put(GraphProperties.PLUGIN, plugin);
        new ResizeAndPackAdapter(plugin, this);
    }

    private CartesianGraph(GraphProperties gp) {
        super(gp);
        this.addExtendedMouseAdapter(this.normalMouseAdapter);
        gp.put(GraphProperties.ZOOMS, this.makeZoomsVector());
        gp.put(GraphProperties.GRAPH_CANVAS, this);
        gp.put(GraphProperties.V_TITLE_STRING, "f(x)");
        gp.put(GraphProperties.H_TITLE_STRING, "x");
    }

    protected Vector makeZoomsVector() {
        Vector<Zoom> z = new Vector<Zoom>();
        z.add(new StaticZoom("Standard Zoom", new View(new Range(-6.0, 6.0, 1.0), new Range(-6.0, 6.0, 1.0))));
        z.add(new StaticZoom("Quadrant I Zoom", new View(new Range(-1.0, 11.0, 1.0), new Range(-1.0, 11.0, 1.0))));
        z.add(new StaticZoom("Trig Zoom", new View(new Range(Math.PI * -4, Math.PI * 4, 1.5707963267948966), new Range(-4.0, 4.0, 1.0))));
        z.add(new FitZoom());
        z.add(new SquareZoom());
        return z;
    }

    public void setDefaultGraphElements() {
        boolean b = true;
        this.properties.initDefault(GraphProperties.H_AXIS, b);
        this.properties.initDefault(GraphProperties.H_GRID, b);
        this.properties.initDefault(GraphProperties.H_SCALE, b);
        this.properties.initDefault(GraphProperties.V_AXIS, b);
        this.properties.initDefault(GraphProperties.V_GRID, b);
        this.properties.initDefault(GraphProperties.V_SCALE, b);
        this.properties.initDefault(GraphProperties.V_TITLE, b);
        this.properties.initDefault(GraphProperties.H_TITLE, b);
        this.properties.initDefault(GraphProperties.V_LABEL, b);
        this.properties.initDefault(GraphProperties.H_LABEL, b);
        this.properties.initDefault(GraphProperties.TRACE, !b);
        this.properties.initDefault(GraphProperties.SHOW_CONCAVITY, !b);
        this.properties.initDefault(GraphProperties.SHOW_MONOTONICITY, !b);
        this.properties.initDefault(GraphProperties.THICK_GRAPH, !b);
        this.properties.initDefault(GraphProperties.INTERACTIVE_ZOOM, b);
    }

    public void setDefaultColors() {
        this.properties.initDefault(GraphProperties.H_AXIS_COLOR, Color.red);
        this.properties.initDefault(GraphProperties.V_AXIS_COLOR, Color.red);
        this.properties.initDefault(GraphProperties.H_GRID_COLOR, Color.lightGray);
        this.properties.initDefault(GraphProperties.V_GRID_COLOR, Color.lightGray);
        this.properties.initDefault(GraphProperties.H_SCALE_COLOR, Color.blue);
        this.properties.initDefault(GraphProperties.V_SCALE_COLOR, Color.blue);
        this.properties.initDefault(GraphProperties.V_LABEL_COLOR, Color.black);
        this.properties.initDefault(GraphProperties.H_LABEL_COLOR, Color.black);
        this.properties.initDefault(GraphProperties.V_TITLE_COLOR, Color.black);
        this.properties.initDefault(GraphProperties.H_TITLE_COLOR, Color.black);
        this.properties.initDefault(GraphProperties.INCREASING_COLOR, new Color(255, 128, 128));
        this.properties.initDefault(GraphProperties.DECREASING_COLOR, new Color(128, 128, 255));
        this.properties.initDefault(GraphProperties.CONCAVITY_COLOR, new Color(128, 128, 128));
        this.setBackground(Color.white);
    }

    protected void setDefaultFonts() {
        this.properties.initDefault(GraphProperties.AXES_LABEL_FONTS, new Font("SansSerif", 0, 9));
    }

    protected void setDefaultView() {
        this.properties.initDefault(GraphProperties.VIEW, new View(new Range(-6.0, 6.0, 1.0), new Range(-6.0, 6.0, 1.0)));
        this.properties.initDefault(GraphProperties.TRACE, false);
        this.properties.revertToDefault(GraphProperties.VIEW);
    }

    public double screenXtoCartesian(int x) {
        return this.getXRange().getWidth() * (double)x / (double)(this.getWidth() - 1) + this.getXRange().getMin();
    }

    public double screenYtoCartesian(int y) {
        return -this.getYRange().getWidth() * (double)y / (double)(this.getHeight() - 1) + this.getYRange().getMax();
    }

    protected void setXYRange(Range x, Range y) {
        View view = this.properties.getViewProperty(GraphProperties.VIEW);
        int n = view.getDimension();
        if (n == 2) {
            view = new View(x, y);
        } else if (view.getDimension() > 2) {
            Range[] r = new Range[n];
            r[0] = x;
            r[1] = y;
            int i = 2;
            while (i < n) {
                r[i] = view.getRange(i);
                ++i;
            }
            view = new View(r);
        }
        this.properties.put(GraphProperties.VIEW, view);
    }

    public Range getXRange() {
        View view = (View)this.properties.get(GraphProperties.VIEW);
        return view.getRange(0);
    }

    public Range getYRange() {
        View view = (View)this.properties.get(GraphProperties.VIEW);
        return view.getRange(1);
    }

    public int cartesianXtoScreen(double x) {
        if (Double.isNaN(x)) {
            return Integer.MAX_VALUE;
        }
        x = (x - this.getXRange().getMin()) / this.getXRange().getWidth() * (double)(this.getWidth() - 1) + 0.5;
        return (int)x;
    }

    public int cartesianYtoScreen(double y) {
        if (Double.isNaN(y)) {
            return Integer.MAX_VALUE;
        }
        y = (this.getYRange().getMax() - y) / this.getYRange().getWidth() * (double)(this.getHeight() - 1) + 0.5;
        return (int)y;
    }

    public void redrawAll(boolean b) {
        super.redrawAll(b);
        this.drawHighlightRectangle(this.highlightRectangle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void drawHighlightRectangle(Rectangle R) {
        if (R == null) {
            return;
        }
        Graphics2D graphics2D = this.gr;
        synchronized (graphics2D) {
            this.gr.setXORMode(Color.white);
            this.gr.setColor(this.LIGHT_YELLOW);
            this.gr.fillRect(R.x, R.y, R.width, R.height);
            this.gr.setColor(Color.orange);
            this.gr.drawRect(R.x, R.y, R.width, R.height);
            this.gr.setColor(Color.BLACK);
            this.gr.setPaintMode();
        }
    }

    protected void drawAxes() {
        int x = this.cartesianXtoScreen(0.0);
        int y = this.cartesianYtoScreen(0.0);
        if (this.properties.getBooleanProperty(GraphProperties.H_AXIS) && y >= 0 && y <= this.getHeight()) {
            this.gr.setColor(this.properties.getColorProperty(GraphProperties.H_AXIS_COLOR));
            this.gr.drawLine(0, y, this.getWidth(), y);
        }
        if (this.properties.getBooleanProperty(GraphProperties.V_AXIS) && x >= 0 && x <= this.getWidth()) {
            this.gr.setColor(this.properties.getColorProperty(GraphProperties.V_AXIS_COLOR));
            this.gr.drawLine(x, 0, x, this.getHeight());
        }
    }

    protected void drawGrid() {
        int u;
        int j;
        int max;
        int min;
        if (this.properties.getBooleanProperty(GraphProperties.V_GRID)) {
            this.gr.setColor(this.properties.getColorProperty(GraphProperties.V_GRID_COLOR));
            min = (int)(this.screenXtoCartesian(0) / this.getXRange().getScale() - 1.0);
            max = (int)(this.screenXtoCartesian(this.getWidth()) / this.getXRange().getScale() + 1.0);
            j = 0;
            if ((double)(max - min) < (double)this.getWidth() / this.getXRange().getScale() * 3.0) {
                u = min;
                while (u < max) {
                    j = this.cartesianXtoScreen((double)u * this.getXRange().getScale());
                    if (j >= 0 && j <= this.getWidth()) {
                        this.gr.drawLine(j, 0, j, this.getHeight());
                    }
                    ++u;
                }
            } else {
                this.gr.fillRect(0, 0, this.getWidth(), this.getHeight());
            }
        }
        if (this.properties.getBooleanProperty(GraphProperties.H_GRID)) {
            this.gr.setColor(this.properties.getColorProperty(GraphProperties.H_GRID_COLOR));
            min = (int)(this.screenYtoCartesian(this.getHeight()) / this.getYRange().getScale() - 1.0);
            max = (int)(this.screenYtoCartesian(0) / this.getYRange().getScale() + 1.0);
            j = 0;
            if ((double)(max - min) < (double)this.getHeight() / this.getYRange().getScale() * 3.0) {
                u = min;
                while (u < max) {
                    j = this.cartesianYtoScreen((double)u * this.getYRange().getScale());
                    if (j >= 0 && j <= this.getHeight()) {
                        this.gr.drawLine(0, j, this.getWidth(), j);
                    }
                    ++u;
                }
            } else {
                this.gr.fillRect(0, 0, this.getWidth(), this.getHeight());
            }
        }
    }

    protected void drawLabel() {
        Color color;
        int x = this.cartesianXtoScreen(0.0);
        int y = this.cartesianYtoScreen(0.0);
        Font font = new Font("SansSerif", 0, 9);
        this.gr.setFont(font);
        FontMetrics fm = this.gr.getFontMetrics();
        NumberFormat nf = NumberFormat.getInstance();
        nf.setMaximumFractionDigits(4);
        nf.setMinimumFractionDigits(0);
        nf.setGroupingUsed(false);
        Rectangle R = new Rectangle(0, 0, this.getWidth(), this.getHeight());
        if (this.properties.getBooleanProperty(GraphProperties.H_LABEL) && y >= -1 && y <= this.getHeight()) {
            color = this.properties.getColorProperty(GraphProperties.H_LABEL_COLOR);
            Range xRange = this.getXRange();
            int u0 = (int)(this.screenXtoCartesian(this.getWidth() / 2) / xRange.getScale());
            int max = (int)((double)u0 + xRange.getWidth() / this.getXRange().getScale() + 1.0);
            int min = (int)((double)u0 - xRange.getWidth() / this.getXRange().getScale() - 1.0);
            int j = 0;
            if (max - min < 3 * this.getWidth()) {
                int u = min;
                while (u < max) {
                    double xval = (double)u * this.getXRange().getScale();
                    String label = nf.format(xval);
                    int offset = fm.stringWidth(label);
                    j = this.cartesianXtoScreen(xval);
                    if (R.contains(new Rectangle(j - offset / 2 - 1, y + 1, offset, 10))) {
                        this.gr.setColor(this.getBackground());
                        this.gr.fillRect(j - offset / 2 - 1, y + 1, offset, 10);
                        this.gr.setColor(color);
                        this.gr.drawString(label, j - offset / 2, y + 10);
                    }
                    ++u;
                }
            }
        }
        if (this.properties.getBooleanProperty(GraphProperties.V_LABEL) && x >= -1 && x <= this.getWidth()) {
            color = this.properties.getColorProperty(GraphProperties.V_LABEL_COLOR);
            int u0 = (int)(this.screenYtoCartesian(this.getHeight() / 2) / this.getYRange().getScale());
            int max = (int)((double)u0 + this.getYRange().getWidth() / this.getYRange().getScale() + 1.0);
            int min = (int)((double)u0 - this.getYRange().getWidth() / this.getYRange().getScale() - 1.0);
            int j = 0;
            if (max - min < this.getHeight()) {
                int u = min;
                while (u < max) {
                    double yval = (double)u * this.getYRange().getScale();
                    String label = nf.format(yval);
                    int offset = fm.stringWidth(label);
                    j = this.cartesianYtoScreen(yval);
                    if (R.contains(new Rectangle(x + 1, j - 4, offset + 1, 9))) {
                        this.gr.setColor(this.getBackground());
                        this.gr.fillRect(x + 1, j - 5, offset + 1, 10);
                        this.gr.setColor(color);
                        this.gr.drawString(label, x + 1, j + 3);
                    }
                    ++u;
                }
            }
        }
    }

    protected void drawAxesTitle() {
        Color color;
        int offset;
        String label;
        int x = this.cartesianXtoScreen(0.0);
        int y = this.cartesianYtoScreen(0.0);
        Font font = new Font("SansSerif", 0, 9);
        this.gr.setFont(font);
        FontMetrics fm = this.gr.getFontMetrics();
        if (this.properties.getBooleanProperty(GraphProperties.H_TITLE) && y >= -1 && y <= this.getHeight()) {
            label = this.properties.getStringProperty(GraphProperties.H_TITLE_STRING);
            offset = fm.stringWidth(label);
            color = this.properties.getColorProperty(GraphProperties.H_TITLE_COLOR);
            this.gr.setColor(color);
            this.gr.drawString(label, this.getWidth() - offset - 2, y - 1);
        }
        if (this.properties.getBooleanProperty(GraphProperties.V_TITLE) && x >= -1 && x <= this.getWidth()) {
            label = this.properties.getStringProperty(GraphProperties.V_TITLE_STRING);
            offset = fm.stringWidth(label);
            color = this.properties.getColorProperty(GraphProperties.V_TITLE_COLOR);
            this.gr.setColor(color);
            this.gr.drawString(label, x - offset - 1, 10);
        }
    }

    protected void drawScale() {
        int x = this.cartesianXtoScreen(0.0);
        int y = this.cartesianYtoScreen(0.0);
        if (this.properties.getBooleanProperty(GraphProperties.H_SCALE) && y >= -1 && y <= this.getHeight()) {
            Range xRange = this.getXRange();
            this.gr.setColor(this.properties.getColorProperty(GraphProperties.H_SCALE_COLOR));
            int u0 = (int)(this.screenXtoCartesian(this.getWidth() / 2) / xRange.getScale());
            int max = (int)((double)u0 + xRange.getWidth() / xRange.getScale() + 1.0);
            int min = (int)((double)u0 - xRange.getWidth() / xRange.getScale() - 1.0);
            int j = 0;
            if (max - min < this.getWidth()) {
                int u = min;
                while (u < max) {
                    j = this.cartesianXtoScreen((double)u * this.getXRange().getScale());
                    this.gr.drawLine(j, y - 1, j, y + 1);
                    ++u;
                }
            } else {
                this.gr.drawLine(0, y - 1, this.getWidth(), y - 1);
                this.gr.drawLine(0, y, this.getWidth(), y);
                this.gr.drawLine(0, y + 1, this.getWidth(), y + 1);
            }
        }
        if (this.properties.getBooleanProperty(GraphProperties.V_SCALE) && x >= -1 && x <= this.getWidth()) {
            this.gr.setColor(this.properties.getColorProperty(GraphProperties.V_SCALE_COLOR));
            int u0 = (int)(this.screenYtoCartesian(this.getHeight() / 2) / this.getYRange().getScale());
            int max = (int)((double)u0 + this.getYRange().getWidth() / this.getYRange().getScale() + 1.0);
            int min = (int)((double)u0 - this.getYRange().getWidth() / this.getYRange().getScale() - 1.0);
            int j = 0;
            if (max - min < this.getWidth()) {
                int u = min;
                while (u < max) {
                    j = this.cartesianYtoScreen((double)u * this.getYRange().getScale());
                    this.gr.drawLine(x - 1, j, x + 1, j);
                    ++u;
                }
            } else {
                this.gr.drawLine(x - 1, 0, x - 1, this.getHeight());
                this.gr.drawLine(x, 0, x, this.getHeight());
                this.gr.drawLine(x + 1, 0, x + 1, this.getHeight());
            }
        }
    }

    protected void draw(RenderableModel model) {
        BufferedImage buffer = new BufferedImage(this.image.getWidth(), this.image.getHeight(), 2);
        Function F = model.getFunction();
        this.draw(F, model.getColor(), buffer.getGraphics());
        this.gr.drawImage((Image)buffer, 0, 0, null);
        model.setImage(buffer);
    }

    protected void draw(Function F, Color color, Graphics gr, ValueTable vt) {
        int a = 0;
        int b = this.getWidth();
        int n = this.getWidth();
        if (n <= 0) {
            return;
        }
        int[] j = new int[n];
        double y = 0.0;
        int i = a;
        while (i < b) {
            vt.setValue(VariableToken.X_VAR, this.screenXtoCartesian(i));
            y = F.evaluate(vt);
            j[i] = this.cartesianYtoScreen(y);
            gr.setColor(color);
            if (j[i] >= 0 && j[i] <= this.getHeight()) {
                gr.drawLine(i, j[i], i, j[i]);
            }
            ++i;
        }
        if (this.properties.getBooleanProperty(GraphProperties.SHOW_MONOTONICITY) || this.properties.getBooleanProperty(GraphProperties.SHOW_CONCAVITY)) {
            this.drawMonoticityAndConcavity(F, j, a, b, vt, color);
        }
        int thickness = this.properties.getBooleanProperty(GraphProperties.THICK_GRAPH) ? 3 : 1;
        int i2 = a;
        while (i2 < b - 1) {
            int x1 = i2 + 1;
            int y1 = j[x1];
            int x0 = i2;
            int y0 = j[x0];
            if (Math.abs(y1 - y0) < this.getHeight() * 5 && Math.abs(y1) < this.getHeight() * 5) {
                if (y0 >= 0 && y0 < this.getHeight()) {
                    this.drawThickLine(gr, x0, y0, x1, y1, color, thickness);
                } else if (y1 >= 0 && y1 < this.getHeight()) {
                    this.drawThickLine(gr, x0, y0, x1, y1, color, thickness);
                }
            }
            ++i2;
        }
    }

    protected void draw(Function F, Color color, Graphics gr) {
        this.draw(F, color, gr, new ValueTable());
    }

    private void drawMonoticityAndConcavity(Function F, int[] j, int a, int b, ValueTable vt, Color color) {
        int k = 10;
        double dy = 0.0;
        double d2y = 0.0;
        Color up = this.properties.getColorProperty(GraphProperties.INCREASING_COLOR);
        Color down = this.properties.getColorProperty(GraphProperties.DECREASING_COLOR);
        Color concavity = this.properties.getColorProperty(GraphProperties.CONCAVITY_COLOR);
        Function D1 = F.derivative(VariableToken.X_VAR);
        Function D2 = D1.derivative(VariableToken.X_VAR);
        int i = a;
        while (i < b - 1) {
            int x1 = i + 1;
            int y1 = j[x1];
            int x0 = i;
            int y0 = j[x0];
            if (Math.abs(y1 - y0) < this.getHeight() * 5 && Math.abs(y1) < this.getHeight() * 5) {
                vt.setValue(VariableToken.X_VAR, this.screenXtoCartesian(i));
                dy = D1.evaluate(vt);
                d2y = D2.evaluate(vt);
                if (!Double.isNaN(dy)) {
                    if (this.properties.getBooleanProperty(GraphProperties.SHOW_MONOTONICITY) && y0 >= 0 && y0 < this.getHeight()) {
                        Color c = null;
                        if (dy > 0.0) {
                            c = up;
                            this.gr.setColor(c);
                        } else if (dy < 0.0) {
                            c = down;
                            this.gr.setColor(c);
                        } else {
                            c = color;
                            this.gr.setColor(c);
                        }
                        this.drawThickLine(this.gr, x0, y0, x1, y1, c, 7);
                    }
                    if (this.properties.getBooleanProperty(GraphProperties.SHOW_CONCAVITY) && y0 >= 0 && y0 < this.getHeight()) {
                        double t = Math.atan(-1.0 / dy);
                        if (dy * d2y > 0.0) {
                            t += Math.PI;
                        }
                        if (d2y != 0.0) {
                            this.drawThickLine(this.gr, x0, y0, (int)((double)x0 + (double)k * Math.cos(t)), (int)((double)y0 - (double)k * Math.sin(t)), concavity, 3);
                        }
                    }
                }
            }
            ++i;
        }
    }

    protected void drawThickLine(Graphics g, int x0, int y0, int x1, int y1, Color c, int thickness) {
        if (thickness < 0) {
            return;
        }
        g.setColor(c);
        if (thickness == 1) {
            g.drawLine(x0, y0, x1, y1);
            return;
        }
        int dx = Math.abs(x0 - x1);
        int dy = Math.abs(y0 - y1);
        if (dx == 0) {
            g.fillRect(x0 - thickness / 2, Math.min(y0, y1) - thickness / 2, thickness, dy + thickness);
            return;
        }
        if (dy == 0) {
            g.fillRect(Math.min(x0, x1) - thickness / 2, y0 - thickness / 2, dx + thickness, thickness);
            return;
        }
        int x2 = (x0 + x1) / 2;
        int y2 = (y0 + y1) / 2;
        if (dx == 1) {
            this.drawThickLine(g, x0, y0, x0, y2, c, thickness);
            this.drawThickLine(g, x1, y2, x1, y1, c, thickness);
            return;
        }
        if (dy == 1) {
            this.drawThickLine(g, x0, y0, x2, y0, c, thickness);
            this.drawThickLine(g, x2, y1, x1, y1, c, thickness);
            return;
        }
        this.drawThickLine(g, x0, y0, x2, y2, c, thickness);
        this.drawThickLine(g, x2, y2, x1, y1, c, thickness);
    }

    public void update(Observable observable, Object obj) {
        String key = (String)obj;
        if (key == null) {
            return;
        }
        if (key.equals(GraphProperties.SCREEN_DIMENSION)) {
            this.resetSize();
            this.redrawAll(false);
        }
        if (key.equals(GraphProperties.VIEW)) {
            this.traceMouseAdapter.reset();
            this.redrawAll(false);
        }
        if (key.equals(GraphProperties.TRACE)) {
            this.removeExtendedMouseAdapter(this.normalMouseAdapter);
            this.removeExtendedMouseAdapter(this.traceMouseAdapter);
            this.traceMouseAdapter.reset();
            boolean trace = this.properties.getBooleanProperty(key);
            if (trace) {
                this.addExtendedMouseAdapter(this.traceMouseAdapter);
            } else {
                this.addExtendedMouseAdapter(this.normalMouseAdapter);
            }
        }
        if (key.equals(GraphProperties.H_GRID) || key.equals(GraphProperties.V_GRID) || key.equals(GraphProperties.H_AXIS) || key.equals(GraphProperties.V_AXIS) || key.equals(GraphProperties.H_LABEL) || key.equals(GraphProperties.V_LABEL) || key.equals(GraphProperties.H_SCALE) || key.equals(GraphProperties.V_SCALE) || key.equals(GraphProperties.H_TITLE) || key.equals(GraphProperties.V_TITLE) || key.equals(GraphProperties.SHOW_MONOTONICITY) || key.equals(GraphProperties.SHOW_CONCAVITY) || key.equals(GraphProperties.THICK_GRAPH)) {
            this.redrawAll();
        }
    }

    public void setCoordinatePanel(CoordinatePanel c) {
        this.coordinatePanel = c;
    }

    private void setCoordinates(double x, double y) {
        DecimalFormat nf = (DecimalFormat)NumberFormat.getInstance();
        nf.setMaximumFractionDigits(11);
        nf.setMinimumFractionDigits(0);
        nf.setGroupingUsed(false);
        String hlabel = this.properties.getStringProperty(GraphProperties.H_TITLE_STRING);
        String vlabel = this.properties.getStringProperty(GraphProperties.V_TITLE_STRING);
        this.labels[0] = String.valueOf(hlabel) + "=" + nf.format(x);
        this.labels[1] = String.valueOf(vlabel) + "=" + nf.format(y);
        if (this.coordinatePanel != null) {
            this.coordinatePanel.setLabels(this.labels);
        }
    }

    private void addExtendedMouseAdapter(ExtendedMouseAdapter a) {
        this.addMouseMotionListener(a);
        this.addMouseListener(a);
    }

    protected void removeExtendedMouseAdapter(ExtendedMouseAdapter a) {
        this.removeMouseMotionListener(a);
        this.removeMouseListener(a);
    }

    public Zoom zoomWrapper(Zoom z) {
        return z;
    }

    protected class FitZoom
    extends Zoom {
        private ValueTable vt = new ValueTable();

        protected FitZoom() {
        }

        public View getView() {
            Range xRange = CartesianGraph.this.getXRange();
            Range yRange = CartesianGraph.this.getYRange();
            ModelList modelList = CartesianGraph.this.getModelList();
            double max = Double.MIN_VALUE;
            double min = Double.MAX_VALUE;
            double val = 0.0;
            int i = 0;
            while (i < modelList.getSize()) {
                Function f = modelList.getModelAt(i).getFunction();
                int j = 0;
                while (j < CartesianGraph.this.getWidth()) {
                    this.vt.setValue(VariableToken.X_VAR, CartesianGraph.this.screenXtoCartesian(j));
                    val = f.evaluate(this.vt);
                    if (val > max) {
                        max = val;
                    }
                    if (val < min) {
                        min = val;
                    }
                    ++j;
                }
                ++i;
            }
            View newView = null;
            try {
                newView = new View(xRange, new Range(min, max, yRange.getScale()));
            }
            catch (IllegalArgumentException e) {
                return new View(xRange, yRange);
            }
            return newView;
        }

        public String getName() {
            return "Fit Zoom";
        }
    }

    protected class SquareZoom
    extends Zoom {
        protected SquareZoom() {
        }

        public View getView() {
            Range xRange = CartesianGraph.this.getXRange();
            Range yRange = CartesianGraph.this.getYRange();
            double height = xRange.getWidth() / (double)CartesianGraph.this.getWidth() * (double)CartesianGraph.this.getHeight();
            double min = yRange.getCenter() - height / 2.0;
            double max = yRange.getCenter() + height / 2.0;
            return new View(xRange, new Range(min, max, yRange.getScale()));
        }

        public String getName() {
            return "Square Zoom";
        }
    }

    private class TangentMouseAdapter
    extends TraceMouseAdapter {
        TangentMouseAdapter() {
        }
    }

    private class TraceMouseAdapter
    extends ExtendedMouseAdapter {
        protected static final int BOGUS = -20;
        protected int n = 0;
        protected int x = -20;
        protected int y = -20;

        TraceMouseAdapter() {
        }

        public void mouseMoved(MouseEvent e) {
            double cx = CartesianGraph.this.screenXtoCartesian(e.getX());
            double cy = CartesianGraph.this.screenYtoCartesian(e.getY());
            try {
                Function f = CartesianGraph.this.getModelList().getModelAt(this.n).getFunction();
                this.vt.setValue(VariableToken.X_VAR, cx);
                cy = f.evaluate(this.vt);
                if (!Double.isNaN(this.y)) {
                    int sy = CartesianGraph.this.cartesianYtoScreen(cy);
                    if (sy >= 0 && sy <= CartesianGraph.this.getHeight()) {
                        this.moveTraceTo(e.getX(), sy);
                    } else {
                        this.moveTraceTo(e.getX(), -20);
                    }
                } else {
                    this.moveTraceTo(e.getX(), -20);
                }
            }
            catch (Exception exception) {
                this.moveTraceTo(e.getX(), e.getY());
            }
            CartesianGraph.this.setCoordinates(cx, cy);
        }

        public void mouseClicked(MouseEvent e) {
            this.n = (this.n + 1) % CartesianGraph.this.getModelList().getSize();
            this.mouseMoved(e);
        }

        public void mouseEntered(MouseEvent e) {
            this.mouseMoved(e);
        }

        public void mouseExited(MouseEvent e) {
            this.reset();
        }

        private void moveTraceTo(int nx, int ny) {
            this.drawTrace(this.x, this.y);
            this.drawTrace(nx, ny);
            this.x = nx;
            this.y = ny;
            CartesianGraph.this.repaint();
        }

        private void drawTrace(int x, int y) {
            CartesianGraph.this.gr.setXORMode(Color.white);
            CartesianGraph.this.gr.setColor(Color.orange);
            CartesianGraph.this.gr.drawRect(x - 4, y - 4, 8, 8);
            CartesianGraph.this.gr.drawLine(0, y, CartesianGraph.this.getWidth(), y);
            CartesianGraph.this.gr.drawLine(x, 0, x, CartesianGraph.this.getHeight());
            CartesianGraph.this.gr.setPaintMode();
        }

        public void reset() {
            this.moveTraceTo(-20, -20);
        }
    }

    private class NormalMouseAdapter
    extends ExtendedMouseAdapter {
        Point p1 = null;
        Point p2 = null;
        Rectangle R = null;

        NormalMouseAdapter() {
        }

        public void mouseMoved(MouseEvent e) {
            CartesianGraph.this.setCoordinates(CartesianGraph.this.screenXtoCartesian(e.getX()), CartesianGraph.this.screenYtoCartesian(e.getY()));
        }

        public void mousePressed(MouseEvent e) {
            if (e.getButton() != 1) {
                return;
            }
            this.p1 = e.getPoint();
            if (this.R != null) {
                CartesianGraph.this.drawHighlightRectangle(this.R);
                CartesianGraph.this.repaint();
            }
            this.R = null;
            CartesianGraph.this.highlightRectangle = null;
        }

        public void mouseDragged(MouseEvent e) {
            if (this.p1 == null) {
                return;
            }
            if (this.R != null) {
                CartesianGraph.this.drawHighlightRectangle(this.R);
            }
            this.p2 = e.getPoint();
            int x1 = Math.min(this.p1.x, this.p2.x);
            int x2 = Math.max(this.p1.x, this.p2.x);
            int y1 = Math.min(this.p1.y, this.p2.y);
            int y2 = Math.max(this.p1.y, this.p2.y);
            this.R = new Rectangle(x1, y1, x2 - x1, y2 - y1);
            CartesianGraph.this.drawHighlightRectangle(this.R);
            CartesianGraph.this.repaint();
        }

        public void mouseReleased(MouseEvent e) {
            CartesianGraph.this.highlightRectangle = this.R;
            if (this.R != null) {
                this.applyBoxZoom(new Point((int)this.R.getCenterX(), (int)this.R.getCenterY()));
            }
        }

        private void applyBoxZoom(Point p) {
            double ymin;
            double xmax;
            double ymax;
            double xmin;
            Rectangle rect = CartesianGraph.this.highlightRectangle;
            if (rect == null) {
                return;
            }
            double xscl = CartesianGraph.this.getXRange().getScale();
            double yscl = CartesianGraph.this.getYRange().getScale();
            if (rect.contains(p)) {
                xmin = CartesianGraph.this.screenXtoCartesian(rect.x);
                ymax = CartesianGraph.this.screenYtoCartesian(rect.y);
                xmax = CartesianGraph.this.screenXtoCartesian(rect.x + rect.width);
                ymin = CartesianGraph.this.screenYtoCartesian(rect.y + rect.height);
            } else {
                xmin = CartesianGraph.this.screenXtoCartesian(-rect.x * CartesianGraph.this.getWidth() / rect.width);
                ymax = CartesianGraph.this.screenYtoCartesian(-rect.y * CartesianGraph.this.getHeight() / rect.height);
                xmax = CartesianGraph.this.screenXtoCartesian((CartesianGraph.this.getWidth() - rect.x) * CartesianGraph.this.getWidth() / rect.width);
                ymin = CartesianGraph.this.screenYtoCartesian((CartesianGraph.this.getHeight() - rect.y) * CartesianGraph.this.getHeight() / rect.height);
            }
            CartesianGraph.this.setXYRange(new Range(xmin, xmax, xscl), new Range(ymin, ymax, yscl));
            this.R = null;
            CartesianGraph.this.highlightRectangle = null;
            CartesianGraph.this.redrawAll();
        }

        private void applyTranslationZoom(Point p) {
            double x = CartesianGraph.this.screenXtoCartesian(p.x);
            double y = CartesianGraph.this.screenYtoCartesian(p.y);
            double factor = 1.0;
            double min = x - factor * CartesianGraph.this.getXRange().getWidth() / 2.0;
            double max = x + factor * CartesianGraph.this.getXRange().getWidth() / 2.0;
            Range xRange = new Range(min, max, CartesianGraph.this.getXRange().getScale());
            min = y - factor * CartesianGraph.this.getYRange().getWidth() / 2.0;
            max = y + factor * CartesianGraph.this.getYRange().getWidth() / 2.0;
            Range yRange = new Range(min, max, CartesianGraph.this.getYRange().getScale());
            CartesianGraph.this.setXYRange(xRange, yRange);
        }

        public void mouseClicked(MouseEvent e) {
            if (!CartesianGraph.this.properties.getBooleanProperty(GraphProperties.INTERACTIVE_ZOOM)) {
                return;
            }
            if (e.getClickCount() == 2 && e.getButton() == 3) {
                if (this.R == null) {
                    this.applyTranslationZoom(e.getPoint());
                } else {
                    this.applyBoxZoom(e.getPoint());
                }
            }
        }
    }
}

