/*
 * Decompiled with CFR 0.152.
 */
package net.gcalc.plugin.plane;

import java.awt.event.ActionEvent;
import javax.swing.JPanel;
import net.gcalc.calc.math.functions.Function;
import net.gcalc.calc.math.functions.FunctionFactory;
import net.gcalc.calc.models.ColoredModel;
import net.gcalc.calc.models.Model;
import net.gcalc.calc.parser.BadSyntaxException;
import net.gcalc.plugin.gui.InputPanel;
import net.gcalc.plugin.gui.TextInputPanel;
import net.gcalc.plugin.plane.CartesianGraphPlugin;
import net.gcalc.plugin.plane.graph.ParametricGraph;
import net.gcalc.plugin.plane.gui.FlagPanel;
import net.gcalc.plugin.plane.gui.ModelListPanel;
import net.gcalc.plugin.properties.GraphProperties;

public class ParametricGraphPlugin
extends CartesianGraphPlugin {
    public ParametricGraphPlugin() {
        this.graph = new ParametricGraph(this);
    }

    protected JPanel makeFlagPanel() {
        String[] stringArray = new String[12];
        stringArray[1] = GraphProperties.THICK_GRAPH;
        stringArray[2] = GraphProperties.H_GRID;
        stringArray[3] = GraphProperties.V_GRID;
        stringArray[4] = GraphProperties.H_AXIS;
        stringArray[5] = GraphProperties.V_AXIS;
        stringArray[6] = GraphProperties.H_LABEL;
        stringArray[7] = GraphProperties.V_LABEL;
        stringArray[8] = GraphProperties.H_SCALE;
        stringArray[9] = GraphProperties.V_SCALE;
        stringArray[10] = GraphProperties.H_TITLE;
        stringArray[11] = GraphProperties.V_TITLE;
        return new FlagPanel(this.graph.getProperties(), 6, 2, stringArray);
    }

    protected InputPanel getInputPanel() {
        return new TextInputPanel("Parametric System", this.getModelLabels(), null);
    }

    protected JPanel makeModelListPanel() {
        return new ModelListPanel(this.graph.getProperties(), true, true);
    }

    public String getDescription() {
        return "<p>Draws a parametric system on the plane</p>";
    }

    public String getPluginName() {
        return "Parametric Graph Plugin";
    }

    public void actionPerformed(ActionEvent event) {
        if (event.getSource() == this.ip) {
            String s1 = this.ip.getValues()[0].trim();
            String s2 = this.ip.getValues()[1].trim();
            Function f = null;
            Function g = null;
            try {
                f = FunctionFactory.getFunction(s1);
            }
            catch (BadSyntaxException e) {
                this.popupMessageDialog("Bad Syntax in '" + s1 + "'!\n" + e.getMessage(), 0);
                return;
            }
            try {
                g = FunctionFactory.getFunction(s2);
            }
            catch (BadSyntaxException e) {
                this.popupMessageDialog("Bad Syntax in '" + s2 + "'!\n" + e.getMessage(), 0);
                return;
            }
            this.drawGraph(new ColoredModel(new Function[]{f, g}, new String[]{s1, s2}, this.getNewColor()));
            this.statusBar.setText("Graphing: (" + s1 + "," + s2 + ")");
        }
    }

    protected String[] getModelLabels() {
        return new String[]{"x(t)=", "y(t)="};
    }

    protected void drawGraph(ColoredModel model) {
        this.graph.draw((Model)model);
        this.ip.addCurrentValuesToHistory();
        this.ip.clear();
    }
}

