/*
 * Decompiled with CFR 0.152.
 */
package net.gcalc.plugin.plane;

import java.awt.event.ActionEvent;
import javax.swing.JPanel;
import net.gcalc.calc.math.functions.Function;
import net.gcalc.calc.math.functions.FunctionFactory;
import net.gcalc.calc.models.RenderableModel;
import net.gcalc.calc.parser.BadSyntaxException;
import net.gcalc.plugin.gui.InputPanel;
import net.gcalc.plugin.gui.TextInputPanel;
import net.gcalc.plugin.plane.CartesianGraphPlugin;
import net.gcalc.plugin.plane.graph.DirectionFieldGraph;
import net.gcalc.plugin.plane.gui.FlagPanel;
import net.gcalc.plugin.plane.gui.ModelListPanel;
import net.gcalc.plugin.properties.GraphProperties;

public class DirectionFieldPlugin
extends CartesianGraphPlugin {
    public DirectionFieldPlugin() {
        this.graph = new DirectionFieldGraph(this);
    }

    protected JPanel makeFlagPanel() {
        return new FlagPanel(this.graph.getProperties(), 6, 2, new String[]{GraphProperties.H_GRID, GraphProperties.V_GRID, GraphProperties.H_AXIS, GraphProperties.V_AXIS, GraphProperties.H_LABEL, GraphProperties.V_LABEL, GraphProperties.H_SCALE, GraphProperties.V_SCALE});
    }

    protected InputPanel getInputPanel() {
        return new TextInputPanel("Direction Field", this.getModelLabels(), null);
    }

    protected JPanel makeModelListPanel() {
        return new ModelListPanel(this.graph.getProperties(), false, true);
    }

    protected String[] getModelLabels() {
        return new String[]{"dx/dt=f(x,y)=", "dy/dt=g(x,y)="};
    }

    public String getDescription() {
        return "<p>Draws the direction field given by dx/dt=f(x,y) and dy/dt=g(x,y).</p><p>Useful for investigating planar autonomous systems.</p>";
    }

    public String getPluginName() {
        return "Direction Field Plugin";
    }

    public void actionPerformed(ActionEvent event) {
        if (event.getSource() == this.ip) {
            String s1 = this.ip.getValues()[0].trim();
            String s2 = this.ip.getValues()[1].trim();
            Function f = null;
            Function g = null;
            try {
                f = FunctionFactory.getFunction(s1);
            }
            catch (BadSyntaxException e) {
                this.popupMessageDialog("Bad Syntax in '" + s1 + "'!\n" + e.getMessage(), 0);
                return;
            }
            try {
                g = FunctionFactory.getFunction(s2);
            }
            catch (BadSyntaxException e) {
                this.popupMessageDialog("Bad Syntax in '" + s2 + "'!\n" + e.getMessage(), 0);
                return;
            }
            if (f != null) {
                ((DirectionFieldGraph)this.graph).drawSystem(new RenderableModel(new Function[]{f, g}, new String[]{s1, s2}));
            }
        }
    }
}

