/*
 * Decompiled with CFR 0.152.
 */
package net.gcalc.plugin.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import javax.swing.Box;
import javax.swing.JPanel;
import net.gcalc.plugin.gui.ColorPanel;
import net.gcalc.plugin.gui.PalettePanel;

public class SimpleColorChooser
extends JPanel {
    private PalettePanel palette;
    private ColorPanel s1;
    private ColorPanel s2;

    public SimpleColorChooser() {
        this(Color.black);
    }

    public SimpleColorChooser(Color firstColor) {
        this(firstColor, 200, 100);
    }

    public SimpleColorChooser(Color firstColor, int w, int h) {
        Box hbox = Box.createHorizontalBox();
        Box box = Box.createVerticalBox();
        this.s1 = new ColorPanel(Color.white);
        box.add(this.s1);
        this.s2 = new ColorPanel(firstColor);
        box.add(this.s2);
        this.palette = new PalettePanel();
        hbox.add(this.palette);
        hbox.add(box);
        this.s1.setPreferredSize(new Dimension(w / 3, h / 2));
        this.s2.setPreferredSize(new Dimension(w / 3, h / 2));
        this.palette.setPreferredSize(new Dimension(2 * w / 3, h));
        this.add(hbox);
        this.palette.addMouseListener(new MouseAdapter(){

            public void mouseEntered(MouseEvent e) {
                SimpleColorChooser.this.handleMouseEvent(SimpleColorChooser.this.s1, e);
            }

            public void mouseClicked(MouseEvent e) {
                SimpleColorChooser.this.handleMouseEvent(SimpleColorChooser.this.s2, e);
                SimpleColorChooser.this.palette.setCoordinates(e.getX(), e.getY());
            }
        });
        this.palette.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseMoved(MouseEvent e) {
                SimpleColorChooser.this.handleMouseEvent(SimpleColorChooser.this.s1, e);
            }

            public void mouseDragged(MouseEvent e) {
                SimpleColorChooser.this.handleMouseEvent(SimpleColorChooser.this.s1, e);
            }
        });
    }

    protected void handleMouseEvent(ColorPanel s, MouseEvent e) {
        int x = e.getX();
        int y = e.getY();
        s.setColor(this.palette.getColorAt(x, y));
    }

    public Color getColor() {
        return this.s2.getColor();
    }

    public void setColor(Color c) {
        this.s2.setColor(c);
        this.palette.clearCursors();
    }
}

