/*
 * Decompiled with CFR 0.152.
 */
package net.gcalc.calc.parser;

import java.util.Stack;
import java.util.Vector;
import net.gcalc.calc.parser.BadSyntaxException;
import net.gcalc.calc.parser.CalcTokenizer;
import net.gcalc.calc.parser.ParseTree;
import net.gcalc.calc.parser.Token;

public class CalcParser {
    private static final Token COMMA = new Token(",", 2);
    private static final Token SEMICOLON = new Token(";", 2);

    /*
     * Unable to fully structure code
     */
    public static void main(String[] args) {
        block5: {
            sb = new StringBuffer();
            i = 0;
            while (i < args.length) {
                sb.append(args[i]);
                sb.append(" ");
                ++i;
            }
            try {
                PT = CalcParser.parse(sb.toString());
                t = System.currentTimeMillis();
                n = 0.0;
                i = 0;
                while ((double)i < n) {
                    PT = CalcParser.parse(sb.toString());
                    ++i;
                }
                System.out.println((double)(System.currentTimeMillis() - t) / n);
                ParseTree.print(PT);
                System.out.println(PT.toInfix());
                System.out.println(PT.getVars());
                break block5;
            }
            catch (BadSyntaxException e) {
                System.err.println("*** " + e);
                System.err.println("  " + sb.toString());
                if (e.getPos() < 0) break block5;
                i = 0;
                ** while (i < e.getPos() + 2)
            }
lbl-1000:
            // 1 sources

            {
                System.err.print(' ');
                ++i;
                continue;
            }
lbl33:
            // 1 sources

            System.err.println("^");
        }
    }

    public static ParseTree parse(String s) throws BadSyntaxException {
        if (s == null) {
            throw new BadSyntaxException("Cannot parse null string!");
        }
        if (s.trim().length() == 0) {
            throw new BadSyntaxException("Cannot parse empty string!");
        }
        ParseTree p = CalcParser.parseSemiColon(new CalcTokenizer(s).tokenize());
        p.setID(s);
        return p;
    }

    private static ParseTree parseAtom(Vector tokens) throws BadSyntaxException {
        boolean DEBUG = false;
        if (tokens.size() == 0) {
            throw new BadSyntaxException("Encountered empty token vector.");
        }
        Stack<ParseTree> pf = new Stack<ParseTree>();
        Stack<Token> op = new Stack<Token>();
        Token lastTk = null;
        float precedence = -1.0f;
        int cursor = 0;
        while (cursor < tokens.size()) {
            Token tk = (Token)tokens.elementAt(cursor);
            if (DEBUG) {
                System.out.println(tk);
            }
            if (DEBUG) {
                System.out.println("parseatom1: " + cursor + "\t" + tk);
            }
            if (tk.isMinusSign() && (pf.isEmpty() || lastTk.isOperation())) {
                tk = new Token("neg", tk);
            }
            if (tk.isPlusSign() && (pf.isEmpty() || lastTk.isOperation())) {
                tk = new Token("id", tk);
            }
            if (lastTk != null && CalcParser.impliedMultiplication(lastTk, tk)) {
                tk = new Token("*", 1, tk.getPos());
                --cursor;
            }
            precedence = tk.precedence();
            if (DEBUG) {
                System.out.println("parseatom2: " + pf + "\t" + op);
            }
            if (tk.isNumber()) {
                pf.push(new ParseTree(tk, null));
            } else if (tk.isLeftParen()) {
                Token peek;
                int leftParenPos = tk.getPos();
                Vector<Token> tokenBetweenParens = new Vector<Token>();
                ++cursor;
                int level = 1;
                while (level > 0) {
                    if (cursor == tokens.size()) {
                        throw new BadSyntaxException("Unmatched left parenthesis", leftParenPos);
                    }
                    tk = (Token)tokens.elementAt(cursor);
                    if (tk.isLeftParen()) {
                        ++level;
                    } else if (tk.isRightParen()) {
                        --level;
                    }
                    if (level > 0) {
                        tokenBetweenParens.add(tk);
                    }
                    if (level == 0 && tk.getPos() - leftParenPos == 1) {
                        throw new BadSyntaxException("Empty parentheses", leftParenPos);
                    }
                    ++cursor;
                }
                ParseTree pt = CalcParser.parseCommaList(tokenBetweenParens);
                if (!(op.isEmpty() || (peek = (Token)op.peek()).isBinary() || peek.getName().equals("neg"))) {
                    pt = new ParseTree((Token)op.pop(), pt.getArgs());
                }
                pt = ParseTree.removeUnnecessaryComma(pt);
                pf.push(pt);
                tk = (Token)tokens.elementAt(--cursor);
            } else {
                if (tk.isRightParen()) {
                    throw new BadSyntaxException("Unmatched right parenthesis", tk.getPos());
                }
                if (op.isEmpty()) {
                    op.push(tk);
                } else if (tk.isEqualSign()) {
                    while (!op.empty() && ((Token)op.peek()).precedence() < precedence) {
                        CalcParser.safeOpPush(pf, op);
                    }
                    op.push(tk);
                } else if (tk.isCaret()) {
                    Token peek = (Token)op.peek();
                    while (!op.empty() && peek.precedence() < precedence && !peek.getName().equals("neg")) {
                        CalcParser.safeOpPush(pf, op);
                    }
                    op.push(tk);
                } else if (tk.isBinary()) {
                    while (!op.empty() && ((Token)op.peek()).precedence() <= precedence) {
                        CalcParser.safeOpPush(pf, op);
                    }
                    op.push(tk);
                } else {
                    Token peek = (Token)op.peek();
                    while (!op.empty() && peek.precedence() < precedence) {
                        CalcParser.safeOpPush(pf, op);
                    }
                    op.push(tk);
                }
            }
            lastTk = tk;
            ++cursor;
        }
        while (!op.empty()) {
            CalcParser.safeOpPush(pf, op);
        }
        return (ParseTree)pf.pop();
    }

    private static boolean impliedMultiplication(Token lastTk, Token tk) {
        return lastTk.isRightParen() && tk.isLeftParen() || lastTk.isNumber() && tk.isLeftParen() || lastTk.isRightParen() && tk.isNumber() || lastTk.isRightParen() && tk.isFunction() || lastTk.isNumber() && tk.isFunction() || lastTk.isNumber() && tk.isNumber();
    }

    private static void safeOpPush(Stack pf, Stack op) throws BadSyntaxException {
        boolean DEBUG = false;
        Token tk = (Token)op.pop();
        Vector<ParseTree> v = new Vector<ParseTree>();
        if (tk.isBinary()) {
            if (pf.size() >= 2) {
                ParseTree arg2 = (ParseTree)pf.pop();
                ParseTree arg1 = (ParseTree)pf.pop();
                if (arg1.getRoot().getPos() > tk.getPos() && arg2.getRoot().getPos() > tk.getPos()) {
                    CalcParser.cannotFindOperands(tk);
                }
                if (arg1.getRoot().getPos() < tk.getPos() && arg2.getRoot().getPos() < tk.getPos()) {
                    CalcParser.cannotFindOperands(tk);
                }
                v.add(arg1);
                v.add(arg2);
            } else {
                CalcParser.cannotFindOperands(tk);
            }
        } else if (pf.size() >= 1) {
            v.add((ParseTree)pf.pop());
        } else {
            CalcParser.cannotFindOperands(tk);
        }
        pf.push(new ParseTree(tk, v));
        if (DEBUG) {
            System.out.println("safepush: " + tk + "\t" + pf + "\t" + op);
        }
    }

    private static void cannotFindOperands(Token tk) throws BadSyntaxException {
        throw new BadSyntaxException("Cannot find operand(s) for '" + tk + "'", tk.getPos());
    }

    private static ParseTree parseCommaList(Vector tokens) throws BadSyntaxException {
        Vector commaList = CalcParser.getCommaList(tokens);
        if (commaList.size() == 0) {
            throw new BadSyntaxException("Empty parentheses", 0);
        }
        int i = 0;
        while (i < commaList.size()) {
            commaList.setElementAt(CalcParser.parseAtom((Vector)commaList.elementAt(i)), i);
            ++i;
        }
        return new ParseTree(COMMA, commaList);
    }

    private static Vector getCommaList(Vector tokens) {
        int level = 0;
        Vector commaList = new Vector();
        Vector<Token> T = new Vector<Token>();
        int i = 0;
        while (i < tokens.size()) {
            Token tk = (Token)tokens.elementAt(i);
            if (tk.isComma() && level == 0) {
                commaList.add(T);
                T = new Vector();
            } else {
                T.add(tk);
            }
            if (tk.isLeftParen()) {
                ++level;
            } else if (tk.isRightParen()) {
                --level;
            }
            ++i;
        }
        commaList.add(T);
        return commaList;
    }

    private static ParseTree parseSemiColon(Vector tokens) throws BadSyntaxException {
        Vector<Cloneable> cmds = new Vector<Cloneable>();
        Vector<Token> T = new Vector<Token>();
        int i = 0;
        while (i < tokens.size()) {
            Token tk = (Token)tokens.elementAt(i);
            if (tk.isSemiColon()) {
                cmds.addElement(T);
                T = new Vector();
            } else {
                T.add(tk);
            }
            ++i;
        }
        cmds.addElement(T);
        i = 0;
        while (i < cmds.size()) {
            cmds.setElementAt(CalcParser.parseAtom((Vector)cmds.elementAt(i)), i);
            ++i;
        }
        return new ParseTree(SEMICOLON, cmds);
    }
}

