/*
 * Decompiled with CFR 0.152.
 */
package net.gcalc.calc.models;

import java.awt.Color;
import java.awt.Image;
import java.awt.image.BufferedImage;
import net.gcalc.calc.main.HackHack;
import net.gcalc.calc.math.functions.Function;
import net.gcalc.calc.models.Model;
import net.gcalc.plugin.gui.AbstractCartesianGraphPlugin;
import net.gcalc.plugin.gui.ModelEditingDialog;

public class RenderableModel
extends Model {
    private BufferedImage image;
    private BufferedImage thumbnailImage;
    private boolean drawn = false;

    public RenderableModel(Function f) {
        super(f);
    }

    public RenderableModel(Function f, String s) {
        super(f, s);
    }

    public RenderableModel(Function[] f, String[] s) {
        super(f, s);
    }

    public void setImage(BufferedImage im) {
        this.image = im;
    }

    public void setThumbnailImage(BufferedImage im) {
        this.thumbnailImage = im;
    }

    public BufferedImage getImage() {
        return this.image;
    }

    public synchronized Image getThumbnailImage(int w, int h) {
        if (this.thumbnailImage == null) {
            if (this.getImage() != null) {
                return HackHack.generateThumbnailImage(this.getImage(), w, h);
            }
            return null;
        }
        return this.thumbnailImage.getScaledInstance(w, h, 4);
    }

    public ModelEditingDialog getEditingDialog(AbstractCartesianGraphPlugin plugin) {
        return new ModelEditingDialog(plugin, this);
    }

    public Color getColor() {
        return Color.black;
    }

    public void setDrawn(boolean t) {
        this.drawn = t;
    }

    public boolean isDrawn() {
        return this.drawn;
    }
}

