/*
 * Decompiled with CFR 0.152.
 */
package net.gcalc.calc.math.functions;

import java.util.Vector;
import net.gcalc.calc.main.SymbolTable;
import net.gcalc.calc.main.ValueTable;
import net.gcalc.calc.math.functions.Function;
import net.gcalc.calc.math.functions.FunctionFactory;
import net.gcalc.calc.math.functions.VariableArityFunction;
import net.gcalc.calc.parser.ParseTree;

public class Product
extends VariableArityFunction {
    public Product(ParseTree pt) {
        super(pt);
        this.IDENTITY = ONE;
    }

    public double evaluate(SymbolTable st, ValueTable vt) {
        if (this.getNumberOfArgs() == 0) {
            return 1.0;
        }
        double p = 1.0;
        Vector args = this.getArgs();
        int i = 0;
        while (i < args.size()) {
            double t = ((Function)args.elementAt(i)).evaluate(st, vt);
            if (Double.isNaN(t)) {
                return t;
            }
            p *= t;
            ++i;
        }
        return p;
    }

    public Function derivative(Vector vars) {
        int n = this.getNumberOfArgs();
        Vector<Function> sumArgs = new Vector<Function>(n);
        Vector<Function> prodArgs = null;
        Function temp = null;
        int i = 0;
        while (i < n) {
            prodArgs = new Vector<Function>(n);
            int j = 0;
            while (j < n) {
                temp = i == j ? ((Function)this.getArg(j)).derivative(vars) : (Function)this.getArg(j);
                prodArgs.add(temp);
                ++j;
            }
            sumArgs.add(FunctionFactory.getFunction(this.getRoot(), prodArgs).simplify());
            ++i;
        }
        return FunctionFactory.getFunction(SUM_TOKEN, sumArgs).simplify();
    }

    public boolean isIdentity(Function f) {
        return f.isOne();
    }

    public Function simplify() {
        Vector args = this.getArgs();
        int i = 0;
        while (i < args.size()) {
            Function f = (Function)args.elementAt(i);
            if (f.isZero()) {
                return ZERO;
            }
            ++i;
        }
        return super.simplify();
    }

    public void addToArguments(Vector dst, Function f) {
        if (f.isOne()) {
            return;
        }
        super.addToArguments(dst, f);
    }
}

