/*
 * Decompiled with CFR 0.152.
 */
package net.gcalc.calc.math.functions;

import java.util.Vector;
import net.gcalc.calc.math.functions.BooleanOperation;
import net.gcalc.calc.math.functions.Constant;
import net.gcalc.calc.math.functions.Function;
import net.gcalc.calc.math.functions.FunctionFactory;
import net.gcalc.calc.parser.BadSyntaxRuntimeException;
import net.gcalc.calc.parser.ParseTree;

public abstract class BinaryBooleanOperation
extends BooleanOperation {
    protected Function L;
    protected Function R;
    protected boolean DEBUG = false;

    protected BinaryBooleanOperation(ParseTree pt) {
        this(pt, false);
    }

    protected BinaryBooleanOperation(ParseTree pt, boolean booleanInput) {
        super(pt);
        Vector args = this.getArgs();
        int i = 0;
        while (i < 2) {
            args.set(i, FunctionFactory.getFunction((ParseTree)args.elementAt(i)));
            ++i;
        }
        this.L = (Function)args.elementAt(0);
        this.R = (Function)args.elementAt(1);
        if (booleanInput) {
            if (!(this.L instanceof BooleanOperation)) {
                throw new BadSyntaxRuntimeException("BinaryBooleanOperation is expecting a boolean argument.");
            }
            if (!(this.R instanceof BooleanOperation)) {
                throw new BadSyntaxRuntimeException("BinaryBooleanOperation is expecting a boolean argument.");
            }
        }
    }

    public boolean isConstant() {
        return this.L.isConstant() && this.R.isConstant();
    }

    public Function simplify() {
        if (this.simpleVersion != null) {
            return this.simpleVersion;
        }
        if (this.isConstant()) {
            this.simpleVersion = new Constant(this.evaluate());
            return this.simpleVersion;
        }
        this.simpleVersion = FunctionFactory.getFunction(this.getRoot(), this.L.simplify(), this.R.simplify());
        return this.simpleVersion;
    }
}

