/*
 * Decompiled with CFR 0.152.
 */
package net.gcalc.calc.gui.gradient;

import java.awt.Color;

public abstract class Gradient {
    public static final int HSB_MODE = 1;
    public static final int RGB_MODE = 0;
    private int mode;

    protected Gradient(int m) {
        this.setMode(m);
    }

    public int getMode() {
        return this.mode;
    }

    public void setMode(int m) {
        this.mode = m;
    }

    public abstract Color getColor(double var1);

    protected float[] getHSB(Color c, float[] hsbvals) {
        return Color.RGBtoHSB(c.getRed(), c.getGreen(), c.getBlue(), hsbvals);
    }

    public Color[] getPalette(int num) {
        if (num < 2) {
            throw new IllegalArgumentException("Cannot provide a palette with " + num + " colors.");
        }
        Color[] palette = new Color[num];
        double max = num - 1;
        int i = 0;
        while (i < palette.length) {
            palette[i] = this.getColor((double)i / max);
            ++i;
        }
        return palette;
    }
}

