/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.mrtg.server;

import java.io.IOException;
import org.jrobin.mrtg.Debug;
import org.jrobin.mrtg.MrtgException;
import org.jrobin.mrtg.server.Device;
import org.jrobin.mrtg.server.Poller;
import org.jrobin.mrtg.server.Port;
import org.jrobin.mrtg.server.RawSample;

class SnmpReader
extends Thread {
    static final int RECONFIGURE_RETRIES = 3;
    private Device router;
    private Port link;
    private Poller comm;

    SnmpReader(Device device, Port port) {
        this.setDaemon(true);
        port.setSampling(true);
        this.router = device;
        this.link = port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        block11: {
            try {
                block10: {
                    try {
                        this.comm = new Poller(this.router.getHost(), this.router.getCommunity());
                        if (this.link.getIfIndex() < 0) {
                            this.findIfIndex();
                        }
                        if (this.link.getIfIndex() < 0) break block10;
                        Debug.print("Sampling: " + this.link.getIfDescr() + "@" + this.router.getHost() + " [" + this.link.getIfIndex() + "]");
                        int n = this.link.getIfIndex();
                        String[] stringArray = new String[]{"sysUpTime", "ifDescr." + n, "ifInOctets." + n, "ifOutOctets." + n, "ifOperStatus." + n};
                        String[] stringArray2 = this.comm.get(stringArray);
                        RawSample rawSample = this.createRawSample(stringArray2);
                        this.link.processSample(rawSample);
                    }
                    catch (IOException iOException) {
                        Debug.print("IOException on " + this.getLabel() + ": " + iOException);
                        Object var6_8 = null;
                        if (this.comm != null) {
                            this.comm.close();
                        }
                        this.link.setSampling(false);
                        break block11;
                    }
                    catch (MrtgException mrtgException) {
                        Debug.print("MrtgException on " + this.getLabel() + ": " + mrtgException);
                        Object var6_9 = null;
                        if (this.comm != null) {
                            this.comm.close();
                        }
                        this.link.setSampling(false);
                    }
                }
                Object var6_7 = null;
                if (this.comm != null) {
                    this.comm.close();
                }
                this.link.setSampling(false);
            }
            catch (Throwable throwable) {
                Object var6_10 = null;
                if (this.comm != null) {
                    this.comm.close();
                }
                this.link.setSampling(false);
                throw throwable;
            }
        }
    }

    private void findIfIndex() throws MrtgException {
        for (int i = 0; i < 3; ++i) {
            try {
                int n = this.comm.getIfIndexByIfDescr(this.link.getIfDescr());
                if (n >= 0) {
                    String string = this.comm.get("ifAlias", n);
                    this.link.setIfAlias(string);
                    this.link.switchToIfIndex(n);
                    return;
                }
                break;
            }
            catch (IOException iOException) {
                Debug.print("IOError while reconfiguring " + this.getLabel() + ": " + iOException);
                continue;
            }
        }
        this.link.deactivate();
        Debug.print("Link " + this.getLabel() + " not found, link deactivated");
    }

    private RawSample createRawSample(String[] stringArray) {
        RawSample rawSample = new RawSample();
        rawSample.setHost(this.router.getHost());
        if (stringArray[0] != null) {
            rawSample.setSysUpTime(Long.parseLong(stringArray[0]));
        }
        if (stringArray[1] != null) {
            rawSample.setIfDescr(stringArray[1]);
        }
        if (stringArray[2] != null) {
            rawSample.setIfInOctets(Long.parseLong(stringArray[2]));
        }
        if (stringArray[3] != null) {
            rawSample.setIfOutOctets(Long.parseLong(stringArray[3]));
        }
        if (stringArray[4] != null) {
            rawSample.setIfOperStatus(Integer.parseInt(stringArray[4]));
        }
        return rawSample;
    }

    String getLabel() {
        return this.link.getIfDescr() + "@" + this.router.getHost();
    }
}

