/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.mrtg.server;

import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.xmlrpc.WebServer;
import org.jrobin.mrtg.Debug;
import org.jrobin.mrtg.MrtgConstants;
import org.jrobin.mrtg.MrtgException;
import org.jrobin.mrtg.server.Device;
import org.jrobin.mrtg.server.Server;

class Listener
implements MrtgConstants {
    private WebServer webServer = new WebServer(35353);

    Listener(String[] stringArray) {
        this.webServer.addHandler("mrtg", new EventHandler());
        if (stringArray != null && stringArray.length > 0) {
            this.webServer.setParanoid(true);
            for (int i = 0; i < stringArray.length; ++i) {
                this.webServer.acceptClient(stringArray[i]);
            }
        }
        this.webServer.start();
        Debug.print("XmlRpcServer started on port 35353");
    }

    void terminate() {
        if (this.webServer != null) {
            this.webServer.shutdown();
            Debug.print("XmlRpcServer closed");
            this.webServer = null;
        }
    }

    protected void finalize() {
        this.terminate();
    }

    public class EventHandler {
        public int addRouter(String string, String string2, String string3, boolean bl) {
            try {
                int n = Server.getInstance().addRouter(string, string2, string3, bl);
                Debug.print("Router " + string + " added [" + n + "]");
                return n;
            }
            catch (MrtgException mrtgException) {
                Debug.print("Event handler error: " + mrtgException);
                return -10;
            }
        }

        public int updateRouter(String string, String string2, String string3, boolean bl) {
            try {
                int n = Server.getInstance().updateRouter(string, string2, string3, bl);
                Debug.print("Router " + string + " updated [" + n + "]");
                return n;
            }
            catch (MrtgException mrtgException) {
                Debug.print("Event handler error: " + mrtgException);
                return -10;
            }
        }

        public int removeRouter(String string) {
            try {
                int n = Server.getInstance().removeRouter(string);
                Debug.print("Router " + string + " removed [" + n + "]");
                return n;
            }
            catch (MrtgException mrtgException) {
                Debug.print("Event handler error: " + mrtgException);
                return -10;
            }
        }

        public int addLink(String string, String string2, String string3, int n, boolean bl) {
            try {
                int n2 = Server.getInstance().addLink(string, string2, string3, n, bl);
                Debug.print("Interface " + string2 + "@" + string + " added [" + n2 + "]");
                return n2;
            }
            catch (MrtgException mrtgException) {
                Debug.print("Event handler error: " + mrtgException);
                return -10;
            }
        }

        public int updateLink(String string, String string2, String string3, int n, boolean bl) {
            try {
                int n2 = Server.getInstance().updateLink(string, string2, string3, n, bl);
                Debug.print("Interface " + string2 + "@" + string + " updated [" + n2 + "]");
                return n2;
            }
            catch (MrtgException mrtgException) {
                Debug.print("Event handler error: " + mrtgException);
                return -10;
            }
        }

        public int removeLink(String string, String string2) {
            try {
                int n = Server.getInstance().removeLink(string, string2);
                Debug.print("Interface " + string2 + "@" + string + " removed [" + n + "]");
                return n;
            }
            catch (MrtgException mrtgException) {
                Debug.print("Event handler error: " + mrtgException);
                return -10;
            }
        }

        public byte[] getPngGraph(String string, String string2, Date date, Date date2) {
            byte[] byArray = new byte[]{};
            long l = date.getTime() / 1000L;
            long l2 = date2.getTime() / 1000L;
            try {
                byArray = Server.getInstance().getPngGraph(string, string2, l, l2);
            }
            catch (MrtgException mrtgException) {
                Debug.print("Event handler error: " + mrtgException);
            }
            Debug.print("Graph for interface " + string2 + "@" + string + " generated [" + byArray.length + " bytes]");
            return byArray;
        }

        public Vector getAvailableLinks(String string) {
            Vector<String> vector = new Vector<String>();
            try {
                String[] stringArray = Server.getInstance().getAvailableLinks(string);
                for (int i = 0; i < stringArray.length; ++i) {
                    vector.add(stringArray[i]);
                }
            }
            catch (MrtgException mrtgException) {
                Debug.print("Event handler error: " + mrtgException);
            }
            Debug.print(vector.size() + " interfaces found on " + string);
            return vector;
        }

        public Vector getRouters() {
            Vector<Hashtable> vector = new Vector<Hashtable>();
            Device[] deviceArray = Server.getInstance().getRouters();
            for (int i = 0; i < deviceArray.length; ++i) {
                vector.add(deviceArray[i].getRouterInfo());
            }
            Debug.print("Sending router data [" + vector.size() + " routers found]");
            return vector;
        }

        public Hashtable getServerInfo() {
            Hashtable hashtable = new Hashtable();
            Server server = Server.getInstance();
            hashtable = server.getServerInfo();
            Debug.print("Sending MRTG server info");
            return hashtable;
        }

        public Hashtable getMrtgInfo() {
            Hashtable<String, Cloneable> hashtable = new Hashtable<String, Cloneable>();
            hashtable.put("serverInfo", this.getServerInfo());
            hashtable.put("routers", this.getRouters());
            return hashtable;
        }
    }
}

