// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/workstations/v1/workstations.proto

#include "google/cloud/workstations/v1/workstations_connection_idempotency_policy.h"
#include <memory>

namespace google {
namespace cloud {
namespace workstations_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

using ::google::cloud::Idempotency;

WorkstationsConnectionIdempotencyPolicy::
    ~WorkstationsConnectionIdempotencyPolicy() = default;

std::unique_ptr<WorkstationsConnectionIdempotencyPolicy>
WorkstationsConnectionIdempotencyPolicy::clone() const {
  return std::make_unique<WorkstationsConnectionIdempotencyPolicy>(*this);
}

Idempotency WorkstationsConnectionIdempotencyPolicy::GetWorkstationCluster(
    google::cloud::workstations::v1::GetWorkstationClusterRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency WorkstationsConnectionIdempotencyPolicy::ListWorkstationClusters(
    google::cloud::workstations::v1::
        ListWorkstationClustersRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency WorkstationsConnectionIdempotencyPolicy::CreateWorkstationCluster(
    google::cloud::workstations::v1::CreateWorkstationClusterRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency WorkstationsConnectionIdempotencyPolicy::UpdateWorkstationCluster(
    google::cloud::workstations::v1::UpdateWorkstationClusterRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency WorkstationsConnectionIdempotencyPolicy::DeleteWorkstationCluster(
    google::cloud::workstations::v1::DeleteWorkstationClusterRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency WorkstationsConnectionIdempotencyPolicy::GetWorkstationConfig(
    google::cloud::workstations::v1::GetWorkstationConfigRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency WorkstationsConnectionIdempotencyPolicy::ListWorkstationConfigs(
    google::cloud::workstations::v1::ListWorkstationConfigsRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency
WorkstationsConnectionIdempotencyPolicy::ListUsableWorkstationConfigs(
    google::cloud::workstations::v1::
        ListUsableWorkstationConfigsRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency WorkstationsConnectionIdempotencyPolicy::CreateWorkstationConfig(
    google::cloud::workstations::v1::CreateWorkstationConfigRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency WorkstationsConnectionIdempotencyPolicy::UpdateWorkstationConfig(
    google::cloud::workstations::v1::UpdateWorkstationConfigRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency WorkstationsConnectionIdempotencyPolicy::DeleteWorkstationConfig(
    google::cloud::workstations::v1::DeleteWorkstationConfigRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency WorkstationsConnectionIdempotencyPolicy::GetWorkstation(
    google::cloud::workstations::v1::GetWorkstationRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency WorkstationsConnectionIdempotencyPolicy::ListWorkstations(
    google::cloud::workstations::v1::ListWorkstationsRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency WorkstationsConnectionIdempotencyPolicy::ListUsableWorkstations(
    google::cloud::workstations::v1::ListUsableWorkstationsRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency WorkstationsConnectionIdempotencyPolicy::CreateWorkstation(
    google::cloud::workstations::v1::CreateWorkstationRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency WorkstationsConnectionIdempotencyPolicy::UpdateWorkstation(
    google::cloud::workstations::v1::UpdateWorkstationRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency WorkstationsConnectionIdempotencyPolicy::DeleteWorkstation(
    google::cloud::workstations::v1::DeleteWorkstationRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency WorkstationsConnectionIdempotencyPolicy::StartWorkstation(
    google::cloud::workstations::v1::StartWorkstationRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency WorkstationsConnectionIdempotencyPolicy::StopWorkstation(
    google::cloud::workstations::v1::StopWorkstationRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency WorkstationsConnectionIdempotencyPolicy::GenerateAccessToken(
    google::cloud::workstations::v1::GenerateAccessTokenRequest const&) {
  return Idempotency::kNonIdempotent;
}

std::unique_ptr<WorkstationsConnectionIdempotencyPolicy>
MakeDefaultWorkstationsConnectionIdempotencyPolicy() {
  return std::make_unique<WorkstationsConnectionIdempotencyPolicy>();
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace workstations_v1
}  // namespace cloud
}  // namespace google
