// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/devtools/cloudtrace/v2/tracing.proto

#include "google/cloud/trace/v2/internal/trace_tracing_connection.h"
#include "google/cloud/internal/opentelemetry.h"
#include <memory>

namespace google {
namespace cloud {
namespace trace_v2_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

TraceServiceTracingConnection::TraceServiceTracingConnection(
    std::shared_ptr<trace_v2::TraceServiceConnection> child)
    : child_(std::move(child)) {}

Status TraceServiceTracingConnection::BatchWriteSpans(
    google::devtools::cloudtrace::v2::BatchWriteSpansRequest const& request) {
  auto span =
      internal::MakeSpan("trace_v2::TraceServiceConnection::BatchWriteSpans");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->BatchWriteSpans(request));
}

StatusOr<google::devtools::cloudtrace::v2::Span>
TraceServiceTracingConnection::CreateSpan(
    google::devtools::cloudtrace::v2::Span const& request) {
  auto span =
      internal::MakeSpan("trace_v2::TraceServiceConnection::CreateSpan");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->CreateSpan(request));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<trace_v2::TraceServiceConnection>
MakeTraceServiceTracingConnection(
    std::shared_ptr<trace_v2::TraceServiceConnection> conn) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  if (internal::TracingEnabled(conn->options())) {
    conn = std::make_shared<TraceServiceTracingConnection>(std::move(conn));
  }
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return conn;
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace trace_v2_internal
}  // namespace cloud
}  // namespace google
