// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/devtools/cloudtrace/v1/trace.proto

#include "google/cloud/trace/v1/trace_client.h"
#include <memory>

namespace google {
namespace cloud {
namespace trace_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

TraceServiceClient::TraceServiceClient(
    std::shared_ptr<TraceServiceConnection> connection, Options opts)
    : connection_(std::move(connection)),
      options_(
          internal::MergeOptions(std::move(opts), connection_->options())) {}
TraceServiceClient::~TraceServiceClient() = default;

StreamRange<google::devtools::cloudtrace::v1::Trace>
TraceServiceClient::ListTraces(std::string const& project_id, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::devtools::cloudtrace::v1::ListTracesRequest request;
  request.set_project_id(project_id);
  return connection_->ListTraces(request);
}

StreamRange<google::devtools::cloudtrace::v1::Trace>
TraceServiceClient::ListTraces(
    google::devtools::cloudtrace::v1::ListTracesRequest request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListTraces(std::move(request));
}

StatusOr<google::devtools::cloudtrace::v1::Trace> TraceServiceClient::GetTrace(
    std::string const& project_id, std::string const& trace_id, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::devtools::cloudtrace::v1::GetTraceRequest request;
  request.set_project_id(project_id);
  request.set_trace_id(trace_id);
  return connection_->GetTrace(request);
}

StatusOr<google::devtools::cloudtrace::v1::Trace> TraceServiceClient::GetTrace(
    google::devtools::cloudtrace::v1::GetTraceRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetTrace(request);
}

Status TraceServiceClient::PatchTraces(
    std::string const& project_id,
    google::devtools::cloudtrace::v1::Traces const& traces, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::devtools::cloudtrace::v1::PatchTracesRequest request;
  request.set_project_id(project_id);
  *request.mutable_traces() = traces;
  return connection_->PatchTraces(request);
}

Status TraceServiceClient::PatchTraces(
    google::devtools::cloudtrace::v1::PatchTracesRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->PatchTraces(request);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace trace_v1
}  // namespace cloud
}  // namespace google
