// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/scheduler/v1/cloudscheduler.proto

#include "google/cloud/scheduler/v1/internal/cloud_scheduler_option_defaults.h"
#include "google/cloud/scheduler/v1/cloud_scheduler_connection.h"
#include "google/cloud/scheduler/v1/cloud_scheduler_options.h"
#include "google/cloud/internal/populate_common_options.h"
#include "google/cloud/internal/populate_grpc_options.h"
#include <memory>

namespace google {
namespace cloud {
namespace scheduler_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

namespace {
auto constexpr kBackoffScaling = 2.0;
}  // namespace

Options CloudSchedulerDefaultOptions(Options options) {
  options = google::cloud::internal::PopulateCommonOptions(
      std::move(options), "GOOGLE_CLOUD_CPP_CLOUD_SCHEDULER_ENDPOINT", "",
      "GOOGLE_CLOUD_CPP_CLOUD_SCHEDULER_AUTHORITY",
      "cloudscheduler.googleapis.com");
  options =
      google::cloud::internal::PopulateGrpcOptions(std::move(options), "");
  if (!options.has<scheduler_v1::CloudSchedulerRetryPolicyOption>()) {
    options.set<scheduler_v1::CloudSchedulerRetryPolicyOption>(
        scheduler_v1::CloudSchedulerLimitedTimeRetryPolicy(
            std::chrono::minutes(30))
            .clone());
  }
  if (!options.has<scheduler_v1::CloudSchedulerBackoffPolicyOption>()) {
    options.set<scheduler_v1::CloudSchedulerBackoffPolicyOption>(
        ExponentialBackoffPolicy(
            std::chrono::seconds(0), std::chrono::seconds(1),
            std::chrono::minutes(5), kBackoffScaling, kBackoffScaling)
            .clone());
  }
  if (!options.has<
          scheduler_v1::CloudSchedulerConnectionIdempotencyPolicyOption>()) {
    options.set<scheduler_v1::CloudSchedulerConnectionIdempotencyPolicyOption>(
        scheduler_v1::MakeDefaultCloudSchedulerConnectionIdempotencyPolicy());
  }

  return options;
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace scheduler_v1_internal
}  // namespace cloud
}  // namespace google
