// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/pubsub/v1/pubsub.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_PUBSUB_ADMIN_SUBSCRIPTION_ADMIN_CONNECTION_IDEMPOTENCY_POLICY_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_PUBSUB_ADMIN_SUBSCRIPTION_ADMIN_CONNECTION_IDEMPOTENCY_POLICY_H

#include "google/cloud/idempotency.h"
#include "google/cloud/version.h"
#include <google/pubsub/v1/pubsub.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace pubsub_admin {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

class SubscriptionAdminConnectionIdempotencyPolicy {
 public:
  virtual ~SubscriptionAdminConnectionIdempotencyPolicy();

  /// Create a new copy of this object.
  virtual std::unique_ptr<SubscriptionAdminConnectionIdempotencyPolicy> clone()
      const;

  virtual google::cloud::Idempotency CreateSubscription(
      google::pubsub::v1::Subscription const& request);

  virtual google::cloud::Idempotency GetSubscription(
      google::pubsub::v1::GetSubscriptionRequest const& request);

  virtual google::cloud::Idempotency UpdateSubscription(
      google::pubsub::v1::UpdateSubscriptionRequest const& request);

  virtual google::cloud::Idempotency ListSubscriptions(
      google::pubsub::v1::ListSubscriptionsRequest request);

  virtual google::cloud::Idempotency DeleteSubscription(
      google::pubsub::v1::DeleteSubscriptionRequest const& request);

  virtual google::cloud::Idempotency ModifyPushConfig(
      google::pubsub::v1::ModifyPushConfigRequest const& request);

  virtual google::cloud::Idempotency GetSnapshot(
      google::pubsub::v1::GetSnapshotRequest const& request);

  virtual google::cloud::Idempotency ListSnapshots(
      google::pubsub::v1::ListSnapshotsRequest request);

  virtual google::cloud::Idempotency CreateSnapshot(
      google::pubsub::v1::CreateSnapshotRequest const& request);

  virtual google::cloud::Idempotency UpdateSnapshot(
      google::pubsub::v1::UpdateSnapshotRequest const& request);

  virtual google::cloud::Idempotency DeleteSnapshot(
      google::pubsub::v1::DeleteSnapshotRequest const& request);

  virtual google::cloud::Idempotency Seek(
      google::pubsub::v1::SeekRequest const& request);
};

std::unique_ptr<SubscriptionAdminConnectionIdempotencyPolicy>
MakeDefaultSubscriptionAdminConnectionIdempotencyPolicy();

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace pubsub_admin
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_PUBSUB_ADMIN_SUBSCRIPTION_ADMIN_CONNECTION_IDEMPOTENCY_POLICY_H
