// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/devtools/cloudprofiler/v2/profiler.proto

#include "google/cloud/profiler/v2/profiler_client.h"
#include <memory>

namespace google {
namespace cloud {
namespace profiler_v2 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

ProfilerServiceClient::ProfilerServiceClient(
    std::shared_ptr<ProfilerServiceConnection> connection, Options opts)
    : connection_(std::move(connection)),
      options_(
          internal::MergeOptions(std::move(opts), connection_->options())) {}
ProfilerServiceClient::~ProfilerServiceClient() = default;

StatusOr<google::devtools::cloudprofiler::v2::Profile>
ProfilerServiceClient::CreateProfile(
    google::devtools::cloudprofiler::v2::CreateProfileRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateProfile(request);
}

StatusOr<google::devtools::cloudprofiler::v2::Profile>
ProfilerServiceClient::CreateOfflineProfile(
    std::string const& parent,
    google::devtools::cloudprofiler::v2::Profile const& profile, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::devtools::cloudprofiler::v2::CreateOfflineProfileRequest request;
  request.set_parent(parent);
  *request.mutable_profile() = profile;
  return connection_->CreateOfflineProfile(request);
}

StatusOr<google::devtools::cloudprofiler::v2::Profile>
ProfilerServiceClient::CreateOfflineProfile(
    google::devtools::cloudprofiler::v2::CreateOfflineProfileRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateOfflineProfile(request);
}

StatusOr<google::devtools::cloudprofiler::v2::Profile>
ProfilerServiceClient::UpdateProfile(
    google::devtools::cloudprofiler::v2::Profile const& profile,
    google::protobuf::FieldMask const& update_mask, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::devtools::cloudprofiler::v2::UpdateProfileRequest request;
  *request.mutable_profile() = profile;
  *request.mutable_update_mask() = update_mask;
  return connection_->UpdateProfile(request);
}

StatusOr<google::devtools::cloudprofiler::v2::Profile>
ProfilerServiceClient::UpdateProfile(
    google::devtools::cloudprofiler::v2::UpdateProfileRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateProfile(request);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace profiler_v2
}  // namespace cloud
}  // namespace google
