// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/policytroubleshooter/iam/v3/troubleshooter.proto

#include "google/cloud/policytroubleshooter/iam/v3/policy_troubleshooter_connection.h"
#include "google/cloud/policytroubleshooter/iam/v3/internal/policy_troubleshooter_connection_impl.h"
#include "google/cloud/policytroubleshooter/iam/v3/internal/policy_troubleshooter_option_defaults.h"
#include "google/cloud/policytroubleshooter/iam/v3/internal/policy_troubleshooter_stub_factory.h"
#include "google/cloud/policytroubleshooter/iam/v3/internal/policy_troubleshooter_tracing_connection.h"
#include "google/cloud/policytroubleshooter/iam/v3/policy_troubleshooter_options.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/credentials.h"
#include "google/cloud/grpc_options.h"
#include <memory>

namespace google {
namespace cloud {
namespace policytroubleshooter_iam_v3 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

PolicyTroubleshooterConnection::~PolicyTroubleshooterConnection() = default;

StatusOr<
    google::cloud::policytroubleshooter::iam::v3::TroubleshootIamPolicyResponse>
PolicyTroubleshooterConnection::TroubleshootIamPolicy(
    google::cloud::policytroubleshooter::iam::v3::
        TroubleshootIamPolicyRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

std::shared_ptr<PolicyTroubleshooterConnection>
MakePolicyTroubleshooterConnection(Options options) {
  internal::CheckExpectedOptions<CommonOptionList, GrpcOptionList,
                                 UnifiedCredentialsOptionList,
                                 PolicyTroubleshooterPolicyOptionList>(
      options, __func__);
  options =
      policytroubleshooter_iam_v3_internal::PolicyTroubleshooterDefaultOptions(
          std::move(options));
  auto background = internal::MakeBackgroundThreadsFactory(options)();
  auto stub = policytroubleshooter_iam_v3_internal::
      CreateDefaultPolicyTroubleshooterStub(background->cq(), options);
  return policytroubleshooter_iam_v3_internal::
      MakePolicyTroubleshooterTracingConnection(
          std::make_shared<policytroubleshooter_iam_v3_internal::
                               PolicyTroubleshooterConnectionImpl>(
              std::move(background), std::move(stub), std::move(options)));
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace policytroubleshooter_iam_v3
}  // namespace cloud
}  // namespace google
