// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/monitoring/v3/snooze_service.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_MONITORING_V3_INTERNAL_SNOOZE_TRACING_CONNECTION_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_MONITORING_V3_INTERNAL_SNOOZE_TRACING_CONNECTION_H

#include "google/cloud/monitoring/v3/snooze_connection.h"
#include "google/cloud/version.h"
#include <memory>

namespace google {
namespace cloud {
namespace monitoring_v3_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

class SnoozeServiceTracingConnection
    : public monitoring_v3::SnoozeServiceConnection {
 public:
  ~SnoozeServiceTracingConnection() override = default;

  explicit SnoozeServiceTracingConnection(
      std::shared_ptr<monitoring_v3::SnoozeServiceConnection> child);

  Options options() override { return child_->options(); }

  StatusOr<google::monitoring::v3::Snooze> CreateSnooze(
      google::monitoring::v3::CreateSnoozeRequest const& request) override;

  StreamRange<google::monitoring::v3::Snooze> ListSnoozes(
      google::monitoring::v3::ListSnoozesRequest request) override;

  StatusOr<google::monitoring::v3::Snooze> GetSnooze(
      google::monitoring::v3::GetSnoozeRequest const& request) override;

  StatusOr<google::monitoring::v3::Snooze> UpdateSnooze(
      google::monitoring::v3::UpdateSnoozeRequest const& request) override;

 private:
  std::shared_ptr<monitoring_v3::SnoozeServiceConnection> child_;
};

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

/**
 * Conditionally applies the tracing decorator to the given connection.
 *
 * The connection is only decorated if tracing is enabled (as determined by the
 * connection's options).
 */
std::shared_ptr<monitoring_v3::SnoozeServiceConnection>
MakeSnoozeServiceTracingConnection(
    std::shared_ptr<monitoring_v3::SnoozeServiceConnection> conn);

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace monitoring_v3_internal
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_MONITORING_V3_INTERNAL_SNOOZE_TRACING_CONNECTION_H
